/**
 * Copyright (c) 2012 - 2022 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package com.playertour.backend.config.firebaseremoteconfig.service.api;

import java.util.Optional;

import org.osgi.annotation.versioning.ProviderType;

import com.google.firebase.remoteconfig.Parameter;
import com.google.firebase.remoteconfig.ParameterGroup;

@ProviderType
public interface FirebaseRemoteConfigService {

	Optional<ParameterGroup> getParameterGroup(String parameterGroupName);

	Optional<Parameter> getParameter(String parameterName);

	Optional<Parameter> getParameter(String parameterGroupName, String parameterName);

	Optional<Boolean> getBooleanParameterValue(String parameterGroupName, String parameterName,
			String conditionalValueName);

	Optional<String> getStringParameterValue(String parameterGroupName, String parameterName,
			String conditionalValueName);

	Optional<Number> getNumberParameterValue(String parameterGroupName, String parameterName,
			String conditionalValueName);

	Optional<Double> getDoubleParameterValue(String parameterGroupName, String parameterName);

	boolean setBooleanParameterValue(String parameterGroupName, String parameterName, String conditionalValueName,
			boolean parameterValue, boolean parameterDefaultValue);

	boolean setStringParameterValue(String parameterGroupName, String parameterName, String conditionalValueName,
			String parameterValue, String parameterDefaultValue);

	boolean setNumberParameterValue(String parameterGroupName, String parameterName, String conditionalValueName,
			Number parameterValue, Number parameterDefaultValue);

	boolean setDoubleParameterValue(String parameterGroupName, String parameterName, Double parameterValue);

	boolean setDateTimeCondition(String conditionName, String dateTime);
}
