/**
 * Copyright (c) 2012 - 2018 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package com.playertour.backend.country.tests;

import static org.assertj.core.api.Assertions.assertThat;

import java.util.UUID;

import org.gecko.search.api.IndexActionType;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.test.common.annotation.InjectBundleContext;
import org.osgi.test.common.annotation.InjectService;
import org.osgi.test.common.service.ServiceAware;
import org.osgi.test.junit5.context.BundleContextExtension;
import org.osgi.test.junit5.service.ServiceExtension;

import com.playertour.backend.apis.common.CommonIndexService;
import com.playertour.backend.apis.country.CountryIndexService;
import com.playertour.backend.apis.country.CountrySearchService;
import com.playertour.backend.country.model.country.Country;
import com.playertour.backend.country.model.country.CountryFactory;


/**
 * Tests the implementation of CountryService
 * @author ilenia
 */
@ExtendWith(BundleContextExtension.class)
@ExtendWith(ServiceExtension.class)
public class CountryIndexSearchTest{
	
	@InjectBundleContext
	BundleContext bundleContext;
	
	@Test
	public void testServices(@InjectService(cardinality = 1, timeout = 500) ServiceAware<CountryIndexService> indexAware, 
			@InjectService(cardinality = 1, timeout = 500) ServiceAware<CountrySearchService> searchAware) {
		
		assertThat(indexAware.getServices()).hasSize(1);	
		ServiceReference<CountryIndexService> indexReference = indexAware.getServiceReference();
		assertThat(indexReference).isNotNull();	
		
		assertThat(searchAware.getServices()).hasSize(1);	
		ServiceReference<CountrySearchService> searchReference = searchAware.getServiceReference();
		assertThat(searchReference).isNotNull();	
	}
	
	@Test
	public void testCountryIdIndex(@InjectService(cardinality = 1, timeout = 500) ServiceAware<CountryIndexService> indexAware, 
			@InjectService(cardinality = 1, timeout = 500) ServiceAware<CountrySearchService> searchAware) throws InterruptedException {
		
		assertThat(indexAware.getServices()).hasSize(1);	
		CountryIndexService indexService = indexAware.getService();
		assertThat(indexService).isNotNull();	
		
		assertThat(searchAware.getServices()).hasSize(1);	
		CountrySearchService searchService = searchAware.getService();
		assertThat(searchService).isNotNull();		
		
		Country country = CountryFactory.eINSTANCE.createCountry();
		country.setId(UUID.randomUUID().toString());
		country.setCountryId("77");
		
		indexService.indexCountry(country, IndexActionType.ADD);
		
		Thread.sleep(2000);
		
		Country searchRes = searchService.getCountryByCountryId(country.getCountryId());
		assertThat(searchRes).isNotNull();
		assertThat(searchRes.getId()).isEqualTo(country.getId());
		assertThat(searchRes.getCountryId()).isEqualTo(country.getCountryId());
	}
	
	
	@AfterEach
	public void doAfterEach(@InjectService(cardinality = 1, timeout = 500) ServiceAware<CommonIndexService> indexAware) {
		
		assertThat(indexAware.getServices()).hasSize(1);	
		CommonIndexService indexService = indexAware.getService();
		assertThat(indexService).isNotNull();		
		
		indexService.resetIndex();
	}
}
