/**
 * Copyright (c) 2012 - 2021 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package com.playertour.backend.country.helper;

import java.util.Collections;

import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.gecko.search.api.IndexActionType;
import org.gecko.search.document.DocumentIndexContextObject;
import org.gecko.search.document.DocumentIndexContextObjectImpl;
import org.osgi.util.promise.Deferred;

import com.playertour.backend.apis.common.DeferredCommitCallback;
import com.playertour.backend.apis.common.DocumentUtil;
import com.playertour.backend.country.model.country.Country;

/**
 * 
 * @author ilenia
 * @since Feb 17, 2021
 */
public class CountryIndexHelper {

	public static DocumentIndexContextObject mapCountryNew(Country country) {
		return mapCountry(country, IndexActionType.ADD, null);
	}

	public static DocumentIndexContextObject mapCourseNew(Country country, Deferred<Boolean> deferred) {
		return mapCountry(country, IndexActionType.ADD, deferred);
	}

	public static DocumentIndexContextObject mapCourseUpdate(Country country, Deferred<Boolean> deferred) {
		return mapCountry(country, IndexActionType.MODIFY, deferred);
	}

	public static DocumentIndexContextObject mapCountry(Country country, IndexActionType indexAction, Deferred<Boolean> deferred) {
		Document doc = new Document();
		
		DocumentUtil.toDocument(doc, country);
		
		DocumentIndexContextObjectImpl.Builder builder = DocumentIndexContextObjectImpl.builder()
				.withDocuments(Collections.singletonList(doc))
				.withSourceObject(country).withIndexActionType(indexAction);

		if(IndexActionType.MODIFY.equals(indexAction) || IndexActionType.REMOVE.equals(indexAction)) {
			builder.withIdentifyingTerm(new Term("id", country.getId()));
		}
		if(deferred != null) {
			builder = builder.withCommitCallback(new DeferredCommitCallback(deferred));
		}

		return builder.build();
	}

}
