/**
 * Copyright (c) 2012 - 2021 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package com.playertour.backend.country;

import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.gecko.search.document.LuceneIndexService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;
import org.osgi.service.log.Logger;
import org.osgi.service.log.LoggerFactory;

import com.playertour.backend.apis.common.DocumentUtil;
import com.playertour.backend.apis.country.CountrySearchService;
import com.playertour.backend.country.model.country.Country;

/**
 * 
 * @author ilenia
 * @since Feb 17, 2021
 */
@Component(immediate = true, scope = ServiceScope.SINGLETON)
public class CountrySearchServiceImpl implements CountrySearchService {
	
	@Reference(target = "(id=country)")
	private LuceneIndexService countryIndex;

	@Reference
	ResourceSet resourceSet;

	@Reference(service=LoggerFactory.class)
	private Logger logger;

	/* 
	 * (non-Javadoc)
	 * @see com.playertour.backend.apis.country.CountrySearchService#getCountryById(java.lang.String)
	 */
	@Override
	public Country getCountryByCountryId(String countryId) {
		IndexSearcher searcher = countryIndex.aquireSearch();
		try {
			try {
				TopDocs topDocs = searcher.search(new TermQuery(new Term("countryId", countryId)), 1);
				if(topDocs.scoreDocs.length == 0) {
					return null;
				}
				IndexReader indexReader = searcher.getIndexReader();
				Document document = indexReader.document(topDocs.scoreDocs[0].doc);
				return (Country) DocumentUtil.toEObject(document, resourceSet);
			} catch (Exception e) {
				logger.error( "Exception while search for Country with id " + countryId, e);
				return null;
			}
		} finally {
			countryIndex.releaseSearcher(searcher);
		}
	}

}
