/**
 * Copyright (c) 2012 - 2021 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package com.playertour.backend.gamesimulator.tests;

import static org.assertj.core.api.Assertions.assertThat;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.platform.commons.annotation.Testable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.test.common.annotation.InjectBundleContext;
import org.osgi.test.common.annotation.InjectService;
import org.osgi.test.common.service.ServiceAware;
import org.osgi.test.junit5.context.BundleContextExtension;
import org.osgi.test.junit5.service.ServiceExtension;

import com.playertour.backend.apis.gamesim.GolfGameSimulationService;

@Testable
@ExtendWith(BundleContextExtension.class)
@ExtendWith(ServiceExtension.class)
public class GolfGameSimulationIntegrationTest {

	@InjectBundleContext
	BundleContext bundleContext;

	private static final String[] EIGHTEEN_HOLE_GOLF_COURSES_IDS = new String[] { "60bde67e199226dd15352288",
			"60bde67e199226dd1535228d", "60bde67e199226dd1535228e", "60bde67e199226dd1535228f",
			"60bde67e199226dd15352297", "60bde67e199226dd15352299", "60bde67e199226dd1535229a",
			"60bde67e199226dd1535229b", "60bde67e199226dd1535229d", "60bde67e199226dd1535229e" };

	private static final String[] NINE_HOLE_GOLF_COURSES_IDS = new String[] {}; // validated iGolf data contains no
																				// valid 9-hole golf courses
	
	private static final int NUMBER_OF_PLAYERS = 1;
	
	private static final String[] EXISTING_PLAYERS_LOGIN_IDS = new String[] { "QalSeDPD3T", "suUhhgGoRM", "gTB7f21th3",
			"8ReW78tzyJ", "bi7ufurIfJ" };
	
	@Test
	public void testServices(
			@InjectService(cardinality = 1, timeout = 5000) ServiceAware<GolfGameSimulationService> golfGameSimulationAware) {

		assertThat(golfGameSimulationAware.getServices()).hasSize(1);
		ServiceReference<GolfGameSimulationService> golfGameSimulationReference = golfGameSimulationAware
				.getServiceReference();
		assertThat(golfGameSimulationReference).isNotNull();
	}

//	@Test
	public void testPlayGolfGame(
			@InjectService(cardinality = 1, timeout = 5000) ServiceAware<GolfGameSimulationService> golfGameSimulationAware) {

		assertThat(golfGameSimulationAware.getServices()).hasSize(1);
		GolfGameSimulationService golfGameSimulationService = golfGameSimulationAware.getService();
		assertThat(golfGameSimulationService).isNotNull();
		
		List<String> golfCoursesIds = Arrays.asList("60bdf757199226fed8b527e0", "60bdf757199226fed8b527e1", "626fe9135fbc9fad135bf53c");
	//	List<String> golfCoursesIds = Arrays.asList("60bdf757199226fed8b527e0");
	//	List<String> golfCoursesIds = Arrays.asList(Arrays.copyOf(EIGHTEEN_HOLE_GOLF_COURSES_IDS, 1));
	//	List<String> golfCoursesIds = getCombinedGolfCourseIDs();
		
		boolean outputGameInfo = true;
		
		//boolean generatePlayers = true;
		boolean generatePlayers = false;
		int numberOfPlayersToGenerate = NUMBER_OF_PLAYERS;

	//	boolean generatePlayers = false;

		////////////////////////////////
		// on par, under par, over par
		// on par: skipHoles = false; extraStrokes = 0; skipStroke = false;
		// under par: skipHoles = false; extraStrokes = 0; skipStroke = true;
		// over par: skipHoles = false; extraStrokes > 0; skipStroke = false;
		
		boolean skipHoles = false;
	//	boolean skipHoles = true;
		int skipHolesMod = 9;
		
	//	int extraStrokes = 0;
		int extraStrokes = 1;
	//	int extraStrokes = 2;
	//	int extraStrokes = 4;
		
		// TODO: skip strokes (via modulo also or for each hole?)
		//boolean skipStroke = true;
		boolean skipStroke = false;
		
		String[] existingPlayersLoginIds = new String[] {"V8gS6drgze"};
		//String[] existingPlayersLoginIds = new String[] {"1ce9d204-50b8-4f8a-8270-5222db24514d"}; // login ID for 'testuser'
		
	//	String[] existingPlayersLoginIds = EXISTING_PLAYERS_LOGIN_IDS;
	//	String[] existingPlayersLoginIds = new String[] {};
		
		golfGameSimulationService.playGolfGame(golfCoursesIds, outputGameInfo, generatePlayers, numberOfPlayersToGenerate, skipHoles, skipHolesMod, extraStrokes, skipStroke, 
				existingPlayersLoginIds);
	}
	
	/*
	public void testPlayGolfGame(
			@InjectService(cardinality = 1, timeout = 2000) ServiceAware<GolfGameSimulationService> golfGameSimulationAware) {

		assertThat(golfGameSimulationAware.getServices()).hasSize(1);
		GolfGameSimulationService golfGameSimulationService = golfGameSimulationAware.getService();
		assertThat(golfGameSimulationService).isNotNull();
		
		List<String> golfCoursesIds = Arrays.asList("60bdf757199226fed8b527e0");
	//	List<String> golfCoursesIds = Arrays.asList("60bdf757199226fed8b527e0");
	//	List<String> golfCoursesIds = Arrays.asList(Arrays.copyOf(EIGHTEEN_HOLE_GOLF_COURSES_IDS, 1));
	//	List<String> golfCoursesIds = getCombinedGolfCourseIDs();
		
		boolean outputGameInfo = true;
		
	//	boolean generatePlayers = true;
		boolean generatePlayers = false;
		int numberOfPlayersToGenerate = NUMBER_OF_PLAYERS;

	//	boolean skipHoles = false;
		boolean skipHoles = true;
		int skipHolesMod = 9;
		
		int extraStrokes = 0;
	//	int extraStrokes = 4;
		
		String[] existingPlayersLoginIds = new String[] {"1ce9d204-50b8-4f8a-8270-5222db24514d"}; // login ID for 'testuser'
		
	//	String[] existingPlayersLoginIds = EXISTING_PLAYERS_LOGIN_IDS;
	//	String[] existingPlayersLoginIds = new String[] {};
		
		golfGameSimulationService.playGolfGame(golfCoursesIds, outputGameInfo, generatePlayers, numberOfPlayersToGenerate, skipHoles, skipHolesMod, extraStrokes, 
				existingPlayersLoginIds);
	}
	 */

//	@Test
	public void testCalculatePlayersPTAs(
			@InjectService(cardinality = 1, timeout = 5000) ServiceAware<GolfGameSimulationService> golfGameSimulationAware) {

		assertThat(golfGameSimulationAware.getServices()).hasSize(1);
		GolfGameSimulationService golfGameSimulationService = golfGameSimulationAware.getService();
		assertThat(golfGameSimulationService).isNotNull();

		String[] existingPlayersLoginIds = EXISTING_PLAYERS_LOGIN_IDS;

		golfGameSimulationService.calculatePlayersPTAs(existingPlayersLoginIds);
	}

	@SuppressWarnings("unused")
	private static List<String> getCombinedGolfCourseIDs() {
		return Stream.of(Arrays.asList(NINE_HOLE_GOLF_COURSES_IDS), Arrays.asList(EIGHTEEN_HOLE_GOLF_COURSES_IDS))
				.flatMap(Collection::stream).collect(Collectors.toList());
	}
}
