/**
 */
package com.playertour.backend.geoapify.model.geoapify;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see com.playertour.backend.geoapify.model.geoapify.GeoapifyFactory
 * @model kind="package"
 * @generated
 */
public interface GeoapifyPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "geoapify";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://theplayertour.com/backend/geoapify/1.0";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "geoapify";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	GeoapifyPackage eINSTANCE = com.playertour.backend.geoapify.model.geoapify.impl.GeoapifyPackageImpl.init();

	/**
	 * The meta object id for the '{@link com.playertour.backend.geoapify.model.geoapify.impl.GeoJSONImpl <em>Geo JSON</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeoJSONImpl
	 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeoapifyPackageImpl#getGeoJSON()
	 * @generated
	 */
	int GEO_JSON = 0;

	/**
	 * The feature id for the '<em><b>Bbox</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEO_JSON__BBOX = 0;

	/**
	 * The number of structural features of the '<em>Geo JSON</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEO_JSON_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Geo JSON</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEO_JSON_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.geoapify.model.geoapify.impl.AbstractGeometryImpl <em>Abstract Geometry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.geoapify.model.geoapify.impl.AbstractGeometryImpl
	 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeoapifyPackageImpl#getAbstractGeometry()
	 * @generated
	 */
	int ABSTRACT_GEOMETRY = 1;

	/**
	 * The feature id for the '<em><b>Bbox</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GEOMETRY__BBOX = GEO_JSON__BBOX;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GEOMETRY__TYPE = GEO_JSON_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Abstract Geometry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GEOMETRY_FEATURE_COUNT = GEO_JSON_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Abstract Geometry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_GEOMETRY_OPERATION_COUNT = GEO_JSON_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.geoapify.model.geoapify.impl.GeometryCollectionImpl <em>Geometry Collection</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeometryCollectionImpl
	 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeoapifyPackageImpl#getGeometryCollection()
	 * @generated
	 */
	int GEOMETRY_COLLECTION = 2;

	/**
	 * The feature id for the '<em><b>Bbox</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRY_COLLECTION__BBOX = ABSTRACT_GEOMETRY__BBOX;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRY_COLLECTION__TYPE = ABSTRACT_GEOMETRY__TYPE;

	/**
	 * The feature id for the '<em><b>Geometries</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRY_COLLECTION__GEOMETRIES = ABSTRACT_GEOMETRY_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Geometry Collection</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRY_COLLECTION_FEATURE_COUNT = ABSTRACT_GEOMETRY_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Geometry Collection</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRY_COLLECTION_OPERATION_COUNT = ABSTRACT_GEOMETRY_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.geoapify.model.geoapify.impl.GeometryImpl <em>Geometry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeometryImpl
	 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeoapifyPackageImpl#getGeometry()
	 * @generated
	 */
	int GEOMETRY = 3;

	/**
	 * The feature id for the '<em><b>Bbox</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRY__BBOX = ABSTRACT_GEOMETRY__BBOX;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRY__TYPE = ABSTRACT_GEOMETRY__TYPE;

	/**
	 * The number of structural features of the '<em>Geometry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRY_FEATURE_COUNT = ABSTRACT_GEOMETRY_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Geometry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GEOMETRY_OPERATION_COUNT = ABSTRACT_GEOMETRY_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.geoapify.model.geoapify.impl.FeatureImpl <em>Feature</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.geoapify.model.geoapify.impl.FeatureImpl
	 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeoapifyPackageImpl#getFeature()
	 * @generated
	 */
	int FEATURE = 4;

	/**
	 * The feature id for the '<em><b>Bbox</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE__BBOX = GEO_JSON__BBOX;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE__TYPE = GEO_JSON_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE__GEOMETRY = GEO_JSON_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE__PROPERTIES = GEO_JSON_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Feature</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_FEATURE_COUNT = GEO_JSON_FEATURE_COUNT + 3;

	/**
	 * The number of operations of the '<em>Feature</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_OPERATION_COUNT = GEO_JSON_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.geoapify.model.geoapify.impl.FeatureCollectionImpl <em>Feature Collection</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.geoapify.model.geoapify.impl.FeatureCollectionImpl
	 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeoapifyPackageImpl#getFeatureCollection()
	 * @generated
	 */
	int FEATURE_COLLECTION = 5;

	/**
	 * The feature id for the '<em><b>Bbox</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_COLLECTION__BBOX = GEO_JSON__BBOX;

	/**
	 * The feature id for the '<em><b>Features</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_COLLECTION__FEATURES = GEO_JSON_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Feature Collection</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_COLLECTION_FEATURE_COUNT = GEO_JSON_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Feature Collection</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_COLLECTION_OPERATION_COUNT = GEO_JSON_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.geoapify.model.geoapify.impl.PointImpl <em>Point</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.geoapify.model.geoapify.impl.PointImpl
	 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeoapifyPackageImpl#getPoint()
	 * @generated
	 */
	int POINT = 6;

	/**
	 * The feature id for the '<em><b>Bbox</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT__BBOX = GEOMETRY__BBOX;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT__TYPE = GEOMETRY__TYPE;

	/**
	 * The feature id for the '<em><b>Coordinates</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT__COORDINATES = GEOMETRY_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Point</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT_FEATURE_COUNT = GEOMETRY_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Point</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POINT_OPERATION_COUNT = GEOMETRY_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.geoapify.model.geoapify.impl.LineStringImpl <em>Line String</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.geoapify.model.geoapify.impl.LineStringImpl
	 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeoapifyPackageImpl#getLineString()
	 * @generated
	 */
	int LINE_STRING = 7;

	/**
	 * The feature id for the '<em><b>Bbox</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_STRING__BBOX = GEOMETRY__BBOX;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_STRING__TYPE = GEOMETRY__TYPE;

	/**
	 * The feature id for the '<em><b>Coordinates</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_STRING__COORDINATES = GEOMETRY_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Line String</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_STRING_FEATURE_COUNT = GEOMETRY_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Line String</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LINE_STRING_OPERATION_COUNT = GEOMETRY_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.geoapify.model.geoapify.impl.MultiPointImpl <em>Multi Point</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.geoapify.model.geoapify.impl.MultiPointImpl
	 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeoapifyPackageImpl#getMultiPoint()
	 * @generated
	 */
	int MULTI_POINT = 8;

	/**
	 * The feature id for the '<em><b>Bbox</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_POINT__BBOX = GEOMETRY__BBOX;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_POINT__TYPE = GEOMETRY__TYPE;

	/**
	 * The feature id for the '<em><b>Coordinates</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_POINT__COORDINATES = GEOMETRY_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Multi Point</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_POINT_FEATURE_COUNT = GEOMETRY_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Multi Point</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_POINT_OPERATION_COUNT = GEOMETRY_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.geoapify.model.geoapify.impl.PolygonImpl <em>Polygon</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.geoapify.model.geoapify.impl.PolygonImpl
	 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeoapifyPackageImpl#getPolygon()
	 * @generated
	 */
	int POLYGON = 9;

	/**
	 * The feature id for the '<em><b>Bbox</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYGON__BBOX = GEOMETRY__BBOX;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYGON__TYPE = GEOMETRY__TYPE;

	/**
	 * The feature id for the '<em><b>Coordinates</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYGON__COORDINATES = GEOMETRY_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Polygon</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYGON_FEATURE_COUNT = GEOMETRY_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Polygon</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POLYGON_OPERATION_COUNT = GEOMETRY_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.geoapify.model.geoapify.impl.MultiLineStringImpl <em>Multi Line String</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.geoapify.model.geoapify.impl.MultiLineStringImpl
	 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeoapifyPackageImpl#getMultiLineString()
	 * @generated
	 */
	int MULTI_LINE_STRING = 10;

	/**
	 * The feature id for the '<em><b>Bbox</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_LINE_STRING__BBOX = GEOMETRY__BBOX;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_LINE_STRING__TYPE = GEOMETRY__TYPE;

	/**
	 * The feature id for the '<em><b>Coordinates</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_LINE_STRING__COORDINATES = GEOMETRY_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Multi Line String</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_LINE_STRING_FEATURE_COUNT = GEOMETRY_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Multi Line String</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_LINE_STRING_OPERATION_COUNT = GEOMETRY_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.geoapify.model.geoapify.impl.MultiPolygonImpl <em>Multi Polygon</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.geoapify.model.geoapify.impl.MultiPolygonImpl
	 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeoapifyPackageImpl#getMultiPolygon()
	 * @generated
	 */
	int MULTI_POLYGON = 11;

	/**
	 * The feature id for the '<em><b>Bbox</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_POLYGON__BBOX = GEOMETRY__BBOX;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_POLYGON__TYPE = GEOMETRY__TYPE;

	/**
	 * The feature id for the '<em><b>Coordinates</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_POLYGON__COORDINATES = GEOMETRY_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Multi Polygon</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_POLYGON_FEATURE_COUNT = GEOMETRY_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Multi Polygon</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTI_POLYGON_OPERATION_COUNT = GEOMETRY_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.geoapify.model.geoapify.impl.FeaturePropertyImpl <em>Feature Property</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.geoapify.model.geoapify.impl.FeaturePropertyImpl
	 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeoapifyPackageImpl#getFeatureProperty()
	 * @generated
	 */
	int FEATURE_PROPERTY = 12;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_PROPERTY__NAME = 0;

	/**
	 * The feature id for the '<em><b>City</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_PROPERTY__CITY = 1;

	/**
	 * The feature id for the '<em><b>County</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_PROPERTY__COUNTY = 2;

	/**
	 * The feature id for the '<em><b>County code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_PROPERTY__COUNTY_CODE = 3;

	/**
	 * The feature id for the '<em><b>State</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_PROPERTY__STATE = 4;

	/**
	 * The feature id for the '<em><b>State code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_PROPERTY__STATE_CODE = 5;

	/**
	 * The feature id for the '<em><b>Country</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_PROPERTY__COUNTRY = 6;

	/**
	 * The feature id for the '<em><b>Country code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_PROPERTY__COUNTRY_CODE = 7;

	/**
	 * The feature id for the '<em><b>Postcode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_PROPERTY__POSTCODE = 8;

	/**
	 * The feature id for the '<em><b>Street</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_PROPERTY__STREET = 9;

	/**
	 * The feature id for the '<em><b>Housenumber</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_PROPERTY__HOUSENUMBER = 10;

	/**
	 * The feature id for the '<em><b>District</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_PROPERTY__DISTRICT = 11;

	/**
	 * The feature id for the '<em><b>Suburb</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_PROPERTY__SUBURB = 12;

	/**
	 * The feature id for the '<em><b>Formatted</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_PROPERTY__FORMATTED = 13;

	/**
	 * The feature id for the '<em><b>Address line1</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_PROPERTY__ADDRESS_LINE1 = 14;

	/**
	 * The feature id for the '<em><b>Address line2</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_PROPERTY__ADDRESS_LINE2 = 15;

	/**
	 * The feature id for the '<em><b>Result type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_PROPERTY__RESULT_TYPE = 16;

	/**
	 * The feature id for the '<em><b>Place id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_PROPERTY__PLACE_ID = 17;

	/**
	 * The feature id for the '<em><b>Lon</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_PROPERTY__LON = 18;

	/**
	 * The feature id for the '<em><b>Lat</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_PROPERTY__LAT = 19;

	/**
	 * The feature id for the '<em><b>Datasource</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_PROPERTY__DATASOURCE = 20;

	/**
	 * The feature id for the '<em><b>Rank</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_PROPERTY__RANK = 21;

	/**
	 * The number of structural features of the '<em>Feature Property</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_PROPERTY_FEATURE_COUNT = 22;

	/**
	 * The number of operations of the '<em>Feature Property</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FEATURE_PROPERTY_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.geoapify.model.geoapify.impl.DatasourceImpl <em>Datasource</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.geoapify.model.geoapify.impl.DatasourceImpl
	 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeoapifyPackageImpl#getDatasource()
	 * @generated
	 */
	int DATASOURCE = 13;

	/**
	 * The feature id for the '<em><b>Sourcename</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATASOURCE__SOURCENAME = 0;

	/**
	 * The feature id for the '<em><b>Attribution</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATASOURCE__ATTRIBUTION = 1;

	/**
	 * The feature id for the '<em><b>License</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATASOURCE__LICENSE = 2;

	/**
	 * The feature id for the '<em><b>Url</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATASOURCE__URL = 3;

	/**
	 * The number of structural features of the '<em>Datasource</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATASOURCE_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>Datasource</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DATASOURCE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.geoapify.model.geoapify.impl.RankImpl <em>Rank</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.geoapify.model.geoapify.impl.RankImpl
	 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeoapifyPackageImpl#getRank()
	 * @generated
	 */
	int RANK = 14;

	/**
	 * The feature id for the '<em><b>Importance</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RANK__IMPORTANCE = 0;

	/**
	 * The feature id for the '<em><b>Confidence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RANK__CONFIDENCE = 1;

	/**
	 * The feature id for the '<em><b>Confidence city level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RANK__CONFIDENCE_CITY_LEVEL = 2;

	/**
	 * The feature id for the '<em><b>Confidence street level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RANK__CONFIDENCE_STREET_LEVEL = 3;

	/**
	 * The feature id for the '<em><b>Match type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RANK__MATCH_TYPE = 4;

	/**
	 * The number of structural features of the '<em>Rank</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RANK_FEATURE_COUNT = 5;

	/**
	 * The number of operations of the '<em>Rank</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RANK_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.geoapify.model.geoapify.GeometryType <em>Geometry Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.geoapify.model.geoapify.GeometryType
	 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeoapifyPackageImpl#getGeometryType()
	 * @generated
	 */
	int GEOMETRY_TYPE = 15;

	/**
	 * The meta object id for the '{@link com.playertour.backend.geoapify.model.geoapify.FeatureType <em>Feature Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.geoapify.model.geoapify.FeatureType
	 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeoapifyPackageImpl#getFeatureType()
	 * @generated
	 */
	int FEATURE_TYPE = 16;

	/**
	 * The meta object id for the '<em>Array1 D</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeoapifyPackageImpl#getArray1D()
	 * @generated
	 */
	int ARRAY1_D = 17;

	/**
	 * The meta object id for the '<em>Array2 D</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeoapifyPackageImpl#getArray2D()
	 * @generated
	 */
	int ARRAY2_D = 18;

	/**
	 * The meta object id for the '<em>Array3 D</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeoapifyPackageImpl#getArray3D()
	 * @generated
	 */
	int ARRAY3_D = 19;


	/**
	 * Returns the meta object for class '{@link com.playertour.backend.geoapify.model.geoapify.GeoJSON <em>Geo JSON</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Geo JSON</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.GeoJSON
	 * @generated
	 */
	EClass getGeoJSON();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.geoapify.model.geoapify.GeoJSON#getBbox <em>Bbox</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Bbox</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.GeoJSON#getBbox()
	 * @see #getGeoJSON()
	 * @generated
	 */
	EAttribute getGeoJSON_Bbox();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.geoapify.model.geoapify.AbstractGeometry <em>Abstract Geometry</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Abstract Geometry</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.AbstractGeometry
	 * @generated
	 */
	EClass getAbstractGeometry();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.geoapify.model.geoapify.AbstractGeometry#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.AbstractGeometry#getType()
	 * @see #getAbstractGeometry()
	 * @generated
	 */
	EAttribute getAbstractGeometry_Type();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.geoapify.model.geoapify.GeometryCollection <em>Geometry Collection</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Geometry Collection</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.GeometryCollection
	 * @generated
	 */
	EClass getGeometryCollection();

	/**
	 * Returns the meta object for the containment reference list '{@link com.playertour.backend.geoapify.model.geoapify.GeometryCollection#getGeometries <em>Geometries</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Geometries</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.GeometryCollection#getGeometries()
	 * @see #getGeometryCollection()
	 * @generated
	 */
	EReference getGeometryCollection_Geometries();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.geoapify.model.geoapify.Geometry <em>Geometry</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Geometry</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.Geometry
	 * @generated
	 */
	EClass getGeometry();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.geoapify.model.geoapify.Feature <em>Feature</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Feature</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.Feature
	 * @generated
	 */
	EClass getFeature();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.geoapify.model.geoapify.Feature#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.Feature#getType()
	 * @see #getFeature()
	 * @generated
	 */
	EAttribute getFeature_Type();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.geoapify.model.geoapify.Feature#getGeometry <em>Geometry</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Geometry</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.Feature#getGeometry()
	 * @see #getFeature()
	 * @generated
	 */
	EReference getFeature_Geometry();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.geoapify.model.geoapify.Feature#getProperties <em>Properties</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Properties</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.Feature#getProperties()
	 * @see #getFeature()
	 * @generated
	 */
	EReference getFeature_Properties();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.geoapify.model.geoapify.FeatureCollection <em>Feature Collection</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Feature Collection</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.FeatureCollection
	 * @generated
	 */
	EClass getFeatureCollection();

	/**
	 * Returns the meta object for the containment reference list '{@link com.playertour.backend.geoapify.model.geoapify.FeatureCollection#getFeatures <em>Features</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Features</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.FeatureCollection#getFeatures()
	 * @see #getFeatureCollection()
	 * @generated
	 */
	EReference getFeatureCollection_Features();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.geoapify.model.geoapify.Point <em>Point</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Point</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.Point
	 * @generated
	 */
	EClass getPoint();

	/**
	 * Returns the meta object for the attribute list '{@link com.playertour.backend.geoapify.model.geoapify.Point#getCoordinates <em>Coordinates</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Coordinates</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.Point#getCoordinates()
	 * @see #getPoint()
	 * @generated
	 */
	EAttribute getPoint_Coordinates();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.geoapify.model.geoapify.LineString <em>Line String</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Line String</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.LineString
	 * @generated
	 */
	EClass getLineString();

	/**
	 * Returns the meta object for the attribute list '{@link com.playertour.backend.geoapify.model.geoapify.LineString#getCoordinates <em>Coordinates</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Coordinates</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.LineString#getCoordinates()
	 * @see #getLineString()
	 * @generated
	 */
	EAttribute getLineString_Coordinates();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.geoapify.model.geoapify.MultiPoint <em>Multi Point</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Multi Point</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.MultiPoint
	 * @generated
	 */
	EClass getMultiPoint();

	/**
	 * Returns the meta object for the attribute list '{@link com.playertour.backend.geoapify.model.geoapify.MultiPoint#getCoordinates <em>Coordinates</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Coordinates</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.MultiPoint#getCoordinates()
	 * @see #getMultiPoint()
	 * @generated
	 */
	EAttribute getMultiPoint_Coordinates();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.geoapify.model.geoapify.Polygon <em>Polygon</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Polygon</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.Polygon
	 * @generated
	 */
	EClass getPolygon();

	/**
	 * Returns the meta object for the attribute list '{@link com.playertour.backend.geoapify.model.geoapify.Polygon#getCoordinates <em>Coordinates</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Coordinates</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.Polygon#getCoordinates()
	 * @see #getPolygon()
	 * @generated
	 */
	EAttribute getPolygon_Coordinates();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.geoapify.model.geoapify.MultiLineString <em>Multi Line String</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Multi Line String</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.MultiLineString
	 * @generated
	 */
	EClass getMultiLineString();

	/**
	 * Returns the meta object for the attribute list '{@link com.playertour.backend.geoapify.model.geoapify.MultiLineString#getCoordinates <em>Coordinates</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Coordinates</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.MultiLineString#getCoordinates()
	 * @see #getMultiLineString()
	 * @generated
	 */
	EAttribute getMultiLineString_Coordinates();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.geoapify.model.geoapify.MultiPolygon <em>Multi Polygon</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Multi Polygon</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.MultiPolygon
	 * @generated
	 */
	EClass getMultiPolygon();

	/**
	 * Returns the meta object for the attribute list '{@link com.playertour.backend.geoapify.model.geoapify.MultiPolygon#getCoordinates <em>Coordinates</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Coordinates</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.MultiPolygon#getCoordinates()
	 * @see #getMultiPolygon()
	 * @generated
	 */
	EAttribute getMultiPolygon_Coordinates();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.geoapify.model.geoapify.FeatureProperty <em>Feature Property</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Feature Property</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.FeatureProperty
	 * @generated
	 */
	EClass getFeatureProperty();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getName()
	 * @see #getFeatureProperty()
	 * @generated
	 */
	EAttribute getFeatureProperty_Name();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getCity <em>City</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>City</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getCity()
	 * @see #getFeatureProperty()
	 * @generated
	 */
	EAttribute getFeatureProperty_City();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getCounty <em>County</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>County</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getCounty()
	 * @see #getFeatureProperty()
	 * @generated
	 */
	EAttribute getFeatureProperty_County();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getCounty_code <em>County code</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>County code</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getCounty_code()
	 * @see #getFeatureProperty()
	 * @generated
	 */
	EAttribute getFeatureProperty_County_code();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getState <em>State</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>State</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getState()
	 * @see #getFeatureProperty()
	 * @generated
	 */
	EAttribute getFeatureProperty_State();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getState_code <em>State code</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>State code</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getState_code()
	 * @see #getFeatureProperty()
	 * @generated
	 */
	EAttribute getFeatureProperty_State_code();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getCountry <em>Country</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Country</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getCountry()
	 * @see #getFeatureProperty()
	 * @generated
	 */
	EAttribute getFeatureProperty_Country();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getCountry_code <em>Country code</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Country code</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getCountry_code()
	 * @see #getFeatureProperty()
	 * @generated
	 */
	EAttribute getFeatureProperty_Country_code();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getPostcode <em>Postcode</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Postcode</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getPostcode()
	 * @see #getFeatureProperty()
	 * @generated
	 */
	EAttribute getFeatureProperty_Postcode();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getStreet <em>Street</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Street</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getStreet()
	 * @see #getFeatureProperty()
	 * @generated
	 */
	EAttribute getFeatureProperty_Street();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getHousenumber <em>Housenumber</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Housenumber</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getHousenumber()
	 * @see #getFeatureProperty()
	 * @generated
	 */
	EAttribute getFeatureProperty_Housenumber();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getDistrict <em>District</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>District</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getDistrict()
	 * @see #getFeatureProperty()
	 * @generated
	 */
	EAttribute getFeatureProperty_District();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getSuburb <em>Suburb</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Suburb</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getSuburb()
	 * @see #getFeatureProperty()
	 * @generated
	 */
	EAttribute getFeatureProperty_Suburb();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getFormatted <em>Formatted</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Formatted</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getFormatted()
	 * @see #getFeatureProperty()
	 * @generated
	 */
	EAttribute getFeatureProperty_Formatted();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getAddress_line1 <em>Address line1</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Address line1</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getAddress_line1()
	 * @see #getFeatureProperty()
	 * @generated
	 */
	EAttribute getFeatureProperty_Address_line1();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getAddress_line2 <em>Address line2</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Address line2</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getAddress_line2()
	 * @see #getFeatureProperty()
	 * @generated
	 */
	EAttribute getFeatureProperty_Address_line2();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getResult_type <em>Result type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Result type</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getResult_type()
	 * @see #getFeatureProperty()
	 * @generated
	 */
	EAttribute getFeatureProperty_Result_type();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getPlace_id <em>Place id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Place id</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getPlace_id()
	 * @see #getFeatureProperty()
	 * @generated
	 */
	EAttribute getFeatureProperty_Place_id();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getLon <em>Lon</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Lon</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getLon()
	 * @see #getFeatureProperty()
	 * @generated
	 */
	EAttribute getFeatureProperty_Lon();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getLat <em>Lat</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Lat</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getLat()
	 * @see #getFeatureProperty()
	 * @generated
	 */
	EAttribute getFeatureProperty_Lat();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getDatasource <em>Datasource</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Datasource</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getDatasource()
	 * @see #getFeatureProperty()
	 * @generated
	 */
	EReference getFeatureProperty_Datasource();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getRank <em>Rank</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Rank</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.FeatureProperty#getRank()
	 * @see #getFeatureProperty()
	 * @generated
	 */
	EReference getFeatureProperty_Rank();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.geoapify.model.geoapify.Datasource <em>Datasource</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Datasource</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.Datasource
	 * @generated
	 */
	EClass getDatasource();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.geoapify.model.geoapify.Datasource#getSourcename <em>Sourcename</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Sourcename</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.Datasource#getSourcename()
	 * @see #getDatasource()
	 * @generated
	 */
	EAttribute getDatasource_Sourcename();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.geoapify.model.geoapify.Datasource#getAttribution <em>Attribution</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Attribution</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.Datasource#getAttribution()
	 * @see #getDatasource()
	 * @generated
	 */
	EAttribute getDatasource_Attribution();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.geoapify.model.geoapify.Datasource#getLicense <em>License</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>License</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.Datasource#getLicense()
	 * @see #getDatasource()
	 * @generated
	 */
	EAttribute getDatasource_License();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.geoapify.model.geoapify.Datasource#getUrl <em>Url</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Url</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.Datasource#getUrl()
	 * @see #getDatasource()
	 * @generated
	 */
	EAttribute getDatasource_Url();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.geoapify.model.geoapify.Rank <em>Rank</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Rank</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.Rank
	 * @generated
	 */
	EClass getRank();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.geoapify.model.geoapify.Rank#getImportance <em>Importance</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Importance</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.Rank#getImportance()
	 * @see #getRank()
	 * @generated
	 */
	EAttribute getRank_Importance();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.geoapify.model.geoapify.Rank#getConfidence <em>Confidence</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Confidence</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.Rank#getConfidence()
	 * @see #getRank()
	 * @generated
	 */
	EAttribute getRank_Confidence();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.geoapify.model.geoapify.Rank#getConfidence_city_level <em>Confidence city level</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Confidence city level</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.Rank#getConfidence_city_level()
	 * @see #getRank()
	 * @generated
	 */
	EAttribute getRank_Confidence_city_level();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.geoapify.model.geoapify.Rank#getConfidence_street_level <em>Confidence street level</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Confidence street level</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.Rank#getConfidence_street_level()
	 * @see #getRank()
	 * @generated
	 */
	EAttribute getRank_Confidence_street_level();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.geoapify.model.geoapify.Rank#getMatch_type <em>Match type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Match type</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.Rank#getMatch_type()
	 * @see #getRank()
	 * @generated
	 */
	EAttribute getRank_Match_type();

	/**
	 * Returns the meta object for enum '{@link com.playertour.backend.geoapify.model.geoapify.GeometryType <em>Geometry Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Geometry Type</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.GeometryType
	 * @generated
	 */
	EEnum getGeometryType();

	/**
	 * Returns the meta object for enum '{@link com.playertour.backend.geoapify.model.geoapify.FeatureType <em>Feature Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Feature Type</em>'.
	 * @see com.playertour.backend.geoapify.model.geoapify.FeatureType
	 * @generated
	 */
	EEnum getFeatureType();

	/**
	 * Returns the meta object for data type '<em>Array1 D</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Array1 D</em>'.
	 * @model instanceClass="java.lang.Double[]"
	 * @generated
	 */
	EDataType getArray1D();

	/**
	 * Returns the meta object for data type '<em>Array2 D</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Array2 D</em>'.
	 * @model instanceClass="java.lang.Double[][]"
	 * @generated
	 */
	EDataType getArray2D();

	/**
	 * Returns the meta object for data type '<em>Array3 D</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Array3 D</em>'.
	 * @model instanceClass="java.lang.Double[][][]"
	 * @generated
	 */
	EDataType getArray3D();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	GeoapifyFactory getGeoapifyFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each operation of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link com.playertour.backend.geoapify.model.geoapify.impl.GeoJSONImpl <em>Geo JSON</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeoJSONImpl
		 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeoapifyPackageImpl#getGeoJSON()
		 * @generated
		 */
		EClass GEO_JSON = eINSTANCE.getGeoJSON();

		/**
		 * The meta object literal for the '<em><b>Bbox</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute GEO_JSON__BBOX = eINSTANCE.getGeoJSON_Bbox();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.geoapify.model.geoapify.impl.AbstractGeometryImpl <em>Abstract Geometry</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.geoapify.model.geoapify.impl.AbstractGeometryImpl
		 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeoapifyPackageImpl#getAbstractGeometry()
		 * @generated
		 */
		EClass ABSTRACT_GEOMETRY = eINSTANCE.getAbstractGeometry();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ABSTRACT_GEOMETRY__TYPE = eINSTANCE.getAbstractGeometry_Type();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.geoapify.model.geoapify.impl.GeometryCollectionImpl <em>Geometry Collection</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeometryCollectionImpl
		 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeoapifyPackageImpl#getGeometryCollection()
		 * @generated
		 */
		EClass GEOMETRY_COLLECTION = eINSTANCE.getGeometryCollection();

		/**
		 * The meta object literal for the '<em><b>Geometries</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference GEOMETRY_COLLECTION__GEOMETRIES = eINSTANCE.getGeometryCollection_Geometries();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.geoapify.model.geoapify.impl.GeometryImpl <em>Geometry</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeometryImpl
		 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeoapifyPackageImpl#getGeometry()
		 * @generated
		 */
		EClass GEOMETRY = eINSTANCE.getGeometry();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.geoapify.model.geoapify.impl.FeatureImpl <em>Feature</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.geoapify.model.geoapify.impl.FeatureImpl
		 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeoapifyPackageImpl#getFeature()
		 * @generated
		 */
		EClass FEATURE = eINSTANCE.getFeature();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FEATURE__TYPE = eINSTANCE.getFeature_Type();

		/**
		 * The meta object literal for the '<em><b>Geometry</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FEATURE__GEOMETRY = eINSTANCE.getFeature_Geometry();

		/**
		 * The meta object literal for the '<em><b>Properties</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FEATURE__PROPERTIES = eINSTANCE.getFeature_Properties();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.geoapify.model.geoapify.impl.FeatureCollectionImpl <em>Feature Collection</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.geoapify.model.geoapify.impl.FeatureCollectionImpl
		 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeoapifyPackageImpl#getFeatureCollection()
		 * @generated
		 */
		EClass FEATURE_COLLECTION = eINSTANCE.getFeatureCollection();

		/**
		 * The meta object literal for the '<em><b>Features</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FEATURE_COLLECTION__FEATURES = eINSTANCE.getFeatureCollection_Features();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.geoapify.model.geoapify.impl.PointImpl <em>Point</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.geoapify.model.geoapify.impl.PointImpl
		 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeoapifyPackageImpl#getPoint()
		 * @generated
		 */
		EClass POINT = eINSTANCE.getPoint();

		/**
		 * The meta object literal for the '<em><b>Coordinates</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute POINT__COORDINATES = eINSTANCE.getPoint_Coordinates();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.geoapify.model.geoapify.impl.LineStringImpl <em>Line String</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.geoapify.model.geoapify.impl.LineStringImpl
		 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeoapifyPackageImpl#getLineString()
		 * @generated
		 */
		EClass LINE_STRING = eINSTANCE.getLineString();

		/**
		 * The meta object literal for the '<em><b>Coordinates</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute LINE_STRING__COORDINATES = eINSTANCE.getLineString_Coordinates();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.geoapify.model.geoapify.impl.MultiPointImpl <em>Multi Point</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.geoapify.model.geoapify.impl.MultiPointImpl
		 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeoapifyPackageImpl#getMultiPoint()
		 * @generated
		 */
		EClass MULTI_POINT = eINSTANCE.getMultiPoint();

		/**
		 * The meta object literal for the '<em><b>Coordinates</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MULTI_POINT__COORDINATES = eINSTANCE.getMultiPoint_Coordinates();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.geoapify.model.geoapify.impl.PolygonImpl <em>Polygon</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.geoapify.model.geoapify.impl.PolygonImpl
		 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeoapifyPackageImpl#getPolygon()
		 * @generated
		 */
		EClass POLYGON = eINSTANCE.getPolygon();

		/**
		 * The meta object literal for the '<em><b>Coordinates</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute POLYGON__COORDINATES = eINSTANCE.getPolygon_Coordinates();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.geoapify.model.geoapify.impl.MultiLineStringImpl <em>Multi Line String</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.geoapify.model.geoapify.impl.MultiLineStringImpl
		 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeoapifyPackageImpl#getMultiLineString()
		 * @generated
		 */
		EClass MULTI_LINE_STRING = eINSTANCE.getMultiLineString();

		/**
		 * The meta object literal for the '<em><b>Coordinates</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MULTI_LINE_STRING__COORDINATES = eINSTANCE.getMultiLineString_Coordinates();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.geoapify.model.geoapify.impl.MultiPolygonImpl <em>Multi Polygon</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.geoapify.model.geoapify.impl.MultiPolygonImpl
		 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeoapifyPackageImpl#getMultiPolygon()
		 * @generated
		 */
		EClass MULTI_POLYGON = eINSTANCE.getMultiPolygon();

		/**
		 * The meta object literal for the '<em><b>Coordinates</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MULTI_POLYGON__COORDINATES = eINSTANCE.getMultiPolygon_Coordinates();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.geoapify.model.geoapify.impl.FeaturePropertyImpl <em>Feature Property</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.geoapify.model.geoapify.impl.FeaturePropertyImpl
		 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeoapifyPackageImpl#getFeatureProperty()
		 * @generated
		 */
		EClass FEATURE_PROPERTY = eINSTANCE.getFeatureProperty();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FEATURE_PROPERTY__NAME = eINSTANCE.getFeatureProperty_Name();

		/**
		 * The meta object literal for the '<em><b>City</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FEATURE_PROPERTY__CITY = eINSTANCE.getFeatureProperty_City();

		/**
		 * The meta object literal for the '<em><b>County</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FEATURE_PROPERTY__COUNTY = eINSTANCE.getFeatureProperty_County();

		/**
		 * The meta object literal for the '<em><b>County code</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FEATURE_PROPERTY__COUNTY_CODE = eINSTANCE.getFeatureProperty_County_code();

		/**
		 * The meta object literal for the '<em><b>State</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FEATURE_PROPERTY__STATE = eINSTANCE.getFeatureProperty_State();

		/**
		 * The meta object literal for the '<em><b>State code</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FEATURE_PROPERTY__STATE_CODE = eINSTANCE.getFeatureProperty_State_code();

		/**
		 * The meta object literal for the '<em><b>Country</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FEATURE_PROPERTY__COUNTRY = eINSTANCE.getFeatureProperty_Country();

		/**
		 * The meta object literal for the '<em><b>Country code</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FEATURE_PROPERTY__COUNTRY_CODE = eINSTANCE.getFeatureProperty_Country_code();

		/**
		 * The meta object literal for the '<em><b>Postcode</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FEATURE_PROPERTY__POSTCODE = eINSTANCE.getFeatureProperty_Postcode();

		/**
		 * The meta object literal for the '<em><b>Street</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FEATURE_PROPERTY__STREET = eINSTANCE.getFeatureProperty_Street();

		/**
		 * The meta object literal for the '<em><b>Housenumber</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FEATURE_PROPERTY__HOUSENUMBER = eINSTANCE.getFeatureProperty_Housenumber();

		/**
		 * The meta object literal for the '<em><b>District</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FEATURE_PROPERTY__DISTRICT = eINSTANCE.getFeatureProperty_District();

		/**
		 * The meta object literal for the '<em><b>Suburb</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FEATURE_PROPERTY__SUBURB = eINSTANCE.getFeatureProperty_Suburb();

		/**
		 * The meta object literal for the '<em><b>Formatted</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FEATURE_PROPERTY__FORMATTED = eINSTANCE.getFeatureProperty_Formatted();

		/**
		 * The meta object literal for the '<em><b>Address line1</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FEATURE_PROPERTY__ADDRESS_LINE1 = eINSTANCE.getFeatureProperty_Address_line1();

		/**
		 * The meta object literal for the '<em><b>Address line2</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FEATURE_PROPERTY__ADDRESS_LINE2 = eINSTANCE.getFeatureProperty_Address_line2();

		/**
		 * The meta object literal for the '<em><b>Result type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FEATURE_PROPERTY__RESULT_TYPE = eINSTANCE.getFeatureProperty_Result_type();

		/**
		 * The meta object literal for the '<em><b>Place id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FEATURE_PROPERTY__PLACE_ID = eINSTANCE.getFeatureProperty_Place_id();

		/**
		 * The meta object literal for the '<em><b>Lon</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FEATURE_PROPERTY__LON = eINSTANCE.getFeatureProperty_Lon();

		/**
		 * The meta object literal for the '<em><b>Lat</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute FEATURE_PROPERTY__LAT = eINSTANCE.getFeatureProperty_Lat();

		/**
		 * The meta object literal for the '<em><b>Datasource</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FEATURE_PROPERTY__DATASOURCE = eINSTANCE.getFeatureProperty_Datasource();

		/**
		 * The meta object literal for the '<em><b>Rank</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference FEATURE_PROPERTY__RANK = eINSTANCE.getFeatureProperty_Rank();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.geoapify.model.geoapify.impl.DatasourceImpl <em>Datasource</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.geoapify.model.geoapify.impl.DatasourceImpl
		 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeoapifyPackageImpl#getDatasource()
		 * @generated
		 */
		EClass DATASOURCE = eINSTANCE.getDatasource();

		/**
		 * The meta object literal for the '<em><b>Sourcename</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DATASOURCE__SOURCENAME = eINSTANCE.getDatasource_Sourcename();

		/**
		 * The meta object literal for the '<em><b>Attribution</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DATASOURCE__ATTRIBUTION = eINSTANCE.getDatasource_Attribution();

		/**
		 * The meta object literal for the '<em><b>License</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DATASOURCE__LICENSE = eINSTANCE.getDatasource_License();

		/**
		 * The meta object literal for the '<em><b>Url</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute DATASOURCE__URL = eINSTANCE.getDatasource_Url();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.geoapify.model.geoapify.impl.RankImpl <em>Rank</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.geoapify.model.geoapify.impl.RankImpl
		 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeoapifyPackageImpl#getRank()
		 * @generated
		 */
		EClass RANK = eINSTANCE.getRank();

		/**
		 * The meta object literal for the '<em><b>Importance</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RANK__IMPORTANCE = eINSTANCE.getRank_Importance();

		/**
		 * The meta object literal for the '<em><b>Confidence</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RANK__CONFIDENCE = eINSTANCE.getRank_Confidence();

		/**
		 * The meta object literal for the '<em><b>Confidence city level</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RANK__CONFIDENCE_CITY_LEVEL = eINSTANCE.getRank_Confidence_city_level();

		/**
		 * The meta object literal for the '<em><b>Confidence street level</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RANK__CONFIDENCE_STREET_LEVEL = eINSTANCE.getRank_Confidence_street_level();

		/**
		 * The meta object literal for the '<em><b>Match type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RANK__MATCH_TYPE = eINSTANCE.getRank_Match_type();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.geoapify.model.geoapify.GeometryType <em>Geometry Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.geoapify.model.geoapify.GeometryType
		 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeoapifyPackageImpl#getGeometryType()
		 * @generated
		 */
		EEnum GEOMETRY_TYPE = eINSTANCE.getGeometryType();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.geoapify.model.geoapify.FeatureType <em>Feature Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.geoapify.model.geoapify.FeatureType
		 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeoapifyPackageImpl#getFeatureType()
		 * @generated
		 */
		EEnum FEATURE_TYPE = eINSTANCE.getFeatureType();

		/**
		 * The meta object literal for the '<em>Array1 D</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeoapifyPackageImpl#getArray1D()
		 * @generated
		 */
		EDataType ARRAY1_D = eINSTANCE.getArray1D();

		/**
		 * The meta object literal for the '<em>Array2 D</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeoapifyPackageImpl#getArray2D()
		 * @generated
		 */
		EDataType ARRAY2_D = eINSTANCE.getArray2D();

		/**
		 * The meta object literal for the '<em>Array3 D</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.geoapify.model.geoapify.impl.GeoapifyPackageImpl#getArray3D()
		 * @generated
		 */
		EDataType ARRAY3_D = eINSTANCE.getArray3D();

	}

} //GeoapifyPackage
