/**
 */
package com.playertour.backend.geoapify.model.geoapify.impl;

import com.playertour.backend.geoapify.model.geoapify.*;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.emf.ecore.plugin.EcorePlugin;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class GeoapifyFactoryImpl extends EFactoryImpl implements GeoapifyFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static GeoapifyFactory init() {
		try {
			GeoapifyFactory theGeoapifyFactory = (GeoapifyFactory)EPackage.Registry.INSTANCE.getEFactory(GeoapifyPackage.eNS_URI);
			if (theGeoapifyFactory != null) {
				return theGeoapifyFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new GeoapifyFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GeoapifyFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case GeoapifyPackage.GEO_JSON: return createGeoJSON();
			case GeoapifyPackage.ABSTRACT_GEOMETRY: return createAbstractGeometry();
			case GeoapifyPackage.GEOMETRY_COLLECTION: return createGeometryCollection();
			case GeoapifyPackage.GEOMETRY: return createGeometry();
			case GeoapifyPackage.FEATURE: return createFeature();
			case GeoapifyPackage.FEATURE_COLLECTION: return createFeatureCollection();
			case GeoapifyPackage.POINT: return createPoint();
			case GeoapifyPackage.LINE_STRING: return createLineString();
			case GeoapifyPackage.MULTI_POINT: return createMultiPoint();
			case GeoapifyPackage.POLYGON: return createPolygon();
			case GeoapifyPackage.MULTI_LINE_STRING: return createMultiLineString();
			case GeoapifyPackage.MULTI_POLYGON: return createMultiPolygon();
			case GeoapifyPackage.FEATURE_PROPERTY: return createFeatureProperty();
			case GeoapifyPackage.DATASOURCE: return createDatasource();
			case GeoapifyPackage.RANK: return createRank();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
			case GeoapifyPackage.GEOMETRY_TYPE:
				return createGeometryTypeFromString(eDataType, initialValue);
			case GeoapifyPackage.FEATURE_TYPE:
				return createFeatureTypeFromString(eDataType, initialValue);
			case GeoapifyPackage.ARRAY1_D:
				return createArray1DFromString(eDataType, initialValue);
			case GeoapifyPackage.ARRAY2_D:
				return createArray2DFromString(eDataType, initialValue);
			case GeoapifyPackage.ARRAY3_D:
				return createArray3DFromString(eDataType, initialValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
			case GeoapifyPackage.GEOMETRY_TYPE:
				return convertGeometryTypeToString(eDataType, instanceValue);
			case GeoapifyPackage.FEATURE_TYPE:
				return convertFeatureTypeToString(eDataType, instanceValue);
			case GeoapifyPackage.ARRAY1_D:
				return convertArray1DToString(eDataType, instanceValue);
			case GeoapifyPackage.ARRAY2_D:
				return convertArray2DToString(eDataType, instanceValue);
			case GeoapifyPackage.ARRAY3_D:
				return convertArray3DToString(eDataType, instanceValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public GeoJSON createGeoJSON() {
		GeoJSONImpl geoJSON = new GeoJSONImpl();
		return geoJSON;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public AbstractGeometry createAbstractGeometry() {
		AbstractGeometryImpl abstractGeometry = new AbstractGeometryImpl();
		return abstractGeometry;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public GeometryCollection createGeometryCollection() {
		GeometryCollectionImpl geometryCollection = new GeometryCollectionImpl();
		return geometryCollection;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Geometry createGeometry() {
		GeometryImpl geometry = new GeometryImpl();
		return geometry;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Feature createFeature() {
		FeatureImpl feature = new FeatureImpl();
		return feature;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public FeatureCollection createFeatureCollection() {
		FeatureCollectionImpl featureCollection = new FeatureCollectionImpl();
		return featureCollection;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Point createPoint() {
		PointImpl point = new PointImpl();
		return point;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public LineString createLineString() {
		LineStringImpl lineString = new LineStringImpl();
		return lineString;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public MultiPoint createMultiPoint() {
		MultiPointImpl multiPoint = new MultiPointImpl();
		return multiPoint;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Polygon createPolygon() {
		PolygonImpl polygon = new PolygonImpl();
		return polygon;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public MultiLineString createMultiLineString() {
		MultiLineStringImpl multiLineString = new MultiLineStringImpl();
		return multiLineString;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public MultiPolygon createMultiPolygon() {
		MultiPolygonImpl multiPolygon = new MultiPolygonImpl();
		return multiPolygon;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public FeatureProperty createFeatureProperty() {
		FeaturePropertyImpl featureProperty = new FeaturePropertyImpl();
		return featureProperty;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Datasource createDatasource() {
		DatasourceImpl datasource = new DatasourceImpl();
		return datasource;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Rank createRank() {
		RankImpl rank = new RankImpl();
		return rank;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GeometryType createGeometryTypeFromString(EDataType eDataType, String initialValue) {
		GeometryType result = GeometryType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertGeometryTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FeatureType createFeatureTypeFromString(EDataType eDataType, String initialValue) {
		FeatureType result = FeatureType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertFeatureTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Double[] createArray1DFromString(EDataType eDataType, String initialValue) {
		return (Double[])super.createFromString(initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertArray1DToString(EDataType eDataType, Object instanceValue) {
		return super.convertToString(instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Double[][] createArray2DFromString(EDataType eDataType, String initialValue) {
		return (Double[][])super.createFromString(initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertArray2DToString(EDataType eDataType, Object instanceValue) {
		return super.convertToString(instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Double[][][] createArray3DFromString(EDataType eDataType, String initialValue) {
		return (Double[][][])super.createFromString(initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertArray3DToString(EDataType eDataType, Object instanceValue) {
		return super.convertToString(instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public GeoapifyPackage getGeoapifyPackage() {
		return (GeoapifyPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static GeoapifyPackage getPackage() {
		return GeoapifyPackage.eINSTANCE;
	}

} //GeoapifyFactoryImpl
