/**
 */
package com.playertour.backend.geoapify.model.geoapify.impl;

import com.playertour.backend.geoapify.model.geoapify.AbstractGeometry;
import com.playertour.backend.geoapify.model.geoapify.Datasource;
import com.playertour.backend.geoapify.model.geoapify.Feature;
import com.playertour.backend.geoapify.model.geoapify.FeatureCollection;
import com.playertour.backend.geoapify.model.geoapify.FeatureProperty;
import com.playertour.backend.geoapify.model.geoapify.FeatureType;
import com.playertour.backend.geoapify.model.geoapify.GeoJSON;
import com.playertour.backend.geoapify.model.geoapify.GeoapifyFactory;
import com.playertour.backend.geoapify.model.geoapify.GeoapifyPackage;
import com.playertour.backend.geoapify.model.geoapify.Geometry;
import com.playertour.backend.geoapify.model.geoapify.GeometryCollection;
import com.playertour.backend.geoapify.model.geoapify.GeometryType;
import com.playertour.backend.geoapify.model.geoapify.LineString;
import com.playertour.backend.geoapify.model.geoapify.MultiLineString;
import com.playertour.backend.geoapify.model.geoapify.MultiPoint;
import com.playertour.backend.geoapify.model.geoapify.MultiPolygon;
import com.playertour.backend.geoapify.model.geoapify.Point;
import com.playertour.backend.geoapify.model.geoapify.Polygon;
import com.playertour.backend.geoapify.model.geoapify.Rank;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.emf.ecore.impl.EPackageImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class GeoapifyPackageImpl extends EPackageImpl implements GeoapifyPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass geoJSONEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass abstractGeometryEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass geometryCollectionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass geometryEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass featureEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass featureCollectionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass pointEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass lineStringEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass multiPointEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass polygonEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass multiLineStringEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass multiPolygonEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass featurePropertyEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass datasourceEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rankEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum geometryTypeEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum featureTypeEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType array1DEDataType = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType array2DEDataType = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType array3DEDataType = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see com.playertour.backend.geoapify.model.geoapify.GeoapifyPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private GeoapifyPackageImpl() {
		super(eNS_URI, GeoapifyFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 *
	 * <p>This method is used to initialize {@link GeoapifyPackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static GeoapifyPackage init() {
		if (isInited) return (GeoapifyPackage)EPackage.Registry.INSTANCE.getEPackage(GeoapifyPackage.eNS_URI);

		// Obtain or create and register package
		Object registeredGeoapifyPackage = EPackage.Registry.INSTANCE.get(eNS_URI);
		GeoapifyPackageImpl theGeoapifyPackage = registeredGeoapifyPackage instanceof GeoapifyPackageImpl ? (GeoapifyPackageImpl)registeredGeoapifyPackage : new GeoapifyPackageImpl();

		isInited = true;

		// Create package meta-data objects
		theGeoapifyPackage.createPackageContents();

		// Initialize created meta-data
		theGeoapifyPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theGeoapifyPackage.freeze();

		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(GeoapifyPackage.eNS_URI, theGeoapifyPackage);
		return theGeoapifyPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getGeoJSON() {
		return geoJSONEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getGeoJSON_Bbox() {
		return (EAttribute)geoJSONEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getAbstractGeometry() {
		return abstractGeometryEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAbstractGeometry_Type() {
		return (EAttribute)abstractGeometryEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getGeometryCollection() {
		return geometryCollectionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getGeometryCollection_Geometries() {
		return (EReference)geometryCollectionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getGeometry() {
		return geometryEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getFeature() {
		return featureEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getFeature_Type() {
		return (EAttribute)featureEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getFeature_Geometry() {
		return (EReference)featureEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getFeature_Properties() {
		return (EReference)featureEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getFeatureCollection() {
		return featureCollectionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getFeatureCollection_Features() {
		return (EReference)featureCollectionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getPoint() {
		return pointEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getPoint_Coordinates() {
		return (EAttribute)pointEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getLineString() {
		return lineStringEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getLineString_Coordinates() {
		return (EAttribute)lineStringEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getMultiPoint() {
		return multiPointEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getMultiPoint_Coordinates() {
		return (EAttribute)multiPointEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getPolygon() {
		return polygonEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getPolygon_Coordinates() {
		return (EAttribute)polygonEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getMultiLineString() {
		return multiLineStringEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getMultiLineString_Coordinates() {
		return (EAttribute)multiLineStringEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getMultiPolygon() {
		return multiPolygonEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getMultiPolygon_Coordinates() {
		return (EAttribute)multiPolygonEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getFeatureProperty() {
		return featurePropertyEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getFeatureProperty_Name() {
		return (EAttribute)featurePropertyEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getFeatureProperty_City() {
		return (EAttribute)featurePropertyEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getFeatureProperty_County() {
		return (EAttribute)featurePropertyEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getFeatureProperty_County_code() {
		return (EAttribute)featurePropertyEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getFeatureProperty_State() {
		return (EAttribute)featurePropertyEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getFeatureProperty_State_code() {
		return (EAttribute)featurePropertyEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getFeatureProperty_Country() {
		return (EAttribute)featurePropertyEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getFeatureProperty_Country_code() {
		return (EAttribute)featurePropertyEClass.getEStructuralFeatures().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getFeatureProperty_Postcode() {
		return (EAttribute)featurePropertyEClass.getEStructuralFeatures().get(8);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getFeatureProperty_Street() {
		return (EAttribute)featurePropertyEClass.getEStructuralFeatures().get(9);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getFeatureProperty_Housenumber() {
		return (EAttribute)featurePropertyEClass.getEStructuralFeatures().get(10);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getFeatureProperty_District() {
		return (EAttribute)featurePropertyEClass.getEStructuralFeatures().get(11);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getFeatureProperty_Suburb() {
		return (EAttribute)featurePropertyEClass.getEStructuralFeatures().get(12);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getFeatureProperty_Formatted() {
		return (EAttribute)featurePropertyEClass.getEStructuralFeatures().get(13);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getFeatureProperty_Address_line1() {
		return (EAttribute)featurePropertyEClass.getEStructuralFeatures().get(14);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getFeatureProperty_Address_line2() {
		return (EAttribute)featurePropertyEClass.getEStructuralFeatures().get(15);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getFeatureProperty_Result_type() {
		return (EAttribute)featurePropertyEClass.getEStructuralFeatures().get(16);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getFeatureProperty_Place_id() {
		return (EAttribute)featurePropertyEClass.getEStructuralFeatures().get(17);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getFeatureProperty_Lon() {
		return (EAttribute)featurePropertyEClass.getEStructuralFeatures().get(18);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getFeatureProperty_Lat() {
		return (EAttribute)featurePropertyEClass.getEStructuralFeatures().get(19);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getFeatureProperty_Datasource() {
		return (EReference)featurePropertyEClass.getEStructuralFeatures().get(20);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getFeatureProperty_Rank() {
		return (EReference)featurePropertyEClass.getEStructuralFeatures().get(21);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getDatasource() {
		return datasourceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getDatasource_Sourcename() {
		return (EAttribute)datasourceEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getDatasource_Attribution() {
		return (EAttribute)datasourceEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getDatasource_License() {
		return (EAttribute)datasourceEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getDatasource_Url() {
		return (EAttribute)datasourceEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getRank() {
		return rankEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getRank_Importance() {
		return (EAttribute)rankEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getRank_Confidence() {
		return (EAttribute)rankEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getRank_Confidence_city_level() {
		return (EAttribute)rankEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getRank_Confidence_street_level() {
		return (EAttribute)rankEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getRank_Match_type() {
		return (EAttribute)rankEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getGeometryType() {
		return geometryTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getFeatureType() {
		return featureTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataType getArray1D() {
		return array1DEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataType getArray2D() {
		return array2DEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataType getArray3D() {
		return array3DEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public GeoapifyFactory getGeoapifyFactory() {
		return (GeoapifyFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		geoJSONEClass = createEClass(GEO_JSON);
		createEAttribute(geoJSONEClass, GEO_JSON__BBOX);

		abstractGeometryEClass = createEClass(ABSTRACT_GEOMETRY);
		createEAttribute(abstractGeometryEClass, ABSTRACT_GEOMETRY__TYPE);

		geometryCollectionEClass = createEClass(GEOMETRY_COLLECTION);
		createEReference(geometryCollectionEClass, GEOMETRY_COLLECTION__GEOMETRIES);

		geometryEClass = createEClass(GEOMETRY);

		featureEClass = createEClass(FEATURE);
		createEAttribute(featureEClass, FEATURE__TYPE);
		createEReference(featureEClass, FEATURE__GEOMETRY);
		createEReference(featureEClass, FEATURE__PROPERTIES);

		featureCollectionEClass = createEClass(FEATURE_COLLECTION);
		createEReference(featureCollectionEClass, FEATURE_COLLECTION__FEATURES);

		pointEClass = createEClass(POINT);
		createEAttribute(pointEClass, POINT__COORDINATES);

		lineStringEClass = createEClass(LINE_STRING);
		createEAttribute(lineStringEClass, LINE_STRING__COORDINATES);

		multiPointEClass = createEClass(MULTI_POINT);
		createEAttribute(multiPointEClass, MULTI_POINT__COORDINATES);

		polygonEClass = createEClass(POLYGON);
		createEAttribute(polygonEClass, POLYGON__COORDINATES);

		multiLineStringEClass = createEClass(MULTI_LINE_STRING);
		createEAttribute(multiLineStringEClass, MULTI_LINE_STRING__COORDINATES);

		multiPolygonEClass = createEClass(MULTI_POLYGON);
		createEAttribute(multiPolygonEClass, MULTI_POLYGON__COORDINATES);

		featurePropertyEClass = createEClass(FEATURE_PROPERTY);
		createEAttribute(featurePropertyEClass, FEATURE_PROPERTY__NAME);
		createEAttribute(featurePropertyEClass, FEATURE_PROPERTY__CITY);
		createEAttribute(featurePropertyEClass, FEATURE_PROPERTY__COUNTY);
		createEAttribute(featurePropertyEClass, FEATURE_PROPERTY__COUNTY_CODE);
		createEAttribute(featurePropertyEClass, FEATURE_PROPERTY__STATE);
		createEAttribute(featurePropertyEClass, FEATURE_PROPERTY__STATE_CODE);
		createEAttribute(featurePropertyEClass, FEATURE_PROPERTY__COUNTRY);
		createEAttribute(featurePropertyEClass, FEATURE_PROPERTY__COUNTRY_CODE);
		createEAttribute(featurePropertyEClass, FEATURE_PROPERTY__POSTCODE);
		createEAttribute(featurePropertyEClass, FEATURE_PROPERTY__STREET);
		createEAttribute(featurePropertyEClass, FEATURE_PROPERTY__HOUSENUMBER);
		createEAttribute(featurePropertyEClass, FEATURE_PROPERTY__DISTRICT);
		createEAttribute(featurePropertyEClass, FEATURE_PROPERTY__SUBURB);
		createEAttribute(featurePropertyEClass, FEATURE_PROPERTY__FORMATTED);
		createEAttribute(featurePropertyEClass, FEATURE_PROPERTY__ADDRESS_LINE1);
		createEAttribute(featurePropertyEClass, FEATURE_PROPERTY__ADDRESS_LINE2);
		createEAttribute(featurePropertyEClass, FEATURE_PROPERTY__RESULT_TYPE);
		createEAttribute(featurePropertyEClass, FEATURE_PROPERTY__PLACE_ID);
		createEAttribute(featurePropertyEClass, FEATURE_PROPERTY__LON);
		createEAttribute(featurePropertyEClass, FEATURE_PROPERTY__LAT);
		createEReference(featurePropertyEClass, FEATURE_PROPERTY__DATASOURCE);
		createEReference(featurePropertyEClass, FEATURE_PROPERTY__RANK);

		datasourceEClass = createEClass(DATASOURCE);
		createEAttribute(datasourceEClass, DATASOURCE__SOURCENAME);
		createEAttribute(datasourceEClass, DATASOURCE__ATTRIBUTION);
		createEAttribute(datasourceEClass, DATASOURCE__LICENSE);
		createEAttribute(datasourceEClass, DATASOURCE__URL);

		rankEClass = createEClass(RANK);
		createEAttribute(rankEClass, RANK__IMPORTANCE);
		createEAttribute(rankEClass, RANK__CONFIDENCE);
		createEAttribute(rankEClass, RANK__CONFIDENCE_CITY_LEVEL);
		createEAttribute(rankEClass, RANK__CONFIDENCE_STREET_LEVEL);
		createEAttribute(rankEClass, RANK__MATCH_TYPE);

		// Create enums
		geometryTypeEEnum = createEEnum(GEOMETRY_TYPE);
		featureTypeEEnum = createEEnum(FEATURE_TYPE);

		// Create data types
		array1DEDataType = createEDataType(ARRAY1_D);
		array2DEDataType = createEDataType(ARRAY2_D);
		array3DEDataType = createEDataType(ARRAY3_D);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes
		abstractGeometryEClass.getESuperTypes().add(this.getGeoJSON());
		geometryCollectionEClass.getESuperTypes().add(this.getAbstractGeometry());
		geometryEClass.getESuperTypes().add(this.getAbstractGeometry());
		featureEClass.getESuperTypes().add(this.getGeoJSON());
		featureCollectionEClass.getESuperTypes().add(this.getGeoJSON());
		pointEClass.getESuperTypes().add(this.getGeometry());
		lineStringEClass.getESuperTypes().add(this.getGeometry());
		multiPointEClass.getESuperTypes().add(this.getGeometry());
		polygonEClass.getESuperTypes().add(this.getGeometry());
		multiLineStringEClass.getESuperTypes().add(this.getGeometry());
		multiPolygonEClass.getESuperTypes().add(this.getGeometry());

		// Initialize classes, features, and operations; add parameters
		initEClass(geoJSONEClass, GeoJSON.class, "GeoJSON", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getGeoJSON_Bbox(), this.getArray1D(), "bbox", null, 0, 1, GeoJSON.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(abstractGeometryEClass, AbstractGeometry.class, "AbstractGeometry", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getAbstractGeometry_Type(), ecorePackage.getEString(), "type", null, 0, 1, AbstractGeometry.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(geometryCollectionEClass, GeometryCollection.class, "GeometryCollection", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getGeometryCollection_Geometries(), this.getAbstractGeometry(), null, "geometries", null, 0, -1, GeometryCollection.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(geometryEClass, Geometry.class, "Geometry", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(featureEClass, Feature.class, "Feature", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getFeature_Type(), ecorePackage.getEString(), "type", null, 0, 1, Feature.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getFeature_Geometry(), this.getPoint(), null, "geometry", null, 0, 1, Feature.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getFeature_Properties(), this.getFeatureProperty(), null, "properties", null, 0, 1, Feature.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(featureCollectionEClass, FeatureCollection.class, "FeatureCollection", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getFeatureCollection_Features(), this.getFeature(), null, "features", null, 0, -1, FeatureCollection.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(pointEClass, Point.class, "Point", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getPoint_Coordinates(), ecorePackage.getEDouble(), "coordinates", null, 0, 3, Point.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(lineStringEClass, LineString.class, "LineString", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getLineString_Coordinates(), this.getArray1D(), "coordinates", null, 0, -1, LineString.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(multiPointEClass, MultiPoint.class, "MultiPoint", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getMultiPoint_Coordinates(), this.getArray1D(), "coordinates", null, 0, -1, MultiPoint.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(polygonEClass, Polygon.class, "Polygon", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getPolygon_Coordinates(), this.getArray2D(), "coordinates", null, 0, -1, Polygon.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(multiLineStringEClass, MultiLineString.class, "MultiLineString", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getMultiLineString_Coordinates(), this.getArray2D(), "coordinates", null, 0, -1, MultiLineString.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(multiPolygonEClass, MultiPolygon.class, "MultiPolygon", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getMultiPolygon_Coordinates(), this.getArray3D(), "coordinates", null, 0, -1, MultiPolygon.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(featurePropertyEClass, FeatureProperty.class, "FeatureProperty", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getFeatureProperty_Name(), ecorePackage.getEString(), "name", null, 0, 1, FeatureProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getFeatureProperty_City(), ecorePackage.getEString(), "city", null, 0, 1, FeatureProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getFeatureProperty_County(), ecorePackage.getEString(), "county", null, 0, 1, FeatureProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getFeatureProperty_County_code(), ecorePackage.getEString(), "county_code", null, 0, 1, FeatureProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getFeatureProperty_State(), ecorePackage.getEString(), "state", null, 0, 1, FeatureProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getFeatureProperty_State_code(), ecorePackage.getEString(), "state_code", null, 0, 1, FeatureProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getFeatureProperty_Country(), ecorePackage.getEString(), "country", null, 0, 1, FeatureProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getFeatureProperty_Country_code(), ecorePackage.getEString(), "country_code", null, 0, 1, FeatureProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getFeatureProperty_Postcode(), ecorePackage.getEString(), "postcode", null, 0, 1, FeatureProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getFeatureProperty_Street(), ecorePackage.getEString(), "street", null, 0, 1, FeatureProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getFeatureProperty_Housenumber(), ecorePackage.getEString(), "housenumber", null, 0, 1, FeatureProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getFeatureProperty_District(), ecorePackage.getEString(), "district", null, 0, 1, FeatureProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getFeatureProperty_Suburb(), ecorePackage.getEString(), "suburb", null, 0, 1, FeatureProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getFeatureProperty_Formatted(), ecorePackage.getEString(), "formatted", null, 0, 1, FeatureProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getFeatureProperty_Address_line1(), ecorePackage.getEString(), "address_line1", null, 0, 1, FeatureProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getFeatureProperty_Address_line2(), ecorePackage.getEString(), "address_line2", null, 0, 1, FeatureProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getFeatureProperty_Result_type(), ecorePackage.getEString(), "result_type", null, 0, 1, FeatureProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getFeatureProperty_Place_id(), ecorePackage.getEString(), "place_id", null, 0, 1, FeatureProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getFeatureProperty_Lon(), ecorePackage.getEDouble(), "lon", null, 0, 1, FeatureProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getFeatureProperty_Lat(), ecorePackage.getEDouble(), "lat", null, 0, 1, FeatureProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getFeatureProperty_Datasource(), this.getDatasource(), null, "datasource", null, 0, 1, FeatureProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getFeatureProperty_Rank(), this.getRank(), null, "rank", null, 0, 1, FeatureProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(datasourceEClass, Datasource.class, "Datasource", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getDatasource_Sourcename(), ecorePackage.getEString(), "sourcename", null, 0, 1, Datasource.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getDatasource_Attribution(), ecorePackage.getEString(), "attribution", null, 0, 1, Datasource.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getDatasource_License(), ecorePackage.getEString(), "license", null, 0, 1, Datasource.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getDatasource_Url(), ecorePackage.getEString(), "url", null, 0, 1, Datasource.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(rankEClass, Rank.class, "Rank", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getRank_Importance(), ecorePackage.getEDouble(), "importance", null, 0, 1, Rank.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getRank_Confidence(), ecorePackage.getEDouble(), "confidence", null, 0, 1, Rank.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getRank_Confidence_city_level(), ecorePackage.getEDouble(), "confidence_city_level", null, 0, 1, Rank.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getRank_Confidence_street_level(), ecorePackage.getEDouble(), "confidence_street_level", null, 0, 1, Rank.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getRank_Match_type(), ecorePackage.getEString(), "match_type", null, 0, 1, Rank.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		// Initialize enums and add enum literals
		initEEnum(geometryTypeEEnum, GeometryType.class, "GeometryType");
		addEEnumLiteral(geometryTypeEEnum, GeometryType.POINT);
		addEEnumLiteral(geometryTypeEEnum, GeometryType.LINE_STRING);
		addEEnumLiteral(geometryTypeEEnum, GeometryType.POLYGON);
		addEEnumLiteral(geometryTypeEEnum, GeometryType.MULTI_POINT);
		addEEnumLiteral(geometryTypeEEnum, GeometryType.MULTI_LINE_STRING);
		addEEnumLiteral(geometryTypeEEnum, GeometryType.MULTI_POLYGON);
		addEEnumLiteral(geometryTypeEEnum, GeometryType.GEOMETRY_COLLECTION);

		initEEnum(featureTypeEEnum, FeatureType.class, "FeatureType");
		addEEnumLiteral(featureTypeEEnum, FeatureType.FEATURE);

		// Initialize data types
		initEDataType(array1DEDataType, Double[].class, "Array1D", IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS);
		initEDataType(array2DEDataType, Double[][].class, "Array2D", IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS);
		initEDataType(array3DEDataType, Double[][][].class, "Array3D", IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS);

		// Create resource
		createResource(eNS_URI);

		// Create annotations
		// http://www.eclipse.org/emf/2002/GenModel
		createGenModelAnnotations();
	}

	/**
	 * Initializes the annotations for <b>http://www.eclipse.org/emf/2002/GenModel</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createGenModelAnnotations() {
		String source = "http://www.eclipse.org/emf/2002/GenModel";
		addAnnotation
		  (getFeatureProperty_Result_type(),
		   source,
		   new String[] {
			   "documentation", "Found location type. Can take values from [unknown, amenity, building, street, suburb, district, postcode, city, county, state, country]"
		   });
		addAnnotation
		  (getRank_Confidence(),
		   source,
		   new String[] {
			   "documentation", "Takes values between 0 and 1. Confidence value."
		   });
		addAnnotation
		  (getRank_Confidence_city_level(),
		   source,
		   new String[] {
			   "documentation", "Takes values between 0 and 1. Evaluates if the city is correct."
		   });
		addAnnotation
		  (getRank_Confidence_street_level(),
		   source,
		   new String[] {
			   "documentation", "Takes values between 0 and 1. Evaluates if the street is correct."
		   });
		addAnnotation
		  (getRank_Match_type(),
		   source,
		   new String[] {
			   "documentation", "Match type between requested address and result address. Can take values from [ full_match, inner_part, match_by_building match_by_street, match_by_postcode, match_by_city_or_disrict, match_by_country_or_state]"
		   });
	}

} //GeoapifyPackageImpl
