/**
 */
package com.playertour.backend.geoapify.model.geoapify.util;

import com.playertour.backend.geoapify.model.geoapify.*;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see com.playertour.backend.geoapify.model.geoapify.GeoapifyPackage
 * @generated
 */
public class GeoapifyAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static GeoapifyPackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GeoapifyAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = GeoapifyPackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GeoapifySwitch<Adapter> modelSwitch =
		new GeoapifySwitch<Adapter>() {
			@Override
			public Adapter caseGeoJSON(GeoJSON object) {
				return createGeoJSONAdapter();
			}
			@Override
			public Adapter caseAbstractGeometry(AbstractGeometry object) {
				return createAbstractGeometryAdapter();
			}
			@Override
			public Adapter caseGeometryCollection(GeometryCollection object) {
				return createGeometryCollectionAdapter();
			}
			@Override
			public Adapter caseGeometry(Geometry object) {
				return createGeometryAdapter();
			}
			@Override
			public Adapter caseFeature(Feature object) {
				return createFeatureAdapter();
			}
			@Override
			public Adapter caseFeatureCollection(FeatureCollection object) {
				return createFeatureCollectionAdapter();
			}
			@Override
			public Adapter casePoint(Point object) {
				return createPointAdapter();
			}
			@Override
			public Adapter caseLineString(LineString object) {
				return createLineStringAdapter();
			}
			@Override
			public Adapter caseMultiPoint(MultiPoint object) {
				return createMultiPointAdapter();
			}
			@Override
			public Adapter casePolygon(Polygon object) {
				return createPolygonAdapter();
			}
			@Override
			public Adapter caseMultiLineString(MultiLineString object) {
				return createMultiLineStringAdapter();
			}
			@Override
			public Adapter caseMultiPolygon(MultiPolygon object) {
				return createMultiPolygonAdapter();
			}
			@Override
			public Adapter caseFeatureProperty(FeatureProperty object) {
				return createFeaturePropertyAdapter();
			}
			@Override
			public Adapter caseDatasource(Datasource object) {
				return createDatasourceAdapter();
			}
			@Override
			public Adapter caseRank(Rank object) {
				return createRankAdapter();
			}
			@Override
			public Adapter defaultCase(EObject object) {
				return createEObjectAdapter();
			}
		};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter(Notifier target) {
		return modelSwitch.doSwitch((EObject)target);
	}


	/**
	 * Creates a new adapter for an object of class '{@link com.playertour.backend.geoapify.model.geoapify.GeoJSON <em>Geo JSON</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.playertour.backend.geoapify.model.geoapify.GeoJSON
	 * @generated
	 */
	public Adapter createGeoJSONAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.playertour.backend.geoapify.model.geoapify.AbstractGeometry <em>Abstract Geometry</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.playertour.backend.geoapify.model.geoapify.AbstractGeometry
	 * @generated
	 */
	public Adapter createAbstractGeometryAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.playertour.backend.geoapify.model.geoapify.GeometryCollection <em>Geometry Collection</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.playertour.backend.geoapify.model.geoapify.GeometryCollection
	 * @generated
	 */
	public Adapter createGeometryCollectionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.playertour.backend.geoapify.model.geoapify.Geometry <em>Geometry</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.playertour.backend.geoapify.model.geoapify.Geometry
	 * @generated
	 */
	public Adapter createGeometryAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.playertour.backend.geoapify.model.geoapify.Feature <em>Feature</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.playertour.backend.geoapify.model.geoapify.Feature
	 * @generated
	 */
	public Adapter createFeatureAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.playertour.backend.geoapify.model.geoapify.FeatureCollection <em>Feature Collection</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.playertour.backend.geoapify.model.geoapify.FeatureCollection
	 * @generated
	 */
	public Adapter createFeatureCollectionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.playertour.backend.geoapify.model.geoapify.Point <em>Point</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.playertour.backend.geoapify.model.geoapify.Point
	 * @generated
	 */
	public Adapter createPointAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.playertour.backend.geoapify.model.geoapify.LineString <em>Line String</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.playertour.backend.geoapify.model.geoapify.LineString
	 * @generated
	 */
	public Adapter createLineStringAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.playertour.backend.geoapify.model.geoapify.MultiPoint <em>Multi Point</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.playertour.backend.geoapify.model.geoapify.MultiPoint
	 * @generated
	 */
	public Adapter createMultiPointAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.playertour.backend.geoapify.model.geoapify.Polygon <em>Polygon</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.playertour.backend.geoapify.model.geoapify.Polygon
	 * @generated
	 */
	public Adapter createPolygonAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.playertour.backend.geoapify.model.geoapify.MultiLineString <em>Multi Line String</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.playertour.backend.geoapify.model.geoapify.MultiLineString
	 * @generated
	 */
	public Adapter createMultiLineStringAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.playertour.backend.geoapify.model.geoapify.MultiPolygon <em>Multi Polygon</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.playertour.backend.geoapify.model.geoapify.MultiPolygon
	 * @generated
	 */
	public Adapter createMultiPolygonAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.playertour.backend.geoapify.model.geoapify.FeatureProperty <em>Feature Property</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.playertour.backend.geoapify.model.geoapify.FeatureProperty
	 * @generated
	 */
	public Adapter createFeaturePropertyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.playertour.backend.geoapify.model.geoapify.Datasource <em>Datasource</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.playertour.backend.geoapify.model.geoapify.Datasource
	 * @generated
	 */
	public Adapter createDatasourceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.playertour.backend.geoapify.model.geoapify.Rank <em>Rank</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.playertour.backend.geoapify.model.geoapify.Rank
	 * @generated
	 */
	public Adapter createRankAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} //GeoapifyAdapterFactory
