/**
 * Copyright (c) 2012 - 2018 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package com.playertour.backend.geoapify.tests;

import static org.assertj.core.api.Assertions.assertThat;

import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.test.common.annotation.InjectBundleContext;
import org.osgi.test.common.annotation.InjectService;
import org.osgi.test.common.service.ServiceAware;
import org.osgi.test.junit5.context.BundleContextExtension;
import org.osgi.test.junit5.service.ServiceExtension;

import com.playertour.backend.apis.geoapify.GeoapifyService;
import com.playertour.backend.geoapify.model.geoapify.FeatureCollection;



/**
 * Tests the implementation of the GeoapifyService
 * @since 1.0
 */
@ExtendWith(BundleContextExtension.class)
@ExtendWith(ServiceExtension.class)
public class GeoapifyIntegrationTests {
	
	@InjectBundleContext
	BundleContext bundleContext;
	
	@Test
	public void test() {
		
	}

//	@Test
	public void testServices(@InjectService(cardinality = 1, timeout = 5000) ServiceAware<GeoapifyService> geoapifyAware) {
				
		assertThat(geoapifyAware.getServices()).hasSize(1);	
		ServiceReference<GeoapifyService> geoapifyReference = geoapifyAware.getServiceReference();
		assertThat(geoapifyReference).isNotNull();			
	}	
	
//	@Test
	public void testNullAutocompletion(@InjectService(cardinality = 1, timeout = 5000) ServiceAware<GeoapifyService> geoapifyAware) {
		
		assertThat(geoapifyAware.getServices()).hasSize(1);	
		GeoapifyService geoapifyService = geoapifyAware.getService();
		assertThat(geoapifyService).isNotNull();		
		boolean thrownException = false;
		try {
			geoapifyService.getAddressByAutocompletion(null);
		} catch (IllegalArgumentException e) {
			thrownException = true;
		}
		assertThat(thrownException).isTrue();		
	}
	
//	@Test
	public void testEmptyAutocompletion(@InjectService(cardinality = 1, timeout = 5000) ServiceAware<GeoapifyService> geoapifyAware) {
		
		assertThat(geoapifyAware.getServices()).hasSize(1);	
		GeoapifyService geoapifyService = geoapifyAware.getService();
		assertThat(geoapifyService).isNotNull();		
		boolean thrownException = false;
		try {
			geoapifyService.getAddressByAutocompletion("");
		} catch (IllegalArgumentException e) {
			thrownException = true;
		}
		assertThat(thrownException).isTrue();		
	}
	
	
//	@Test
	public void testAutocompletion(@InjectService(cardinality = 1, timeout = 5000) ServiceAware<GeoapifyService> geoapifyAware) {
		
		assertThat(geoapifyAware.getServices()).hasSize(1);	
		GeoapifyService geoapifyService = geoapifyAware.getService();
		assertThat(geoapifyService).isNotNull();		
		
		FeatureCollection featureColl = geoapifyService.getAddressByAutocompletion("Otto-Devrient");
		assertThat(featureColl).isNotNull();		
		assertThat(featureColl.getFeatures()).isNotNull();
		assertThat(featureColl.getFeatures()).isNotEmpty();
	}
	
//	@Test
	public void testReverseGeocoding(@InjectService(cardinality = 1, timeout = 5000) ServiceAware<GeoapifyService> geoapifyAware) {
		
		assertThat(geoapifyAware.getServices()).hasSize(1);	
		GeoapifyService geoapifyService = geoapifyAware.getService();
		assertThat(geoapifyService).isNotNull();		
		
		FeatureCollection featureColl = geoapifyService.getReverseGeoCoding(50.9351052, 11.566824);
		assertThat(featureColl).isNotNull();		
		assertThat(featureColl.getFeatures()).isNotNull();
		assertThat(featureColl.getFeatures()).isNotEmpty();
	}
	
}
