/**
 * Copyright (c) 2012 - 2021 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package com.playertour.backend.geoapify;

import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ComponentPropertyType;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

import com.playertour.backend.apis.geoapify.GeoapifyAPIConfigService;

/**
 * 
 * @author ilenia
 * @since May 5, 2021
 */
@Component(immediate = true, configurationPolicy = ConfigurationPolicy.REQUIRE, configurationPid = "GeoapifyAPIConfigService")
@Designate(ocd = GeoapifyAPIConfigServiceImpl.APIConfig.class)
public class GeoapifyAPIConfigServiceImpl implements GeoapifyAPIConfigService {
	
	private APIConfig config;

	@ComponentPropertyType
	@ObjectClassDefinition
	public @interface APIConfig {
		
		String _apiKey();
		String apiBasePath() default "https://api.geoapify.com/v1/geocode/";
	}

	@Activate
	public void activate(APIConfig config) {
		this.config = config;
	}
	
	/* 
	 * (non-Javadoc)
	 * @see com.playertour.backend.apis.geoapify.GeoapifyAPIConfigService#getAPIKey()
	 */
	@Override
	public String getAPIKey() {
		return config._apiKey();
	}

	/* 
	 * (non-Javadoc)
	 * @see com.playertour.backend.apis.geoapify.GeoapifyAPIConfigService#getAPIBasePath()
	 */
	@Override
	public String getAPIBasePath() {
		return config.apiBasePath();
	}

}
