/**
 */
package com.playertour.backend.geojson.model.geojson.util;

import com.playertour.backend.geojson.model.geojson.*;

import java.util.Map;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.Switch;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see com.playertour.backend.geojson.model.geojson.GeoJSONPackage
 * @generated
 */
public class GeoJSONSwitch<T> extends Switch<T> {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static GeoJSONPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GeoJSONSwitch() {
		if (modelPackage == null) {
			modelPackage = GeoJSONPackage.eINSTANCE;
		}
	}

	/**
	 * Checks whether this is a switch for the given package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param ePackage the package in question.
	 * @return whether this is a switch for the given package.
	 * @generated
	 */
	@Override
	protected boolean isSwitchFor(EPackage ePackage) {
		return ePackage == modelPackage;
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	@Override
	protected T doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case GeoJSONPackage.GEO_JSON: {
				GeoJSON geoJSON = (GeoJSON)theEObject;
				T result = caseGeoJSON(geoJSON);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case GeoJSONPackage.ABSTRACT_GEOMETRY: {
				AbstractGeometry abstractGeometry = (AbstractGeometry)theEObject;
				T result = caseAbstractGeometry(abstractGeometry);
				if (result == null) result = caseGeoJSON(abstractGeometry);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case GeoJSONPackage.GEOMETRY_COLLECTION: {
				GeometryCollection geometryCollection = (GeometryCollection)theEObject;
				T result = caseGeometryCollection(geometryCollection);
				if (result == null) result = caseAbstractGeometry(geometryCollection);
				if (result == null) result = caseGeoJSON(geometryCollection);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case GeoJSONPackage.GEOMETRY: {
				Geometry geometry = (Geometry)theEObject;
				T result = caseGeometry(geometry);
				if (result == null) result = caseAbstractGeometry(geometry);
				if (result == null) result = caseGeoJSON(geometry);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case GeoJSONPackage.FEATURE: {
				Feature feature = (Feature)theEObject;
				T result = caseFeature(feature);
				if (result == null) result = caseGeoJSON(feature);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case GeoJSONPackage.FEATURE_COLLECTION: {
				FeatureCollection featureCollection = (FeatureCollection)theEObject;
				T result = caseFeatureCollection(featureCollection);
				if (result == null) result = caseGeoJSON(featureCollection);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case GeoJSONPackage.POINT: {
				Point point = (Point)theEObject;
				T result = casePoint(point);
				if (result == null) result = caseGeometry(point);
				if (result == null) result = caseAbstractGeometry(point);
				if (result == null) result = caseGeoJSON(point);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case GeoJSONPackage.LINE_STRING: {
				LineString lineString = (LineString)theEObject;
				T result = caseLineString(lineString);
				if (result == null) result = caseGeometry(lineString);
				if (result == null) result = caseAbstractGeometry(lineString);
				if (result == null) result = caseGeoJSON(lineString);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case GeoJSONPackage.MULTI_POINT: {
				MultiPoint multiPoint = (MultiPoint)theEObject;
				T result = caseMultiPoint(multiPoint);
				if (result == null) result = caseGeometry(multiPoint);
				if (result == null) result = caseAbstractGeometry(multiPoint);
				if (result == null) result = caseGeoJSON(multiPoint);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case GeoJSONPackage.POLYGON: {
				Polygon polygon = (Polygon)theEObject;
				T result = casePolygon(polygon);
				if (result == null) result = caseGeometry(polygon);
				if (result == null) result = caseAbstractGeometry(polygon);
				if (result == null) result = caseGeoJSON(polygon);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case GeoJSONPackage.MULTI_LINE_STRING: {
				MultiLineString multiLineString = (MultiLineString)theEObject;
				T result = caseMultiLineString(multiLineString);
				if (result == null) result = caseGeometry(multiLineString);
				if (result == null) result = caseAbstractGeometry(multiLineString);
				if (result == null) result = caseGeoJSON(multiLineString);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case GeoJSONPackage.MULTI_POLYGON: {
				MultiPolygon multiPolygon = (MultiPolygon)theEObject;
				T result = caseMultiPolygon(multiPolygon);
				if (result == null) result = caseGeometry(multiPolygon);
				if (result == null) result = caseAbstractGeometry(multiPolygon);
				if (result == null) result = caseGeoJSON(multiPolygon);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case GeoJSONPackage.STRING_TO_STRING_MAP: {
				@SuppressWarnings("unchecked") Map.Entry<String, String> stringToStringMap = (Map.Entry<String, String>)theEObject;
				T result = caseStringToStringMap(stringToStringMap);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Geo JSON</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Geo JSON</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseGeoJSON(GeoJSON object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Abstract Geometry</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Abstract Geometry</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAbstractGeometry(AbstractGeometry object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Geometry Collection</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Geometry Collection</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseGeometryCollection(GeometryCollection object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Geometry</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Geometry</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseGeometry(Geometry object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Feature</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Feature</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseFeature(Feature object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Feature Collection</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Feature Collection</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseFeatureCollection(FeatureCollection object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Point</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Point</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePoint(Point object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Line String</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Line String</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseLineString(LineString object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Multi Point</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Multi Point</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMultiPoint(MultiPoint object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Polygon</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Polygon</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePolygon(Polygon object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Multi Line String</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Multi Line String</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMultiLineString(MultiLineString object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Multi Polygon</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Multi Polygon</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMultiPolygon(MultiPolygon object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>String To String Map</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>String To String Map</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseStringToStringMap(Map.Entry<String, String> object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	@Override
	public T defaultCase(EObject object) {
		return null;
	}

} //GeoJSONSwitch
