/**
 * Copyright (c) 2012 - 2018 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package com.playertour.backend.golfcourse.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

import com.playertour.backend.api.GolfCourseSearchResult;
import com.playertour.backend.api.PlayerApiFactory;
import com.playertour.backend.api.PlayerApiPackage;
import com.playertour.backend.apis.course.CourseSearchService;
import com.playertour.backend.apis.mmt.common.PlayertourModelTransformator;
import com.playertour.backend.apis.mmt.common.UnknownTransformationException;
import com.playertour.backend.apis.player.APIGolfCourseService;
import com.playertour.backend.golfcourse.model.golfcourse.GolfCourse;

@Component
public class APIGolfCourseServiceImpl implements APIGolfCourseService{

	@Reference(target = ("(component.name=APIModelTransformator)"))
	PlayertourModelTransformator transformator;

	@Reference
	CourseSearchService courseSearchService;

	/* 
	 * (non-Javadoc)
	 * @see com.playertour.backend.apis.player.GolfCourseService#findCoursesNearMe(java.lang.String, java.lang.String, java.lang.Integer)
	 */
	@Override
	public List<GolfCourseSearchResult> findCoursesNearMe(String lat, String lng, Integer maxDistance) throws UnknownTransformationException{
		double maxDistInMeters = maxDistance*1000.;
		try {
			Double latitude = Double.parseDouble(lat);
			Double longitude = Double.parseDouble(lng);
			Map<GolfCourse, Double> resultMap = courseSearchService.getCoursesWithinDist(latitude, longitude, maxDistInMeters);
			List<GolfCourseSearchResult> results = new ArrayList<>(resultMap.keySet().size());
			for(Entry<GolfCourse, Double> e : resultMap.entrySet()) {
				com.playertour.backend.api.GolfCourse apiGolfCourse = transformator.transform(e.getKey(), PlayerApiPackage.Literals.GOLF_COURSE);
				GolfCourseSearchResult result = PlayerApiFactory.eINSTANCE.createGolfCourseSearchResult();
				result.setCourse(apiGolfCourse);
				result.setDistance(e.getValue());
				results.add(result);
			}
			return results;
		} catch(NumberFormatException e) {
			throw new IllegalArgumentException();
		}
	}

	/* 
	 * (non-Javadoc)
	 * @see com.playertour.backend.apis.player.GolfCourseService#findCourses(java.lang.String, int)
	 */
	@Override
	public List<GolfCourseSearchResult> findCourses(String query, int maxResults) throws UnknownTransformationException {

		List<GolfCourse> golfCourses = courseSearchService.getCoursesByName(query, maxResults);

		List<com.playertour.backend.api.GolfCourse> apiGolfCourses = transformator.transform(golfCourses, PlayerApiPackage.Literals.GOLF_COURSE);
		List<GolfCourseSearchResult> results = new ArrayList<>(apiGolfCourses.size());
		apiGolfCourses.stream().forEach(gc-> {
			GolfCourseSearchResult result = PlayerApiFactory.eINSTANCE.createGolfCourseSearchResult();
			result.setCourse(gc);
			results.add(result);
		});
		return results;

	}
}
