/**
 * Copyright (c) 2012 - 2022 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package com.playertour.backend.golfcourse.featuresadjacency.service.api;

import java.util.Arrays;

public enum GeometryType {
	Point,
	LineString,
	Polygon;
	
	public static GeometryType valueOfOrNull(String name) {
		if (isSupported(name)) {
			return GeometryType.valueOf(name);
		} else {
			return null;
		}
	}
	
	public static boolean isSupported(String name) {
		return Arrays.stream(GeometryType.values()).anyMatch(gt -> gt.name().equalsIgnoreCase(name));
	}
}
