/**
 * Copyright (c) 2012 - 2022 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package com.playertour.backend.golfcourse.featuresadjacency.service.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class GolfCourseFeature {
	final GolfCourseFeatureType featureType;
	final GeometryType geometryType;
	final List<org.locationtech.spatial4j.shape.Shape> shapes;

	public GolfCourseFeature(GolfCourseFeatureType featureType, GeometryType geometryType,
			org.locationtech.spatial4j.shape.Shape shape) {
		this.shapes = new ArrayList<org.locationtech.spatial4j.shape.Shape>();

		this.featureType = featureType;
		this.geometryType = geometryType;
		addShape(shape);
	}

	/**
	 * Returns the feature type.
	 * 
	 * @return the feature type
	 */
	public GolfCourseFeatureType getFeatureType() {
		return featureType;
	}

	/**
	 * Returns the geometryType.
	 * 
	 * @return the geometryType
	 */
	public GeometryType getGeometryType() {
		return geometryType;
	}

	/**
	 * Returns the shape.
	 * 
	 * @return the shape
	 */
	public int getShapeCount() {
		return shapes.size();
	}

	public org.locationtech.spatial4j.shape.Shape getShape() {
		return shapes.get(0);
	}

	public List<org.locationtech.spatial4j.shape.Shape> getShapes() {
		return shapes;
	}

	public void addShape(org.locationtech.spatial4j.shape.Shape shape) {
		this.shapes.add(shape);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		return Objects.hash(featureType, geometryType);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		GolfCourseFeature other = (GolfCourseFeature) obj;
		return featureType == other.featureType && geometryType == other.geometryType;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "GolfCourseFeature [featureType=" + featureType + ", geometryType=" + geometryType + ", shapeCount="
				+ getShapeCount() + "]";
	}
}
