/**
 * Copyright (c) 2012 - 2022 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package com.playertour.backend.golfcourse.featuresadjacency.service.api;

import java.util.Objects;

public class GolfCourseFeatureConnection {
	final GolfCourseFeature source;
	final GolfCourseFeature destination;
	final double distance;

	public GolfCourseFeatureConnection(GolfCourseFeature source, GolfCourseFeature destination, double distance) {
		this.source = source;
		this.destination = destination;
		this.distance = distance;
	}

	public double getDistance() {
		return distance;
	}

	public GolfCourseFeature getSource() {
		return source;
	}

	public GolfCourseFeature getDestination() {
		return destination;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		GolfCourseFeatureConnection other = (GolfCourseFeatureConnection) obj;
		return Objects.equals(source, other.source) && Objects.equals(destination, other.destination);
	}

	@Override
	public int hashCode() {
		return Objects.hash(source, destination);
	}

	@Override
	public String toString() {
		return "GolfCourseFeatureConnection [source=" + source + ", destination=" + destination + ", distance="
				+ distance + "]";
	}
}
