/**
 * Copyright (c) 2012 - 2022 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package com.playertour.backend.golfcourse.featuresadjacency.service.api;

public enum GolfCourseFeatureType {
	// @formatter:off
	//background("Background", null),
	background("Background", "backgrund"), // spelling error is present in model, which is persisted in MongoDB for several thousand golf courses!
	ocean("Ocean", null),
	bridge("Bridge", null),
	vegetation("Vegetation", null),
	creek("Creek", null),
	pond("Pond", null),
	sand("Sand", null),
	rock("Rock", null),
	lake("Lake", null),
	water("Water", null),
	tree("Tree", null),
	clubHouse("ClubHouse", null),
	lava("Lava", null),
	path("Path", null),
	green("Green", null),
	greenCenter("GreenCenter", null),
	bunker("Bunker", null),
	centralPath("CentralPath", null),
	fairway("Fairway", null),
	perimeter("Perimeter", null),
	teeBox("TeeBox", null),
	teeBoxCenter("TeeBoxCenter", null);
	// @formatter:on

	private String label;
	private String internalName; // handle special cases where internal name used is different, e.g. like for 'backgrund' (see comment above)
	
	private GolfCourseFeatureType(String label, String internalName) {
		this.label = label;
		this.internalName = internalName;
	}		

	public String getLabel() {
		return label;
	}

	public String getInternalName() {
		if (internalName != null) {
			return internalName; 
		} else {
			return name();
		}
	}
}
