/**
 * Copyright (c) 2012 - 2022 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package com.playertour.backend.golfcourse.featuresadjacency.service.api;

import java.util.Objects;

import org.locationtech.spatial4j.shape.Shape;

public class GolfCourseHoleFeature extends GolfCourseFeature {
	final Integer holeNumber;

	public GolfCourseHoleFeature(GolfCourseFeatureType featureType, GeometryType geometryType, Shape shape,
			Integer holeNumber) {
		super(featureType, geometryType, shape);
		this.holeNumber = holeNumber;
	}

	/**
	 * Returns the holeNumber.
	 * 
	 * @return the holeNumber
	 */
	public Integer getHoleNumber() {
		return holeNumber;
	}

	@Override
	public int hashCode() {
		return Objects.hash(featureType, geometryType, holeNumber);
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		GolfCourseHoleFeature other = (GolfCourseHoleFeature) obj;
		return featureType == other.featureType && geometryType == other.geometryType
				&& Objects.equals(holeNumber, other.holeNumber);
	}

	@Override
	public String toString() {
		return "GolfCourseHoleFeature [holeNumber=" + holeNumber + ", featureType=" + featureType + ", geometryType="
				+ geometryType + ", shapeCount=" + getShapeCount() + "]";
	}
}