/**
 * Copyright (c) 2012 - 2021 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package com.playertour.backend.healthcheck;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.osgi.service.component.annotations.ComponentPropertyType;
import org.osgi.service.jaxrs.whiteboard.JaxrsWhiteboardConstants;

/**
 * Temporarily workaround because placing the JaxrsApplicationSelect annotation on this annotation is not doing the job.
 * So we copied the content of JaxrsApplicationSelect in here and set the default value as the one we want!
 * @author ilenia
 * @since Apr 16, 2021
 */
@ComponentPropertyType
@Retention(RetentionPolicy.CLASS)
@Target(ElementType.TYPE)
public @interface HealthCheckApplicationTarget {
	/**
	 * Prefix for the property name. This value is prepended to each property
	 * name.
	 */
	String PREFIX_ = "osgi.";

	/**
	 * Service property providing an OSGi filter identifying the application(s)
	 * to which this service should be bound.
	 * 
	 * @return The filter for selecting the applications to bind to.
	 * @see org.osgi.service.jaxrs.whiteboard.JaxrsWhiteboardConstants#JAX_RS_APPLICATION_SELECT
	 */
	String jaxrs_application_select() default "(" + JaxrsWhiteboardConstants.JAX_RS_NAME + "=" + HealthCheckConstants.JAX_RS_APPLICATION_NAME + ")";
}
