/**
 */
package com.playertour.backend.igolf.model.igolf;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see com.playertour.backend.igolf.model.igolf.IGolfFactory
 * @model kind="package"
 * @generated
 */
public interface IGolfPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "igolf";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://theplayertour.com/backend/igolf/1.0";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "igolf";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	IGolfPackage eINSTANCE = com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl.init();

	/**
	 * The meta object id for the '{@link com.playertour.backend.igolf.model.igolf.impl.ResponseImpl <em>Response</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.igolf.model.igolf.impl.ResponseImpl
	 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getResponse()
	 * @generated
	 */
	int RESPONSE = 0;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESPONSE__STATUS = 0;

	/**
	 * The feature id for the '<em><b>Error Message</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESPONSE__ERROR_MESSAGE = 1;

	/**
	 * The number of structural features of the '<em>Response</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESPONSE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Response</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESPONSE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.igolf.model.igolf.impl.CourseListResponseImpl <em>Course List Response</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.igolf.model.igolf.impl.CourseListResponseImpl
	 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getCourseListResponse()
	 * @generated
	 */
	int COURSE_LIST_RESPONSE = 1;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_LIST_RESPONSE__STATUS = RESPONSE__STATUS;

	/**
	 * The feature id for the '<em><b>Error Message</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_LIST_RESPONSE__ERROR_MESSAGE = RESPONSE__ERROR_MESSAGE;

	/**
	 * The feature id for the '<em><b>Course List</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_LIST_RESPONSE__COURSE_LIST = RESPONSE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Page</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_LIST_RESPONSE__PAGE = RESPONSE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Totalpages</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_LIST_RESPONSE__TOTALPAGES = RESPONSE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Total Courses</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_LIST_RESPONSE__TOTAL_COURSES = RESPONSE_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Course List Response</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_LIST_RESPONSE_FEATURE_COUNT = RESPONSE_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>Course List Response</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_LIST_RESPONSE_OPERATION_COUNT = RESPONSE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.igolf.model.igolf.impl.CourseInfoImpl <em>Course Info</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.igolf.model.igolf.impl.CourseInfoImpl
	 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getCourseInfo()
	 * @generated
	 */
	int COURSE_INFO = 2;

	/**
	 * The feature id for the '<em><b>Active</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_INFO__ACTIVE = 0;

	/**
	 * The feature id for the '<em><b>Id course</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_INFO__ID_COURSE = 1;

	/**
	 * The feature id for the '<em><b>Course Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_INFO__COURSE_NAME = 2;

	/**
	 * The feature id for the '<em><b>Email</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_INFO__EMAIL = 3;

	/**
	 * The feature id for the '<em><b>Address1</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_INFO__ADDRESS1 = 4;

	/**
	 * The feature id for the '<em><b>Address2</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_INFO__ADDRESS2 = 5;

	/**
	 * The feature id for the '<em><b>City</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_INFO__CITY = 6;

	/**
	 * The feature id for the '<em><b>Id country</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_INFO__ID_COUNTRY = 7;

	/**
	 * The feature id for the '<em><b>Country Full</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_INFO__COUNTRY_FULL = 8;

	/**
	 * The feature id for the '<em><b>Country Short</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_INFO__COUNTRY_SHORT = 9;

	/**
	 * The feature id for the '<em><b>Distance</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_INFO__DISTANCE = 10;

	/**
	 * The feature id for the '<em><b>Latitude</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_INFO__LATITUDE = 11;

	/**
	 * The feature id for the '<em><b>Longitude</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_INFO__LONGITUDE = 12;

	/**
	 * The feature id for the '<em><b>Scorecard Available</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_INFO__SCORECARD_AVAILABLE = 13;

	/**
	 * The feature id for the '<em><b>Gps Available</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_INFO__GPS_AVAILABLE = 14;

	/**
	 * The feature id for the '<em><b>Vector Available</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_INFO__VECTOR_AVAILABLE = 15;

	/**
	 * The feature id for the '<em><b>Recommended Rating</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_INFO__RECOMMENDED_RATING = 16;

	/**
	 * The feature id for the '<em><b>Condition Rating</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_INFO__CONDITION_RATING = 17;

	/**
	 * The feature id for the '<em><b>Id state</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_INFO__ID_STATE = 18;

	/**
	 * The feature id for the '<em><b>State Full</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_INFO__STATE_FULL = 19;

	/**
	 * The feature id for the '<em><b>State Short</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_INFO__STATE_SHORT = 20;

	/**
	 * The feature id for the '<em><b>Zip Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_INFO__ZIP_CODE = 21;

	/**
	 * The number of structural features of the '<em>Course Info</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_INFO_FEATURE_COUNT = 22;

	/**
	 * The number of operations of the '<em>Course Info</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_INFO_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.igolf.model.igolf.impl.CourseDetailsResponseImpl <em>Course Details Response</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.igolf.model.igolf.impl.CourseDetailsResponseImpl
	 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getCourseDetailsResponse()
	 * @generated
	 */
	int COURSE_DETAILS_RESPONSE = 3;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_DETAILS_RESPONSE__STATUS = RESPONSE__STATUS;

	/**
	 * The feature id for the '<em><b>Error Message</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_DETAILS_RESPONSE__ERROR_MESSAGE = RESPONSE__ERROR_MESSAGE;

	/**
	 * The feature id for the '<em><b>Active</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_DETAILS_RESPONSE__ACTIVE = RESPONSE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Course Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_DETAILS_RESPONSE__COURSE_NAME = RESPONSE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Email</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_DETAILS_RESPONSE__EMAIL = RESPONSE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Address1</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_DETAILS_RESPONSE__ADDRESS1 = RESPONSE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Address2</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_DETAILS_RESPONSE__ADDRESS2 = RESPONSE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>City</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_DETAILS_RESPONSE__CITY = RESPONSE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Id country</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_DETAILS_RESPONSE__ID_COUNTRY = RESPONSE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Country Full</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_DETAILS_RESPONSE__COUNTRY_FULL = RESPONSE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Country Short</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_DETAILS_RESPONSE__COUNTRY_SHORT = RESPONSE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Scorecard Available</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_DETAILS_RESPONSE__SCORECARD_AVAILABLE = RESPONSE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Gps Available</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_DETAILS_RESPONSE__GPS_AVAILABLE = RESPONSE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Id state</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_DETAILS_RESPONSE__ID_STATE = RESPONSE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>State Full</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_DETAILS_RESPONSE__STATE_FULL = RESPONSE_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>State Short</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_DETAILS_RESPONSE__STATE_SHORT = RESPONSE_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Zip Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_DETAILS_RESPONSE__ZIP_CODE = RESPONSE_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_DETAILS_RESPONSE__CLASS = RESPONSE_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Image</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_DETAILS_RESPONSE__IMAGE = RESPONSE_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Layout Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_DETAILS_RESPONSE__LAYOUT_NAME = RESPONSE_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Phone</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_DETAILS_RESPONSE__PHONE = RESPONSE_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Url</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_DETAILS_RESPONSE__URL = RESPONSE_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Fax</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_DETAILS_RESPONSE__FAX = RESPONSE_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Day Closed</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_DETAILS_RESPONSE__DAY_CLOSED = RESPONSE_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Dress Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_DETAILS_RESPONSE__DRESS_CODE = RESPONSE_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Layout Holes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_DETAILS_RESPONSE__LAYOUT_HOLES = RESPONSE_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>Layout Total Holes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_DETAILS_RESPONSE__LAYOUT_TOTAL_HOLES = RESPONSE_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>Seasonal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_DETAILS_RESPONSE__SEASONAL = RESPONSE_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Pricing</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_DETAILS_RESPONSE__PRICING = RESPONSE_FEATURE_COUNT + 26;

	/**
	 * The feature id for the '<em><b>Latitude</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_DETAILS_RESPONSE__LATITUDE = RESPONSE_FEATURE_COUNT + 27;

	/**
	 * The feature id for the '<em><b>Longitude</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_DETAILS_RESPONSE__LONGITUDE = RESPONSE_FEATURE_COUNT + 28;

	/**
	 * The number of structural features of the '<em>Course Details Response</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_DETAILS_RESPONSE_FEATURE_COUNT = RESPONSE_FEATURE_COUNT + 29;

	/**
	 * The number of operations of the '<em>Course Details Response</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_DETAILS_RESPONSE_OPERATION_COUNT = RESPONSE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.igolf.model.igolf.impl.PriceImpl <em>Price</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.igolf.model.igolf.impl.PriceImpl
	 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getPrice()
	 * @generated
	 */
	int PRICE = 4;

	/**
	 * The feature id for the '<em><b>Weekend9</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRICE__WEEKEND9 = 0;

	/**
	 * The feature id for the '<em><b>Weekend18</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRICE__WEEKEND18 = 1;

	/**
	 * The feature id for the '<em><b>Weekday9</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRICE__WEEKDAY9 = 2;

	/**
	 * The feature id for the '<em><b>Weekday18</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRICE__WEEKDAY18 = 3;

	/**
	 * The feature id for the '<em><b>Twilight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRICE__TWILIGHT = 4;

	/**
	 * The number of structural features of the '<em>Price</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRICE_FEATURE_COUNT = 5;

	/**
	 * The number of operations of the '<em>Price</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PRICE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.igolf.model.igolf.impl.CountryListResponseImpl <em>Country List Response</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.igolf.model.igolf.impl.CountryListResponseImpl
	 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getCountryListResponse()
	 * @generated
	 */
	int COUNTRY_LIST_RESPONSE = 5;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNTRY_LIST_RESPONSE__STATUS = RESPONSE__STATUS;

	/**
	 * The feature id for the '<em><b>Error Message</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNTRY_LIST_RESPONSE__ERROR_MESSAGE = RESPONSE__ERROR_MESSAGE;

	/**
	 * The feature id for the '<em><b>Country List</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNTRY_LIST_RESPONSE__COUNTRY_LIST = RESPONSE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Country List Response</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNTRY_LIST_RESPONSE_FEATURE_COUNT = RESPONSE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Country List Response</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNTRY_LIST_RESPONSE_OPERATION_COUNT = RESPONSE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.igolf.model.igolf.impl.CountryInfoImpl <em>Country Info</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.igolf.model.igolf.impl.CountryInfoImpl
	 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getCountryInfo()
	 * @generated
	 */
	int COUNTRY_INFO = 6;

	/**
	 * The feature id for the '<em><b>Country Full</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNTRY_INFO__COUNTRY_FULL = 0;

	/**
	 * The feature id for the '<em><b>Country Short</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNTRY_INFO__COUNTRY_SHORT = 1;

	/**
	 * The feature id for the '<em><b>Id country</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNTRY_INFO__ID_COUNTRY = 2;

	/**
	 * The feature id for the '<em><b>Id continent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNTRY_INFO__ID_CONTINENT = 3;

	/**
	 * The number of structural features of the '<em>Country Info</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNTRY_INFO_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>Country Info</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNTRY_INFO_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.igolf.model.igolf.impl.StateListResponseImpl <em>State List Response</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.igolf.model.igolf.impl.StateListResponseImpl
	 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getStateListResponse()
	 * @generated
	 */
	int STATE_LIST_RESPONSE = 7;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE_LIST_RESPONSE__STATUS = RESPONSE__STATUS;

	/**
	 * The feature id for the '<em><b>Error Message</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE_LIST_RESPONSE__ERROR_MESSAGE = RESPONSE__ERROR_MESSAGE;

	/**
	 * The feature id for the '<em><b>State List</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE_LIST_RESPONSE__STATE_LIST = RESPONSE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>State List Response</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE_LIST_RESPONSE_FEATURE_COUNT = RESPONSE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>State List Response</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE_LIST_RESPONSE_OPERATION_COUNT = RESPONSE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.igolf.model.igolf.impl.StateInfoImpl <em>State Info</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.igolf.model.igolf.impl.StateInfoImpl
	 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getStateInfo()
	 * @generated
	 */
	int STATE_INFO = 8;

	/**
	 * The feature id for the '<em><b>Id country</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE_INFO__ID_COUNTRY = 0;

	/**
	 * The feature id for the '<em><b>Id state</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE_INFO__ID_STATE = 1;

	/**
	 * The feature id for the '<em><b>State Full</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE_INFO__STATE_FULL = 2;

	/**
	 * The feature id for the '<em><b>State Short</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE_INFO__STATE_SHORT = 3;

	/**
	 * The number of structural features of the '<em>State Info</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE_INFO_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>State Info</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE_INFO_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.igolf.model.igolf.impl.CourseGPSVectorResponseImpl <em>Course GPS Vector Response</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.igolf.model.igolf.impl.CourseGPSVectorResponseImpl
	 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getCourseGPSVectorResponse()
	 * @generated
	 */
	int COURSE_GPS_VECTOR_RESPONSE = 9;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_GPS_VECTOR_RESPONSE__STATUS = RESPONSE__STATUS;

	/**
	 * The feature id for the '<em><b>Error Message</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_GPS_VECTOR_RESPONSE__ERROR_MESSAGE = RESPONSE__ERROR_MESSAGE;

	/**
	 * The feature id for the '<em><b>Vector GPS Object</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_GPS_VECTOR_RESPONSE__VECTOR_GPS_OBJECT = RESPONSE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Course GPS Vector Response</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_GPS_VECTOR_RESPONSE_FEATURE_COUNT = RESPONSE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Course GPS Vector Response</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_GPS_VECTOR_RESPONSE_OPERATION_COUNT = RESPONSE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.igolf.model.igolf.impl.ShapeObjectImpl <em>Shape Object</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.igolf.model.igolf.impl.ShapeObjectImpl
	 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getShapeObject()
	 * @generated
	 */
	int SHAPE_OBJECT = 10;

	/**
	 * The feature id for the '<em><b>Shape Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHAPE_OBJECT__SHAPE_COUNT = 0;

	/**
	 * The feature id for the '<em><b>Shapes</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHAPE_OBJECT__SHAPES = 1;

	/**
	 * The number of structural features of the '<em>Shape Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHAPE_OBJECT_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Shape Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHAPE_OBJECT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.igolf.model.igolf.impl.ShapesImpl <em>Shapes</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.igolf.model.igolf.impl.ShapesImpl
	 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getShapes()
	 * @generated
	 */
	int SHAPES = 11;

	/**
	 * The feature id for the '<em><b>Shape</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHAPES__SHAPE = 0;

	/**
	 * The number of structural features of the '<em>Shapes</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHAPES_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Shapes</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHAPES_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.igolf.model.igolf.impl.ShapeImpl <em>Shape</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.igolf.model.igolf.impl.ShapeImpl
	 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getShape()
	 * @generated
	 */
	int SHAPE = 12;

	/**
	 * The feature id for the '<em><b>Attributes</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHAPE__ATTRIBUTES = 0;

	/**
	 * The feature id for the '<em><b>Points</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHAPE__POINTS = 1;

	/**
	 * The number of structural features of the '<em>Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHAPE_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Shape</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHAPE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.igolf.model.igolf.impl.AttributesImpl <em>Attributes</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.igolf.model.igolf.impl.AttributesImpl
	 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getAttributes()
	 * @generated
	 */
	int ATTRIBUTES = 13;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTES__DESCRIPTION = 0;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTES__TYPE = 1;

	/**
	 * The feature id for the '<em><b>Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTES__SIZE = 2;

	/**
	 * The number of structural features of the '<em>Attributes</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTES_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Attributes</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ATTRIBUTES_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.igolf.model.igolf.impl.VectorGPSObjectImpl <em>Vector GPS Object</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.igolf.model.igolf.impl.VectorGPSObjectImpl
	 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getVectorGPSObject()
	 * @generated
	 */
	int VECTOR_GPS_OBJECT = 14;

	/**
	 * The feature id for the '<em><b>Hole Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VECTOR_GPS_OBJECT__HOLE_COUNT = 0;

	/**
	 * The feature id for the '<em><b>Ocean</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VECTOR_GPS_OBJECT__OCEAN = 1;

	/**
	 * The feature id for the '<em><b>Background</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VECTOR_GPS_OBJECT__BACKGROUND = 2;

	/**
	 * The feature id for the '<em><b>Bridge</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VECTOR_GPS_OBJECT__BRIDGE = 3;

	/**
	 * The feature id for the '<em><b>Vegetation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VECTOR_GPS_OBJECT__VEGETATION = 4;

	/**
	 * The feature id for the '<em><b>Lava</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VECTOR_GPS_OBJECT__LAVA = 5;

	/**
	 * The feature id for the '<em><b>Path</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VECTOR_GPS_OBJECT__PATH = 6;

	/**
	 * The feature id for the '<em><b>Tree</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VECTOR_GPS_OBJECT__TREE = 7;

	/**
	 * The feature id for the '<em><b>Lake</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VECTOR_GPS_OBJECT__LAKE = 8;

	/**
	 * The feature id for the '<em><b>Water</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VECTOR_GPS_OBJECT__WATER = 9;

	/**
	 * The feature id for the '<em><b>Clubhouse</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VECTOR_GPS_OBJECT__CLUBHOUSE = 10;

	/**
	 * The feature id for the '<em><b>Pond</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VECTOR_GPS_OBJECT__POND = 11;

	/**
	 * The feature id for the '<em><b>Creek</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VECTOR_GPS_OBJECT__CREEK = 12;

	/**
	 * The feature id for the '<em><b>Sand</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VECTOR_GPS_OBJECT__SAND = 13;

	/**
	 * The feature id for the '<em><b>Rock</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VECTOR_GPS_OBJECT__ROCK = 14;

	/**
	 * The feature id for the '<em><b>Holes</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VECTOR_GPS_OBJECT__HOLES = 15;

	/**
	 * The number of structural features of the '<em>Vector GPS Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VECTOR_GPS_OBJECT_FEATURE_COUNT = 16;

	/**
	 * The number of operations of the '<em>Vector GPS Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VECTOR_GPS_OBJECT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.igolf.model.igolf.impl.HolesImpl <em>Holes</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.igolf.model.igolf.impl.HolesImpl
	 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getHoles()
	 * @generated
	 */
	int HOLES = 15;

	/**
	 * The feature id for the '<em><b>Hole</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOLES__HOLE = 0;

	/**
	 * The number of structural features of the '<em>Holes</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOLES_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Holes</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOLES_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.igolf.model.igolf.impl.HoleImpl <em>Hole</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.igolf.model.igolf.impl.HoleImpl
	 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getHole()
	 * @generated
	 */
	int HOLE = 16;

	/**
	 * The feature id for the '<em><b>Hole Number</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOLE__HOLE_NUMBER = 0;

	/**
	 * The feature id for the '<em><b>Greencenter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOLE__GREENCENTER = 1;

	/**
	 * The feature id for the '<em><b>Bunker</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOLE__BUNKER = 2;

	/**
	 * The feature id for the '<em><b>Centralpath</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOLE__CENTRALPATH = 3;

	/**
	 * The feature id for the '<em><b>Teeboxcenter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOLE__TEEBOXCENTER = 4;

	/**
	 * The feature id for the '<em><b>Perimeter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOLE__PERIMETER = 5;

	/**
	 * The feature id for the '<em><b>Green</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOLE__GREEN = 6;

	/**
	 * The feature id for the '<em><b>Fairway</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOLE__FAIRWAY = 7;

	/**
	 * The feature id for the '<em><b>Teebox</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOLE__TEEBOX = 8;

	/**
	 * The number of structural features of the '<em>Hole</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOLE_FEATURE_COUNT = 9;

	/**
	 * The number of operations of the '<em>Hole</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HOLE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.igolf.model.igolf.impl.CourseCompleteResponseImpl <em>Course Complete Response</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.igolf.model.igolf.impl.CourseCompleteResponseImpl
	 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getCourseCompleteResponse()
	 * @generated
	 */
	int COURSE_COMPLETE_RESPONSE = 17;

	/**
	 * The feature id for the '<em><b>Course Details</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_COMPLETE_RESPONSE__COURSE_DETAILS = 0;

	/**
	 * The feature id for the '<em><b>Course GPS Vector</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_COMPLETE_RESPONSE__COURSE_GPS_VECTOR = 1;

	/**
	 * The feature id for the '<em><b>Course Info</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_COMPLETE_RESPONSE__COURSE_INFO = 2;

	/**
	 * The feature id for the '<em><b>Scorecard Details</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_COMPLETE_RESPONSE__SCORECARD_DETAILS = 3;

	/**
	 * The feature id for the '<em><b>Tee Details</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_COMPLETE_RESPONSE__TEE_DETAILS = 4;

	/**
	 * The number of structural features of the '<em>Course Complete Response</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_COMPLETE_RESPONSE_FEATURE_COUNT = 5;

	/**
	 * The number of operations of the '<em>Course Complete Response</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_COMPLETE_RESPONSE_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.igolf.model.igolf.impl.PayloadImpl <em>Payload</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.igolf.model.igolf.impl.PayloadImpl
	 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getPayload()
	 * @generated
	 */
	int PAYLOAD = 18;

	/**
	 * The number of structural features of the '<em>Payload</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PAYLOAD_FEATURE_COUNT = 0;

	/**
	 * The number of operations of the '<em>Payload</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PAYLOAD_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.igolf.model.igolf.impl.RequestImpl <em>Request</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.igolf.model.igolf.impl.RequestImpl
	 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getRequest()
	 * @generated
	 */
	int REQUEST = 19;

	/**
	 * The feature id for the '<em><b>Payload</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUEST__PAYLOAD = 0;

	/**
	 * The number of structural features of the '<em>Request</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUEST_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Request</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REQUEST_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.igolf.model.igolf.impl.CourseDetailsRequestImpl <em>Course Details Request</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.igolf.model.igolf.impl.CourseDetailsRequestImpl
	 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getCourseDetailsRequest()
	 * @generated
	 */
	int COURSE_DETAILS_REQUEST = 20;

	/**
	 * The feature id for the '<em><b>Payload</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_DETAILS_REQUEST__PAYLOAD = REQUEST__PAYLOAD;

	/**
	 * The number of structural features of the '<em>Course Details Request</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_DETAILS_REQUEST_FEATURE_COUNT = REQUEST_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Course Details Request</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_DETAILS_REQUEST_OPERATION_COUNT = REQUEST_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.igolf.model.igolf.impl.CourseListRequestImpl <em>Course List Request</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.igolf.model.igolf.impl.CourseListRequestImpl
	 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getCourseListRequest()
	 * @generated
	 */
	int COURSE_LIST_REQUEST = 21;

	/**
	 * The feature id for the '<em><b>Payload</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_LIST_REQUEST__PAYLOAD = REQUEST__PAYLOAD;

	/**
	 * The number of structural features of the '<em>Course List Request</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_LIST_REQUEST_FEATURE_COUNT = REQUEST_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Course List Request</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_LIST_REQUEST_OPERATION_COUNT = REQUEST_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.igolf.model.igolf.impl.CourseGPSVectorRequestImpl <em>Course GPS Vector Request</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.igolf.model.igolf.impl.CourseGPSVectorRequestImpl
	 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getCourseGPSVectorRequest()
	 * @generated
	 */
	int COURSE_GPS_VECTOR_REQUEST = 22;

	/**
	 * The feature id for the '<em><b>Payload</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_GPS_VECTOR_REQUEST__PAYLOAD = REQUEST__PAYLOAD;

	/**
	 * The number of structural features of the '<em>Course GPS Vector Request</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_GPS_VECTOR_REQUEST_FEATURE_COUNT = REQUEST_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Course GPS Vector Request</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_GPS_VECTOR_REQUEST_OPERATION_COUNT = REQUEST_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.igolf.model.igolf.impl.CountryListRequestImpl <em>Country List Request</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.igolf.model.igolf.impl.CountryListRequestImpl
	 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getCountryListRequest()
	 * @generated
	 */
	int COUNTRY_LIST_REQUEST = 23;

	/**
	 * The feature id for the '<em><b>Payload</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNTRY_LIST_REQUEST__PAYLOAD = REQUEST__PAYLOAD;

	/**
	 * The number of structural features of the '<em>Country List Request</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNTRY_LIST_REQUEST_FEATURE_COUNT = REQUEST_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Country List Request</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNTRY_LIST_REQUEST_OPERATION_COUNT = REQUEST_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.igolf.model.igolf.impl.StateListRequestImpl <em>State List Request</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.igolf.model.igolf.impl.StateListRequestImpl
	 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getStateListRequest()
	 * @generated
	 */
	int STATE_LIST_REQUEST = 24;

	/**
	 * The feature id for the '<em><b>Payload</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE_LIST_REQUEST__PAYLOAD = REQUEST__PAYLOAD;

	/**
	 * The number of structural features of the '<em>State List Request</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE_LIST_REQUEST_FEATURE_COUNT = REQUEST_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>State List Request</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE_LIST_REQUEST_OPERATION_COUNT = REQUEST_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.igolf.model.igolf.impl.ScorecardDetailsRequestImpl <em>Scorecard Details Request</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.igolf.model.igolf.impl.ScorecardDetailsRequestImpl
	 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getScorecardDetailsRequest()
	 * @generated
	 */
	int SCORECARD_DETAILS_REQUEST = 25;

	/**
	 * The feature id for the '<em><b>Payload</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORECARD_DETAILS_REQUEST__PAYLOAD = REQUEST__PAYLOAD;

	/**
	 * The number of structural features of the '<em>Scorecard Details Request</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORECARD_DETAILS_REQUEST_FEATURE_COUNT = REQUEST_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Scorecard Details Request</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORECARD_DETAILS_REQUEST_OPERATION_COUNT = REQUEST_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.igolf.model.igolf.impl.ScorecardListRequestImpl <em>Scorecard List Request</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.igolf.model.igolf.impl.ScorecardListRequestImpl
	 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getScorecardListRequest()
	 * @generated
	 */
	int SCORECARD_LIST_REQUEST = 26;

	/**
	 * The feature id for the '<em><b>Payload</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORECARD_LIST_REQUEST__PAYLOAD = REQUEST__PAYLOAD;

	/**
	 * The number of structural features of the '<em>Scorecard List Request</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORECARD_LIST_REQUEST_FEATURE_COUNT = REQUEST_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Scorecard List Request</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORECARD_LIST_REQUEST_OPERATION_COUNT = REQUEST_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.igolf.model.igolf.impl.CourseTeeDetailsRequestImpl <em>Course Tee Details Request</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.igolf.model.igolf.impl.CourseTeeDetailsRequestImpl
	 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getCourseTeeDetailsRequest()
	 * @generated
	 */
	int COURSE_TEE_DETAILS_REQUEST = 27;

	/**
	 * The feature id for the '<em><b>Payload</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_TEE_DETAILS_REQUEST__PAYLOAD = REQUEST__PAYLOAD;

	/**
	 * The number of structural features of the '<em>Course Tee Details Request</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_TEE_DETAILS_REQUEST_FEATURE_COUNT = REQUEST_FEATURE_COUNT + 0;

	/**
	 * The number of operations of the '<em>Course Tee Details Request</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_TEE_DETAILS_REQUEST_OPERATION_COUNT = REQUEST_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.igolf.model.igolf.impl.CourseDetailsPayloadImpl <em>Course Details Payload</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.igolf.model.igolf.impl.CourseDetailsPayloadImpl
	 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getCourseDetailsPayload()
	 * @generated
	 */
	int COURSE_DETAILS_PAYLOAD = 28;

	/**
	 * The feature id for the '<em><b>Id course</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_DETAILS_PAYLOAD__ID_COURSE = PAYLOAD_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Detail Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_DETAILS_PAYLOAD__DETAIL_LEVEL = PAYLOAD_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Country Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_DETAILS_PAYLOAD__COUNTRY_FORMAT = PAYLOAD_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>State Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_DETAILS_PAYLOAD__STATE_FORMAT = PAYLOAD_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Course Details Payload</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_DETAILS_PAYLOAD_FEATURE_COUNT = PAYLOAD_FEATURE_COUNT + 4;

	/**
	 * The number of operations of the '<em>Course Details Payload</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_DETAILS_PAYLOAD_OPERATION_COUNT = PAYLOAD_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.igolf.model.igolf.impl.CourseListPayloadImpl <em>Course List Payload</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.igolf.model.igolf.impl.CourseListPayloadImpl
	 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getCourseListPayload()
	 * @generated
	 */
	int COURSE_LIST_PAYLOAD = 29;

	/**
	 * The feature id for the '<em><b>Active</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_LIST_PAYLOAD__ACTIVE = PAYLOAD_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Id country</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_LIST_PAYLOAD__ID_COUNTRY = PAYLOAD_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Country Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_LIST_PAYLOAD__COUNTRY_FORMAT = PAYLOAD_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Id state</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_LIST_PAYLOAD__ID_STATE = PAYLOAD_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>State Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_LIST_PAYLOAD__STATE_FORMAT = PAYLOAD_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>City</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_LIST_PAYLOAD__CITY = PAYLOAD_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Zipcode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_LIST_PAYLOAD__ZIPCODE = PAYLOAD_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Course Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_LIST_PAYLOAD__COURSE_NAME = PAYLOAD_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Radius</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_LIST_PAYLOAD__RADIUS = PAYLOAD_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Reference Latitude</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_LIST_PAYLOAD__REFERENCE_LATITUDE = PAYLOAD_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Reference Longitude</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_LIST_PAYLOAD__REFERENCE_LONGITUDE = PAYLOAD_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Page</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_LIST_PAYLOAD__PAGE = PAYLOAD_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Results Per Page</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_LIST_PAYLOAD__RESULTS_PER_PAGE = PAYLOAD_FEATURE_COUNT + 12;

	/**
	 * The number of structural features of the '<em>Course List Payload</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_LIST_PAYLOAD_FEATURE_COUNT = PAYLOAD_FEATURE_COUNT + 13;

	/**
	 * The number of operations of the '<em>Course List Payload</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_LIST_PAYLOAD_OPERATION_COUNT = PAYLOAD_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.igolf.model.igolf.impl.CourseGPSVectorPayloadImpl <em>Course GPS Vector Payload</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.igolf.model.igolf.impl.CourseGPSVectorPayloadImpl
	 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getCourseGPSVectorPayload()
	 * @generated
	 */
	int COURSE_GPS_VECTOR_PAYLOAD = 30;

	/**
	 * The feature id for the '<em><b>Id course</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_GPS_VECTOR_PAYLOAD__ID_COURSE = PAYLOAD_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Course GPS Vector Payload</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_GPS_VECTOR_PAYLOAD_FEATURE_COUNT = PAYLOAD_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Course GPS Vector Payload</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_GPS_VECTOR_PAYLOAD_OPERATION_COUNT = PAYLOAD_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.igolf.model.igolf.impl.CountryListPayloadImpl <em>Country List Payload</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.igolf.model.igolf.impl.CountryListPayloadImpl
	 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getCountryListPayload()
	 * @generated
	 */
	int COUNTRY_LIST_PAYLOAD = 31;

	/**
	 * The feature id for the '<em><b>Id continent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNTRY_LIST_PAYLOAD__ID_CONTINENT = PAYLOAD_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Country List Payload</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNTRY_LIST_PAYLOAD_FEATURE_COUNT = PAYLOAD_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Country List Payload</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COUNTRY_LIST_PAYLOAD_OPERATION_COUNT = PAYLOAD_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.igolf.model.igolf.impl.StateListPayloadImpl <em>State List Payload</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.igolf.model.igolf.impl.StateListPayloadImpl
	 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getStateListPayload()
	 * @generated
	 */
	int STATE_LIST_PAYLOAD = 32;

	/**
	 * The feature id for the '<em><b>Id country</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE_LIST_PAYLOAD__ID_COUNTRY = PAYLOAD_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>State List Payload</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE_LIST_PAYLOAD_FEATURE_COUNT = PAYLOAD_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>State List Payload</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE_LIST_PAYLOAD_OPERATION_COUNT = PAYLOAD_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.igolf.model.igolf.impl.ScorecardDetailsPayloadImpl <em>Scorecard Details Payload</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.igolf.model.igolf.impl.ScorecardDetailsPayloadImpl
	 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getScorecardDetailsPayload()
	 * @generated
	 */
	int SCORECARD_DETAILS_PAYLOAD = 33;

	/**
	 * The feature id for the '<em><b>Id course</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORECARD_DETAILS_PAYLOAD__ID_COURSE = PAYLOAD_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Scorecard Details Payload</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORECARD_DETAILS_PAYLOAD_FEATURE_COUNT = PAYLOAD_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Scorecard Details Payload</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORECARD_DETAILS_PAYLOAD_OPERATION_COUNT = PAYLOAD_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.igolf.model.igolf.impl.ScorecardListPayloadImpl <em>Scorecard List Payload</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.igolf.model.igolf.impl.ScorecardListPayloadImpl
	 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getScorecardListPayload()
	 * @generated
	 */
	int SCORECARD_LIST_PAYLOAD = 34;

	/**
	 * The feature id for the '<em><b>Course Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORECARD_LIST_PAYLOAD__COURSE_NAME = PAYLOAD_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Id course Array</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORECARD_LIST_PAYLOAD__ID_COURSE_ARRAY = PAYLOAD_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Scorecard List Payload</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORECARD_LIST_PAYLOAD_FEATURE_COUNT = PAYLOAD_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Scorecard List Payload</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORECARD_LIST_PAYLOAD_OPERATION_COUNT = PAYLOAD_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.igolf.model.igolf.impl.CourseTeeDetailsPayloadImpl <em>Course Tee Details Payload</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.igolf.model.igolf.impl.CourseTeeDetailsPayloadImpl
	 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getCourseTeeDetailsPayload()
	 * @generated
	 */
	int COURSE_TEE_DETAILS_PAYLOAD = 35;

	/**
	 * The feature id for the '<em><b>Id course</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_TEE_DETAILS_PAYLOAD__ID_COURSE = PAYLOAD_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Detail Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_TEE_DETAILS_PAYLOAD__DETAIL_LEVEL = PAYLOAD_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Course Tee Details Payload</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_TEE_DETAILS_PAYLOAD_FEATURE_COUNT = PAYLOAD_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Course Tee Details Payload</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_TEE_DETAILS_PAYLOAD_OPERATION_COUNT = PAYLOAD_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.igolf.model.igolf.impl.ScorecardImpl <em>Scorecard</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.igolf.model.igolf.impl.ScorecardImpl
	 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getScorecard()
	 * @generated
	 */
	int SCORECARD = 36;

	/**
	 * The feature id for the '<em><b>Hcp Hole</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORECARD__HCP_HOLE = 0;

	/**
	 * The feature id for the '<em><b>Par Hole</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORECARD__PAR_HOLE = 1;

	/**
	 * The feature id for the '<em><b>Par In</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORECARD__PAR_IN = 2;

	/**
	 * The feature id for the '<em><b>Par Out</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORECARD__PAR_OUT = 3;

	/**
	 * The feature id for the '<em><b>Par Total</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORECARD__PAR_TOTAL = 4;

	/**
	 * The number of structural features of the '<em>Scorecard</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORECARD_FEATURE_COUNT = 5;

	/**
	 * The number of operations of the '<em>Scorecard</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORECARD_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.igolf.model.igolf.impl.ScorecardDetailsResponseImpl <em>Scorecard Details Response</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.igolf.model.igolf.impl.ScorecardDetailsResponseImpl
	 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getScorecardDetailsResponse()
	 * @generated
	 */
	int SCORECARD_DETAILS_RESPONSE = 37;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORECARD_DETAILS_RESPONSE__STATUS = RESPONSE__STATUS;

	/**
	 * The feature id for the '<em><b>Error Message</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORECARD_DETAILS_RESPONSE__ERROR_MESSAGE = RESPONSE__ERROR_MESSAGE;

	/**
	 * The feature id for the '<em><b>Men Scorecard List</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORECARD_DETAILS_RESPONSE__MEN_SCORECARD_LIST = RESPONSE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Wmn Scorecard List</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORECARD_DETAILS_RESPONSE__WMN_SCORECARD_LIST = RESPONSE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Scorecard Details Response</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORECARD_DETAILS_RESPONSE_FEATURE_COUNT = RESPONSE_FEATURE_COUNT + 2;

	/**
	 * The number of operations of the '<em>Scorecard Details Response</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORECARD_DETAILS_RESPONSE_OPERATION_COUNT = RESPONSE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.igolf.model.igolf.impl.ScorecardListResponseImpl <em>Scorecard List Response</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.igolf.model.igolf.impl.ScorecardListResponseImpl
	 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getScorecardListResponse()
	 * @generated
	 */
	int SCORECARD_LIST_RESPONSE = 38;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORECARD_LIST_RESPONSE__STATUS = RESPONSE__STATUS;

	/**
	 * The feature id for the '<em><b>Error Message</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORECARD_LIST_RESPONSE__ERROR_MESSAGE = RESPONSE__ERROR_MESSAGE;

	/**
	 * The feature id for the '<em><b>Course List</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORECARD_LIST_RESPONSE__COURSE_LIST = RESPONSE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Scorecard List Response</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORECARD_LIST_RESPONSE_FEATURE_COUNT = RESPONSE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Scorecard List Response</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCORECARD_LIST_RESPONSE_OPERATION_COUNT = RESPONSE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.igolf.model.igolf.impl.CourseScorecardListImpl <em>Course Scorecard List</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.igolf.model.igolf.impl.CourseScorecardListImpl
	 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getCourseScorecardList()
	 * @generated
	 */
	int COURSE_SCORECARD_LIST = 39;

	/**
	 * The feature id for the '<em><b>Id course</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_SCORECARD_LIST__ID_COURSE = 0;

	/**
	 * The feature id for the '<em><b>Course Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_SCORECARD_LIST__COURSE_NAME = 1;

	/**
	 * The feature id for the '<em><b>Men Scorecard List</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_SCORECARD_LIST__MEN_SCORECARD_LIST = 2;

	/**
	 * The feature id for the '<em><b>Wmn Scorecard List</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_SCORECARD_LIST__WMN_SCORECARD_LIST = 3;

	/**
	 * The number of structural features of the '<em>Course Scorecard List</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_SCORECARD_LIST_FEATURE_COUNT = 4;

	/**
	 * The number of operations of the '<em>Course Scorecard List</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_SCORECARD_LIST_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.igolf.model.igolf.impl.CourseTeeDetailsResponseImpl <em>Course Tee Details Response</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.igolf.model.igolf.impl.CourseTeeDetailsResponseImpl
	 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getCourseTeeDetailsResponse()
	 * @generated
	 */
	int COURSE_TEE_DETAILS_RESPONSE = 40;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_TEE_DETAILS_RESPONSE__STATUS = RESPONSE__STATUS;

	/**
	 * The feature id for the '<em><b>Error Message</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_TEE_DETAILS_RESPONSE__ERROR_MESSAGE = RESPONSE__ERROR_MESSAGE;

	/**
	 * The feature id for the '<em><b>Tees List</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_TEE_DETAILS_RESPONSE__TEES_LIST = RESPONSE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Course Tee Details Response</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_TEE_DETAILS_RESPONSE_FEATURE_COUNT = RESPONSE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Course Tee Details Response</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COURSE_TEE_DETAILS_RESPONSE_OPERATION_COUNT = RESPONSE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link com.playertour.backend.igolf.model.igolf.impl.TeeDetailsImpl <em>Tee Details</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see com.playertour.backend.igolf.model.igolf.impl.TeeDetailsImpl
	 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getTeeDetails()
	 * @generated
	 */
	int TEE_DETAILS = 41;

	/**
	 * The feature id for the '<em><b>Gender</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEE_DETAILS__GENDER = 0;

	/**
	 * The feature id for the '<em><b>Rating Men</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEE_DETAILS__RATING_MEN = 1;

	/**
	 * The feature id for the '<em><b>Rating Women</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEE_DETAILS__RATING_WOMEN = 2;

	/**
	 * The feature id for the '<em><b>Slope Men</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEE_DETAILS__SLOPE_MEN = 3;

	/**
	 * The feature id for the '<em><b>Slope Women</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEE_DETAILS__SLOPE_WOMEN = 4;

	/**
	 * The feature id for the '<em><b>Tee Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEE_DETAILS__TEE_NAME = 5;

	/**
	 * The feature id for the '<em><b>Tee Color Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEE_DETAILS__TEE_COLOR_NAME = 6;

	/**
	 * The feature id for the '<em><b>Tee Color Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEE_DETAILS__TEE_COLOR_VALUE = 7;

	/**
	 * The feature id for the '<em><b>Yds Total</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEE_DETAILS__YDS_TOTAL = 8;

	/**
	 * The feature id for the '<em><b>Yds1to9</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEE_DETAILS__YDS1TO9 = 9;

	/**
	 * The feature id for the '<em><b>Yds10to18</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEE_DETAILS__YDS10TO18 = 10;

	/**
	 * The feature id for the '<em><b>Yds1to18</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEE_DETAILS__YDS1TO18 = 11;

	/**
	 * The feature id for the '<em><b>Yds Hole</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEE_DETAILS__YDS_HOLE = 12;

	/**
	 * The number of structural features of the '<em>Tee Details</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEE_DETAILS_FEATURE_COUNT = 13;

	/**
	 * The number of operations of the '<em>Tee Details</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TEE_DETAILS_OPERATION_COUNT = 0;


	/**
	 * Returns the meta object for class '{@link com.playertour.backend.igolf.model.igolf.Response <em>Response</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Response</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.Response
	 * @generated
	 */
	EClass getResponse();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.Response#getStatus <em>Status</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Status</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.Response#getStatus()
	 * @see #getResponse()
	 * @generated
	 */
	EAttribute getResponse_Status();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.Response#getErrorMessage <em>Error Message</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Error Message</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.Response#getErrorMessage()
	 * @see #getResponse()
	 * @generated
	 */
	EAttribute getResponse_ErrorMessage();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.igolf.model.igolf.CourseListResponse <em>Course List Response</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Course List Response</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseListResponse
	 * @generated
	 */
	EClass getCourseListResponse();

	/**
	 * Returns the meta object for the containment reference list '{@link com.playertour.backend.igolf.model.igolf.CourseListResponse#getCourseList <em>Course List</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Course List</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseListResponse#getCourseList()
	 * @see #getCourseListResponse()
	 * @generated
	 */
	EReference getCourseListResponse_CourseList();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseListResponse#getPage <em>Page</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Page</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseListResponse#getPage()
	 * @see #getCourseListResponse()
	 * @generated
	 */
	EAttribute getCourseListResponse_Page();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseListResponse#getTotalpages <em>Totalpages</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Totalpages</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseListResponse#getTotalpages()
	 * @see #getCourseListResponse()
	 * @generated
	 */
	EAttribute getCourseListResponse_Totalpages();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseListResponse#getTotalCourses <em>Total Courses</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Total Courses</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseListResponse#getTotalCourses()
	 * @see #getCourseListResponse()
	 * @generated
	 */
	EAttribute getCourseListResponse_TotalCourses();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.igolf.model.igolf.CourseInfo <em>Course Info</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Course Info</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseInfo
	 * @generated
	 */
	EClass getCourseInfo();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseInfo#getActive <em>Active</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Active</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseInfo#getActive()
	 * @see #getCourseInfo()
	 * @generated
	 */
	EAttribute getCourseInfo_Active();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseInfo#getId_course <em>Id course</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id course</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseInfo#getId_course()
	 * @see #getCourseInfo()
	 * @generated
	 */
	EAttribute getCourseInfo_Id_course();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseInfo#getCourseName <em>Course Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Course Name</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseInfo#getCourseName()
	 * @see #getCourseInfo()
	 * @generated
	 */
	EAttribute getCourseInfo_CourseName();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseInfo#getEmail <em>Email</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Email</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseInfo#getEmail()
	 * @see #getCourseInfo()
	 * @generated
	 */
	EAttribute getCourseInfo_Email();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseInfo#getAddress1 <em>Address1</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Address1</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseInfo#getAddress1()
	 * @see #getCourseInfo()
	 * @generated
	 */
	EAttribute getCourseInfo_Address1();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseInfo#getAddress2 <em>Address2</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Address2</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseInfo#getAddress2()
	 * @see #getCourseInfo()
	 * @generated
	 */
	EAttribute getCourseInfo_Address2();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseInfo#getCity <em>City</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>City</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseInfo#getCity()
	 * @see #getCourseInfo()
	 * @generated
	 */
	EAttribute getCourseInfo_City();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseInfo#getId_country <em>Id country</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id country</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseInfo#getId_country()
	 * @see #getCourseInfo()
	 * @generated
	 */
	EAttribute getCourseInfo_Id_country();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseInfo#getCountryFull <em>Country Full</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Country Full</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseInfo#getCountryFull()
	 * @see #getCourseInfo()
	 * @generated
	 */
	EAttribute getCourseInfo_CountryFull();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseInfo#getCountryShort <em>Country Short</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Country Short</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseInfo#getCountryShort()
	 * @see #getCourseInfo()
	 * @generated
	 */
	EAttribute getCourseInfo_CountryShort();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseInfo#getDistance <em>Distance</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Distance</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseInfo#getDistance()
	 * @see #getCourseInfo()
	 * @generated
	 */
	EAttribute getCourseInfo_Distance();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseInfo#getLatitude <em>Latitude</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Latitude</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseInfo#getLatitude()
	 * @see #getCourseInfo()
	 * @generated
	 */
	EAttribute getCourseInfo_Latitude();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseInfo#getLongitude <em>Longitude</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Longitude</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseInfo#getLongitude()
	 * @see #getCourseInfo()
	 * @generated
	 */
	EAttribute getCourseInfo_Longitude();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseInfo#getScorecardAvailable <em>Scorecard Available</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Scorecard Available</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseInfo#getScorecardAvailable()
	 * @see #getCourseInfo()
	 * @generated
	 */
	EAttribute getCourseInfo_ScorecardAvailable();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseInfo#getGpsAvailable <em>Gps Available</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Gps Available</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseInfo#getGpsAvailable()
	 * @see #getCourseInfo()
	 * @generated
	 */
	EAttribute getCourseInfo_GpsAvailable();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseInfo#getVectorAvailable <em>Vector Available</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Vector Available</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseInfo#getVectorAvailable()
	 * @see #getCourseInfo()
	 * @generated
	 */
	EAttribute getCourseInfo_VectorAvailable();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseInfo#getRecommendedRating <em>Recommended Rating</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Recommended Rating</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseInfo#getRecommendedRating()
	 * @see #getCourseInfo()
	 * @generated
	 */
	EAttribute getCourseInfo_RecommendedRating();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseInfo#getConditionRating <em>Condition Rating</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Condition Rating</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseInfo#getConditionRating()
	 * @see #getCourseInfo()
	 * @generated
	 */
	EAttribute getCourseInfo_ConditionRating();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseInfo#getId_state <em>Id state</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id state</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseInfo#getId_state()
	 * @see #getCourseInfo()
	 * @generated
	 */
	EAttribute getCourseInfo_Id_state();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseInfo#getStateFull <em>State Full</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>State Full</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseInfo#getStateFull()
	 * @see #getCourseInfo()
	 * @generated
	 */
	EAttribute getCourseInfo_StateFull();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseInfo#getStateShort <em>State Short</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>State Short</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseInfo#getStateShort()
	 * @see #getCourseInfo()
	 * @generated
	 */
	EAttribute getCourseInfo_StateShort();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseInfo#getZipCode <em>Zip Code</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Zip Code</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseInfo#getZipCode()
	 * @see #getCourseInfo()
	 * @generated
	 */
	EAttribute getCourseInfo_ZipCode();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.igolf.model.igolf.CourseDetailsResponse <em>Course Details Response</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Course Details Response</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseDetailsResponse
	 * @generated
	 */
	EClass getCourseDetailsResponse();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getActive <em>Active</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Active</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getActive()
	 * @see #getCourseDetailsResponse()
	 * @generated
	 */
	EAttribute getCourseDetailsResponse_Active();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getCourseName <em>Course Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Course Name</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getCourseName()
	 * @see #getCourseDetailsResponse()
	 * @generated
	 */
	EAttribute getCourseDetailsResponse_CourseName();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getEmail <em>Email</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Email</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getEmail()
	 * @see #getCourseDetailsResponse()
	 * @generated
	 */
	EAttribute getCourseDetailsResponse_Email();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getAddress1 <em>Address1</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Address1</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getAddress1()
	 * @see #getCourseDetailsResponse()
	 * @generated
	 */
	EAttribute getCourseDetailsResponse_Address1();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getAddress2 <em>Address2</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Address2</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getAddress2()
	 * @see #getCourseDetailsResponse()
	 * @generated
	 */
	EAttribute getCourseDetailsResponse_Address2();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getCity <em>City</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>City</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getCity()
	 * @see #getCourseDetailsResponse()
	 * @generated
	 */
	EAttribute getCourseDetailsResponse_City();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getId_country <em>Id country</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id country</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getId_country()
	 * @see #getCourseDetailsResponse()
	 * @generated
	 */
	EAttribute getCourseDetailsResponse_Id_country();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getCountryFull <em>Country Full</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Country Full</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getCountryFull()
	 * @see #getCourseDetailsResponse()
	 * @generated
	 */
	EAttribute getCourseDetailsResponse_CountryFull();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getCountryShort <em>Country Short</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Country Short</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getCountryShort()
	 * @see #getCourseDetailsResponse()
	 * @generated
	 */
	EAttribute getCourseDetailsResponse_CountryShort();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getScorecardAvailable <em>Scorecard Available</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Scorecard Available</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getScorecardAvailable()
	 * @see #getCourseDetailsResponse()
	 * @generated
	 */
	EAttribute getCourseDetailsResponse_ScorecardAvailable();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getGpsAvailable <em>Gps Available</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Gps Available</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getGpsAvailable()
	 * @see #getCourseDetailsResponse()
	 * @generated
	 */
	EAttribute getCourseDetailsResponse_GpsAvailable();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getId_state <em>Id state</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id state</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getId_state()
	 * @see #getCourseDetailsResponse()
	 * @generated
	 */
	EAttribute getCourseDetailsResponse_Id_state();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getStateFull <em>State Full</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>State Full</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getStateFull()
	 * @see #getCourseDetailsResponse()
	 * @generated
	 */
	EAttribute getCourseDetailsResponse_StateFull();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getStateShort <em>State Short</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>State Short</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getStateShort()
	 * @see #getCourseDetailsResponse()
	 * @generated
	 */
	EAttribute getCourseDetailsResponse_StateShort();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getZipCode <em>Zip Code</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Zip Code</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getZipCode()
	 * @see #getCourseDetailsResponse()
	 * @generated
	 */
	EAttribute getCourseDetailsResponse_ZipCode();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getClass_ <em>Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Class</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getClass_()
	 * @see #getCourseDetailsResponse()
	 * @generated
	 */
	EAttribute getCourseDetailsResponse_Class();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getImage <em>Image</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Image</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getImage()
	 * @see #getCourseDetailsResponse()
	 * @generated
	 */
	EAttribute getCourseDetailsResponse_Image();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getLayoutName <em>Layout Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Layout Name</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getLayoutName()
	 * @see #getCourseDetailsResponse()
	 * @generated
	 */
	EAttribute getCourseDetailsResponse_LayoutName();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getPhone <em>Phone</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Phone</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getPhone()
	 * @see #getCourseDetailsResponse()
	 * @generated
	 */
	EAttribute getCourseDetailsResponse_Phone();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getUrl <em>Url</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Url</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getUrl()
	 * @see #getCourseDetailsResponse()
	 * @generated
	 */
	EAttribute getCourseDetailsResponse_Url();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getFax <em>Fax</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Fax</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getFax()
	 * @see #getCourseDetailsResponse()
	 * @generated
	 */
	EAttribute getCourseDetailsResponse_Fax();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getDayClosed <em>Day Closed</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Day Closed</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getDayClosed()
	 * @see #getCourseDetailsResponse()
	 * @generated
	 */
	EAttribute getCourseDetailsResponse_DayClosed();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getDressCode <em>Dress Code</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Dress Code</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getDressCode()
	 * @see #getCourseDetailsResponse()
	 * @generated
	 */
	EAttribute getCourseDetailsResponse_DressCode();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getLayoutHoles <em>Layout Holes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Layout Holes</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getLayoutHoles()
	 * @see #getCourseDetailsResponse()
	 * @generated
	 */
	EAttribute getCourseDetailsResponse_LayoutHoles();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getLayoutTotalHoles <em>Layout Total Holes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Layout Total Holes</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getLayoutTotalHoles()
	 * @see #getCourseDetailsResponse()
	 * @generated
	 */
	EAttribute getCourseDetailsResponse_LayoutTotalHoles();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getSeasonal <em>Seasonal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Seasonal</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getSeasonal()
	 * @see #getCourseDetailsResponse()
	 * @generated
	 */
	EAttribute getCourseDetailsResponse_Seasonal();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getPricing <em>Pricing</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Pricing</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getPricing()
	 * @see #getCourseDetailsResponse()
	 * @generated
	 */
	EReference getCourseDetailsResponse_Pricing();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getLatitude <em>Latitude</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Latitude</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getLatitude()
	 * @see #getCourseDetailsResponse()
	 * @generated
	 */
	EAttribute getCourseDetailsResponse_Latitude();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getLongitude <em>Longitude</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Longitude</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseDetailsResponse#getLongitude()
	 * @see #getCourseDetailsResponse()
	 * @generated
	 */
	EAttribute getCourseDetailsResponse_Longitude();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.igolf.model.igolf.Price <em>Price</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Price</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.Price
	 * @generated
	 */
	EClass getPrice();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.Price#getWeekend9 <em>Weekend9</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Weekend9</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.Price#getWeekend9()
	 * @see #getPrice()
	 * @generated
	 */
	EAttribute getPrice_Weekend9();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.Price#getWeekend18 <em>Weekend18</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Weekend18</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.Price#getWeekend18()
	 * @see #getPrice()
	 * @generated
	 */
	EAttribute getPrice_Weekend18();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.Price#getWeekday9 <em>Weekday9</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Weekday9</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.Price#getWeekday9()
	 * @see #getPrice()
	 * @generated
	 */
	EAttribute getPrice_Weekday9();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.Price#getWeekday18 <em>Weekday18</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Weekday18</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.Price#getWeekday18()
	 * @see #getPrice()
	 * @generated
	 */
	EAttribute getPrice_Weekday18();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.Price#getTwilight <em>Twilight</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Twilight</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.Price#getTwilight()
	 * @see #getPrice()
	 * @generated
	 */
	EAttribute getPrice_Twilight();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.igolf.model.igolf.CountryListResponse <em>Country List Response</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Country List Response</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CountryListResponse
	 * @generated
	 */
	EClass getCountryListResponse();

	/**
	 * Returns the meta object for the containment reference list '{@link com.playertour.backend.igolf.model.igolf.CountryListResponse#getCountryList <em>Country List</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Country List</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CountryListResponse#getCountryList()
	 * @see #getCountryListResponse()
	 * @generated
	 */
	EReference getCountryListResponse_CountryList();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.igolf.model.igolf.CountryInfo <em>Country Info</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Country Info</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CountryInfo
	 * @generated
	 */
	EClass getCountryInfo();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CountryInfo#getCountryFull <em>Country Full</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Country Full</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CountryInfo#getCountryFull()
	 * @see #getCountryInfo()
	 * @generated
	 */
	EAttribute getCountryInfo_CountryFull();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CountryInfo#getCountryShort <em>Country Short</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Country Short</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CountryInfo#getCountryShort()
	 * @see #getCountryInfo()
	 * @generated
	 */
	EAttribute getCountryInfo_CountryShort();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CountryInfo#getId_country <em>Id country</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id country</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CountryInfo#getId_country()
	 * @see #getCountryInfo()
	 * @generated
	 */
	EAttribute getCountryInfo_Id_country();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CountryInfo#getId_continent <em>Id continent</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id continent</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CountryInfo#getId_continent()
	 * @see #getCountryInfo()
	 * @generated
	 */
	EAttribute getCountryInfo_Id_continent();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.igolf.model.igolf.StateListResponse <em>State List Response</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>State List Response</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.StateListResponse
	 * @generated
	 */
	EClass getStateListResponse();

	/**
	 * Returns the meta object for the containment reference list '{@link com.playertour.backend.igolf.model.igolf.StateListResponse#getStateList <em>State List</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>State List</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.StateListResponse#getStateList()
	 * @see #getStateListResponse()
	 * @generated
	 */
	EReference getStateListResponse_StateList();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.igolf.model.igolf.StateInfo <em>State Info</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>State Info</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.StateInfo
	 * @generated
	 */
	EClass getStateInfo();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.StateInfo#getId_country <em>Id country</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id country</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.StateInfo#getId_country()
	 * @see #getStateInfo()
	 * @generated
	 */
	EAttribute getStateInfo_Id_country();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.StateInfo#getId_state <em>Id state</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id state</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.StateInfo#getId_state()
	 * @see #getStateInfo()
	 * @generated
	 */
	EAttribute getStateInfo_Id_state();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.StateInfo#getStateFull <em>State Full</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>State Full</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.StateInfo#getStateFull()
	 * @see #getStateInfo()
	 * @generated
	 */
	EAttribute getStateInfo_StateFull();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.StateInfo#getStateShort <em>State Short</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>State Short</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.StateInfo#getStateShort()
	 * @see #getStateInfo()
	 * @generated
	 */
	EAttribute getStateInfo_StateShort();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.igolf.model.igolf.CourseGPSVectorResponse <em>Course GPS Vector Response</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Course GPS Vector Response</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseGPSVectorResponse
	 * @generated
	 */
	EClass getCourseGPSVectorResponse();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.igolf.model.igolf.CourseGPSVectorResponse#getVectorGPSObject <em>Vector GPS Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Vector GPS Object</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseGPSVectorResponse#getVectorGPSObject()
	 * @see #getCourseGPSVectorResponse()
	 * @generated
	 */
	EReference getCourseGPSVectorResponse_VectorGPSObject();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.igolf.model.igolf.ShapeObject <em>Shape Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Shape Object</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.ShapeObject
	 * @generated
	 */
	EClass getShapeObject();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.ShapeObject#getShapeCount <em>Shape Count</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Shape Count</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.ShapeObject#getShapeCount()
	 * @see #getShapeObject()
	 * @generated
	 */
	EAttribute getShapeObject_ShapeCount();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.igolf.model.igolf.ShapeObject#getShapes <em>Shapes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Shapes</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.ShapeObject#getShapes()
	 * @see #getShapeObject()
	 * @generated
	 */
	EReference getShapeObject_Shapes();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.igolf.model.igolf.Shapes <em>Shapes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Shapes</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.Shapes
	 * @generated
	 */
	EClass getShapes();

	/**
	 * Returns the meta object for the containment reference list '{@link com.playertour.backend.igolf.model.igolf.Shapes#getShape <em>Shape</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Shape</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.Shapes#getShape()
	 * @see #getShapes()
	 * @generated
	 */
	EReference getShapes_Shape();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.igolf.model.igolf.Shape <em>Shape</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Shape</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.Shape
	 * @generated
	 */
	EClass getShape();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.igolf.model.igolf.Shape#getAttributes <em>Attributes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Attributes</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.Shape#getAttributes()
	 * @see #getShape()
	 * @generated
	 */
	EReference getShape_Attributes();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.Shape#getPoints <em>Points</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Points</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.Shape#getPoints()
	 * @see #getShape()
	 * @generated
	 */
	EAttribute getShape_Points();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.igolf.model.igolf.Attributes <em>Attributes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Attributes</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.Attributes
	 * @generated
	 */
	EClass getAttributes();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.Attributes#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Description</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.Attributes#getDescription()
	 * @see #getAttributes()
	 * @generated
	 */
	EAttribute getAttributes_Description();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.Attributes#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.Attributes#getType()
	 * @see #getAttributes()
	 * @generated
	 */
	EAttribute getAttributes_Type();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.Attributes#getSize <em>Size</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Size</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.Attributes#getSize()
	 * @see #getAttributes()
	 * @generated
	 */
	EAttribute getAttributes_Size();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.igolf.model.igolf.VectorGPSObject <em>Vector GPS Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Vector GPS Object</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.VectorGPSObject
	 * @generated
	 */
	EClass getVectorGPSObject();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.VectorGPSObject#getHoleCount <em>Hole Count</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Hole Count</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.VectorGPSObject#getHoleCount()
	 * @see #getVectorGPSObject()
	 * @generated
	 */
	EAttribute getVectorGPSObject_HoleCount();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.igolf.model.igolf.VectorGPSObject#getOcean <em>Ocean</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Ocean</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.VectorGPSObject#getOcean()
	 * @see #getVectorGPSObject()
	 * @generated
	 */
	EReference getVectorGPSObject_Ocean();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.igolf.model.igolf.VectorGPSObject#getBackground <em>Background</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Background</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.VectorGPSObject#getBackground()
	 * @see #getVectorGPSObject()
	 * @generated
	 */
	EReference getVectorGPSObject_Background();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.igolf.model.igolf.VectorGPSObject#getBridge <em>Bridge</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Bridge</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.VectorGPSObject#getBridge()
	 * @see #getVectorGPSObject()
	 * @generated
	 */
	EReference getVectorGPSObject_Bridge();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.igolf.model.igolf.VectorGPSObject#getVegetation <em>Vegetation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Vegetation</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.VectorGPSObject#getVegetation()
	 * @see #getVectorGPSObject()
	 * @generated
	 */
	EReference getVectorGPSObject_Vegetation();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.igolf.model.igolf.VectorGPSObject#getLava <em>Lava</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Lava</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.VectorGPSObject#getLava()
	 * @see #getVectorGPSObject()
	 * @generated
	 */
	EReference getVectorGPSObject_Lava();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.igolf.model.igolf.VectorGPSObject#getPath <em>Path</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Path</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.VectorGPSObject#getPath()
	 * @see #getVectorGPSObject()
	 * @generated
	 */
	EReference getVectorGPSObject_Path();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.igolf.model.igolf.VectorGPSObject#getTree <em>Tree</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Tree</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.VectorGPSObject#getTree()
	 * @see #getVectorGPSObject()
	 * @generated
	 */
	EReference getVectorGPSObject_Tree();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.igolf.model.igolf.VectorGPSObject#getLake <em>Lake</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Lake</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.VectorGPSObject#getLake()
	 * @see #getVectorGPSObject()
	 * @generated
	 */
	EReference getVectorGPSObject_Lake();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.igolf.model.igolf.VectorGPSObject#getWater <em>Water</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Water</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.VectorGPSObject#getWater()
	 * @see #getVectorGPSObject()
	 * @generated
	 */
	EReference getVectorGPSObject_Water();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.igolf.model.igolf.VectorGPSObject#getClubhouse <em>Clubhouse</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Clubhouse</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.VectorGPSObject#getClubhouse()
	 * @see #getVectorGPSObject()
	 * @generated
	 */
	EReference getVectorGPSObject_Clubhouse();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.igolf.model.igolf.VectorGPSObject#getPond <em>Pond</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Pond</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.VectorGPSObject#getPond()
	 * @see #getVectorGPSObject()
	 * @generated
	 */
	EReference getVectorGPSObject_Pond();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.igolf.model.igolf.VectorGPSObject#getCreek <em>Creek</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Creek</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.VectorGPSObject#getCreek()
	 * @see #getVectorGPSObject()
	 * @generated
	 */
	EReference getVectorGPSObject_Creek();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.igolf.model.igolf.VectorGPSObject#getSand <em>Sand</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Sand</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.VectorGPSObject#getSand()
	 * @see #getVectorGPSObject()
	 * @generated
	 */
	EReference getVectorGPSObject_Sand();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.igolf.model.igolf.VectorGPSObject#getRock <em>Rock</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Rock</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.VectorGPSObject#getRock()
	 * @see #getVectorGPSObject()
	 * @generated
	 */
	EReference getVectorGPSObject_Rock();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.igolf.model.igolf.VectorGPSObject#getHoles <em>Holes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Holes</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.VectorGPSObject#getHoles()
	 * @see #getVectorGPSObject()
	 * @generated
	 */
	EReference getVectorGPSObject_Holes();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.igolf.model.igolf.Holes <em>Holes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Holes</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.Holes
	 * @generated
	 */
	EClass getHoles();

	/**
	 * Returns the meta object for the containment reference list '{@link com.playertour.backend.igolf.model.igolf.Holes#getHole <em>Hole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Hole</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.Holes#getHole()
	 * @see #getHoles()
	 * @generated
	 */
	EReference getHoles_Hole();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.igolf.model.igolf.Hole <em>Hole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Hole</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.Hole
	 * @generated
	 */
	EClass getHole();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.Hole#getHoleNumber <em>Hole Number</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Hole Number</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.Hole#getHoleNumber()
	 * @see #getHole()
	 * @generated
	 */
	EAttribute getHole_HoleNumber();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.igolf.model.igolf.Hole#getGreencenter <em>Greencenter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Greencenter</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.Hole#getGreencenter()
	 * @see #getHole()
	 * @generated
	 */
	EReference getHole_Greencenter();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.igolf.model.igolf.Hole#getBunker <em>Bunker</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Bunker</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.Hole#getBunker()
	 * @see #getHole()
	 * @generated
	 */
	EReference getHole_Bunker();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.igolf.model.igolf.Hole#getCentralpath <em>Centralpath</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Centralpath</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.Hole#getCentralpath()
	 * @see #getHole()
	 * @generated
	 */
	EReference getHole_Centralpath();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.igolf.model.igolf.Hole#getTeeboxcenter <em>Teeboxcenter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Teeboxcenter</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.Hole#getTeeboxcenter()
	 * @see #getHole()
	 * @generated
	 */
	EReference getHole_Teeboxcenter();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.igolf.model.igolf.Hole#getPerimeter <em>Perimeter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Perimeter</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.Hole#getPerimeter()
	 * @see #getHole()
	 * @generated
	 */
	EReference getHole_Perimeter();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.igolf.model.igolf.Hole#getGreen <em>Green</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Green</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.Hole#getGreen()
	 * @see #getHole()
	 * @generated
	 */
	EReference getHole_Green();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.igolf.model.igolf.Hole#getFairway <em>Fairway</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Fairway</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.Hole#getFairway()
	 * @see #getHole()
	 * @generated
	 */
	EReference getHole_Fairway();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.igolf.model.igolf.Hole#getTeebox <em>Teebox</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Teebox</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.Hole#getTeebox()
	 * @see #getHole()
	 * @generated
	 */
	EReference getHole_Teebox();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.igolf.model.igolf.CourseCompleteResponse <em>Course Complete Response</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Course Complete Response</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseCompleteResponse
	 * @generated
	 */
	EClass getCourseCompleteResponse();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.igolf.model.igolf.CourseCompleteResponse#getCourseDetails <em>Course Details</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Course Details</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseCompleteResponse#getCourseDetails()
	 * @see #getCourseCompleteResponse()
	 * @generated
	 */
	EReference getCourseCompleteResponse_CourseDetails();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.igolf.model.igolf.CourseCompleteResponse#getCourseGPSVector <em>Course GPS Vector</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Course GPS Vector</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseCompleteResponse#getCourseGPSVector()
	 * @see #getCourseCompleteResponse()
	 * @generated
	 */
	EReference getCourseCompleteResponse_CourseGPSVector();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.igolf.model.igolf.CourseCompleteResponse#getCourseInfo <em>Course Info</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Course Info</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseCompleteResponse#getCourseInfo()
	 * @see #getCourseCompleteResponse()
	 * @generated
	 */
	EReference getCourseCompleteResponse_CourseInfo();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.igolf.model.igolf.CourseCompleteResponse#getScorecardDetails <em>Scorecard Details</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Scorecard Details</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseCompleteResponse#getScorecardDetails()
	 * @see #getCourseCompleteResponse()
	 * @generated
	 */
	EReference getCourseCompleteResponse_ScorecardDetails();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.igolf.model.igolf.CourseCompleteResponse#getTeeDetails <em>Tee Details</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Tee Details</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseCompleteResponse#getTeeDetails()
	 * @see #getCourseCompleteResponse()
	 * @generated
	 */
	EReference getCourseCompleteResponse_TeeDetails();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.igolf.model.igolf.Payload <em>Payload</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Payload</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.Payload
	 * @generated
	 */
	EClass getPayload();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.igolf.model.igolf.Request <em>Request</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Request</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.Request
	 * @generated
	 */
	EClass getRequest();

	/**
	 * Returns the meta object for the containment reference '{@link com.playertour.backend.igolf.model.igolf.Request#getPayload <em>Payload</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Payload</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.Request#getPayload()
	 * @see #getRequest()
	 * @generated
	 */
	EReference getRequest_Payload();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.igolf.model.igolf.CourseDetailsRequest <em>Course Details Request</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Course Details Request</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseDetailsRequest
	 * @generated
	 */
	EClass getCourseDetailsRequest();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.igolf.model.igolf.CourseListRequest <em>Course List Request</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Course List Request</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseListRequest
	 * @generated
	 */
	EClass getCourseListRequest();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.igolf.model.igolf.CourseGPSVectorRequest <em>Course GPS Vector Request</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Course GPS Vector Request</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseGPSVectorRequest
	 * @generated
	 */
	EClass getCourseGPSVectorRequest();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.igolf.model.igolf.CountryListRequest <em>Country List Request</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Country List Request</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CountryListRequest
	 * @generated
	 */
	EClass getCountryListRequest();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.igolf.model.igolf.StateListRequest <em>State List Request</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>State List Request</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.StateListRequest
	 * @generated
	 */
	EClass getStateListRequest();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.igolf.model.igolf.ScorecardDetailsRequest <em>Scorecard Details Request</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Scorecard Details Request</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.ScorecardDetailsRequest
	 * @generated
	 */
	EClass getScorecardDetailsRequest();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.igolf.model.igolf.ScorecardListRequest <em>Scorecard List Request</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Scorecard List Request</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.ScorecardListRequest
	 * @generated
	 */
	EClass getScorecardListRequest();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.igolf.model.igolf.CourseTeeDetailsRequest <em>Course Tee Details Request</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Course Tee Details Request</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseTeeDetailsRequest
	 * @generated
	 */
	EClass getCourseTeeDetailsRequest();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.igolf.model.igolf.CourseDetailsPayload <em>Course Details Payload</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Course Details Payload</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseDetailsPayload
	 * @generated
	 */
	EClass getCourseDetailsPayload();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseDetailsPayload#getId_course <em>Id course</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id course</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseDetailsPayload#getId_course()
	 * @see #getCourseDetailsPayload()
	 * @generated
	 */
	EAttribute getCourseDetailsPayload_Id_course();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseDetailsPayload#getDetailLevel <em>Detail Level</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Detail Level</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseDetailsPayload#getDetailLevel()
	 * @see #getCourseDetailsPayload()
	 * @generated
	 */
	EAttribute getCourseDetailsPayload_DetailLevel();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseDetailsPayload#getCountryFormat <em>Country Format</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Country Format</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseDetailsPayload#getCountryFormat()
	 * @see #getCourseDetailsPayload()
	 * @generated
	 */
	EAttribute getCourseDetailsPayload_CountryFormat();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseDetailsPayload#getStateFormat <em>State Format</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>State Format</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseDetailsPayload#getStateFormat()
	 * @see #getCourseDetailsPayload()
	 * @generated
	 */
	EAttribute getCourseDetailsPayload_StateFormat();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.igolf.model.igolf.CourseListPayload <em>Course List Payload</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Course List Payload</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseListPayload
	 * @generated
	 */
	EClass getCourseListPayload();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseListPayload#getActive <em>Active</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Active</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseListPayload#getActive()
	 * @see #getCourseListPayload()
	 * @generated
	 */
	EAttribute getCourseListPayload_Active();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseListPayload#getId_country <em>Id country</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id country</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseListPayload#getId_country()
	 * @see #getCourseListPayload()
	 * @generated
	 */
	EAttribute getCourseListPayload_Id_country();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseListPayload#getCountryFormat <em>Country Format</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Country Format</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseListPayload#getCountryFormat()
	 * @see #getCourseListPayload()
	 * @generated
	 */
	EAttribute getCourseListPayload_CountryFormat();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseListPayload#getId_state <em>Id state</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id state</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseListPayload#getId_state()
	 * @see #getCourseListPayload()
	 * @generated
	 */
	EAttribute getCourseListPayload_Id_state();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseListPayload#getStateFormat <em>State Format</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>State Format</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseListPayload#getStateFormat()
	 * @see #getCourseListPayload()
	 * @generated
	 */
	EAttribute getCourseListPayload_StateFormat();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseListPayload#getCity <em>City</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>City</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseListPayload#getCity()
	 * @see #getCourseListPayload()
	 * @generated
	 */
	EAttribute getCourseListPayload_City();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseListPayload#getZipcode <em>Zipcode</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Zipcode</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseListPayload#getZipcode()
	 * @see #getCourseListPayload()
	 * @generated
	 */
	EAttribute getCourseListPayload_Zipcode();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseListPayload#getCourseName <em>Course Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Course Name</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseListPayload#getCourseName()
	 * @see #getCourseListPayload()
	 * @generated
	 */
	EAttribute getCourseListPayload_CourseName();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseListPayload#getRadius <em>Radius</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Radius</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseListPayload#getRadius()
	 * @see #getCourseListPayload()
	 * @generated
	 */
	EAttribute getCourseListPayload_Radius();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseListPayload#getReferenceLatitude <em>Reference Latitude</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Reference Latitude</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseListPayload#getReferenceLatitude()
	 * @see #getCourseListPayload()
	 * @generated
	 */
	EAttribute getCourseListPayload_ReferenceLatitude();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseListPayload#getReferenceLongitude <em>Reference Longitude</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Reference Longitude</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseListPayload#getReferenceLongitude()
	 * @see #getCourseListPayload()
	 * @generated
	 */
	EAttribute getCourseListPayload_ReferenceLongitude();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseListPayload#getPage <em>Page</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Page</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseListPayload#getPage()
	 * @see #getCourseListPayload()
	 * @generated
	 */
	EAttribute getCourseListPayload_Page();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseListPayload#getResultsPerPage <em>Results Per Page</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Results Per Page</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseListPayload#getResultsPerPage()
	 * @see #getCourseListPayload()
	 * @generated
	 */
	EAttribute getCourseListPayload_ResultsPerPage();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.igolf.model.igolf.CourseGPSVectorPayload <em>Course GPS Vector Payload</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Course GPS Vector Payload</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseGPSVectorPayload
	 * @generated
	 */
	EClass getCourseGPSVectorPayload();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseGPSVectorPayload#getId_course <em>Id course</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id course</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseGPSVectorPayload#getId_course()
	 * @see #getCourseGPSVectorPayload()
	 * @generated
	 */
	EAttribute getCourseGPSVectorPayload_Id_course();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.igolf.model.igolf.CountryListPayload <em>Country List Payload</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Country List Payload</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CountryListPayload
	 * @generated
	 */
	EClass getCountryListPayload();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CountryListPayload#getId_continent <em>Id continent</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id continent</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CountryListPayload#getId_continent()
	 * @see #getCountryListPayload()
	 * @generated
	 */
	EAttribute getCountryListPayload_Id_continent();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.igolf.model.igolf.StateListPayload <em>State List Payload</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>State List Payload</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.StateListPayload
	 * @generated
	 */
	EClass getStateListPayload();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.StateListPayload#getId_country <em>Id country</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id country</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.StateListPayload#getId_country()
	 * @see #getStateListPayload()
	 * @generated
	 */
	EAttribute getStateListPayload_Id_country();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.igolf.model.igolf.ScorecardDetailsPayload <em>Scorecard Details Payload</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Scorecard Details Payload</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.ScorecardDetailsPayload
	 * @generated
	 */
	EClass getScorecardDetailsPayload();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.ScorecardDetailsPayload#getId_course <em>Id course</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id course</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.ScorecardDetailsPayload#getId_course()
	 * @see #getScorecardDetailsPayload()
	 * @generated
	 */
	EAttribute getScorecardDetailsPayload_Id_course();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.igolf.model.igolf.ScorecardListPayload <em>Scorecard List Payload</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Scorecard List Payload</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.ScorecardListPayload
	 * @generated
	 */
	EClass getScorecardListPayload();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.ScorecardListPayload#getCourseName <em>Course Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Course Name</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.ScorecardListPayload#getCourseName()
	 * @see #getScorecardListPayload()
	 * @generated
	 */
	EAttribute getScorecardListPayload_CourseName();

	/**
	 * Returns the meta object for the attribute list '{@link com.playertour.backend.igolf.model.igolf.ScorecardListPayload#getId_courseArray <em>Id course Array</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Id course Array</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.ScorecardListPayload#getId_courseArray()
	 * @see #getScorecardListPayload()
	 * @generated
	 */
	EAttribute getScorecardListPayload_Id_courseArray();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.igolf.model.igolf.CourseTeeDetailsPayload <em>Course Tee Details Payload</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Course Tee Details Payload</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseTeeDetailsPayload
	 * @generated
	 */
	EClass getCourseTeeDetailsPayload();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseTeeDetailsPayload#getId_course <em>Id course</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id course</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseTeeDetailsPayload#getId_course()
	 * @see #getCourseTeeDetailsPayload()
	 * @generated
	 */
	EAttribute getCourseTeeDetailsPayload_Id_course();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseTeeDetailsPayload#getDetailLevel <em>Detail Level</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Detail Level</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseTeeDetailsPayload#getDetailLevel()
	 * @see #getCourseTeeDetailsPayload()
	 * @generated
	 */
	EAttribute getCourseTeeDetailsPayload_DetailLevel();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.igolf.model.igolf.Scorecard <em>Scorecard</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Scorecard</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.Scorecard
	 * @generated
	 */
	EClass getScorecard();

	/**
	 * Returns the meta object for the attribute list '{@link com.playertour.backend.igolf.model.igolf.Scorecard#getHcpHole <em>Hcp Hole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Hcp Hole</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.Scorecard#getHcpHole()
	 * @see #getScorecard()
	 * @generated
	 */
	EAttribute getScorecard_HcpHole();

	/**
	 * Returns the meta object for the attribute list '{@link com.playertour.backend.igolf.model.igolf.Scorecard#getParHole <em>Par Hole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Par Hole</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.Scorecard#getParHole()
	 * @see #getScorecard()
	 * @generated
	 */
	EAttribute getScorecard_ParHole();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.Scorecard#getParIn <em>Par In</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Par In</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.Scorecard#getParIn()
	 * @see #getScorecard()
	 * @generated
	 */
	EAttribute getScorecard_ParIn();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.Scorecard#getParOut <em>Par Out</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Par Out</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.Scorecard#getParOut()
	 * @see #getScorecard()
	 * @generated
	 */
	EAttribute getScorecard_ParOut();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.Scorecard#getParTotal <em>Par Total</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Par Total</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.Scorecard#getParTotal()
	 * @see #getScorecard()
	 * @generated
	 */
	EAttribute getScorecard_ParTotal();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.igolf.model.igolf.ScorecardDetailsResponse <em>Scorecard Details Response</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Scorecard Details Response</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.ScorecardDetailsResponse
	 * @generated
	 */
	EClass getScorecardDetailsResponse();

	/**
	 * Returns the meta object for the containment reference list '{@link com.playertour.backend.igolf.model.igolf.ScorecardDetailsResponse#getMenScorecardList <em>Men Scorecard List</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Men Scorecard List</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.ScorecardDetailsResponse#getMenScorecardList()
	 * @see #getScorecardDetailsResponse()
	 * @generated
	 */
	EReference getScorecardDetailsResponse_MenScorecardList();

	/**
	 * Returns the meta object for the containment reference list '{@link com.playertour.backend.igolf.model.igolf.ScorecardDetailsResponse#getWmnScorecardList <em>Wmn Scorecard List</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Wmn Scorecard List</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.ScorecardDetailsResponse#getWmnScorecardList()
	 * @see #getScorecardDetailsResponse()
	 * @generated
	 */
	EReference getScorecardDetailsResponse_WmnScorecardList();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.igolf.model.igolf.ScorecardListResponse <em>Scorecard List Response</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Scorecard List Response</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.ScorecardListResponse
	 * @generated
	 */
	EClass getScorecardListResponse();

	/**
	 * Returns the meta object for the containment reference list '{@link com.playertour.backend.igolf.model.igolf.ScorecardListResponse#getCourseList <em>Course List</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Course List</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.ScorecardListResponse#getCourseList()
	 * @see #getScorecardListResponse()
	 * @generated
	 */
	EReference getScorecardListResponse_CourseList();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.igolf.model.igolf.CourseScorecardList <em>Course Scorecard List</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Course Scorecard List</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseScorecardList
	 * @generated
	 */
	EClass getCourseScorecardList();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseScorecardList#getId_course <em>Id course</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id course</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseScorecardList#getId_course()
	 * @see #getCourseScorecardList()
	 * @generated
	 */
	EAttribute getCourseScorecardList_Id_course();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.CourseScorecardList#getCourseName <em>Course Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Course Name</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseScorecardList#getCourseName()
	 * @see #getCourseScorecardList()
	 * @generated
	 */
	EAttribute getCourseScorecardList_CourseName();

	/**
	 * Returns the meta object for the containment reference list '{@link com.playertour.backend.igolf.model.igolf.CourseScorecardList#getMenScorecardList <em>Men Scorecard List</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Men Scorecard List</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseScorecardList#getMenScorecardList()
	 * @see #getCourseScorecardList()
	 * @generated
	 */
	EReference getCourseScorecardList_MenScorecardList();

	/**
	 * Returns the meta object for the containment reference list '{@link com.playertour.backend.igolf.model.igolf.CourseScorecardList#getWmnScorecardList <em>Wmn Scorecard List</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Wmn Scorecard List</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseScorecardList#getWmnScorecardList()
	 * @see #getCourseScorecardList()
	 * @generated
	 */
	EReference getCourseScorecardList_WmnScorecardList();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.igolf.model.igolf.CourseTeeDetailsResponse <em>Course Tee Details Response</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Course Tee Details Response</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseTeeDetailsResponse
	 * @generated
	 */
	EClass getCourseTeeDetailsResponse();

	/**
	 * Returns the meta object for the containment reference list '{@link com.playertour.backend.igolf.model.igolf.CourseTeeDetailsResponse#getTeesList <em>Tees List</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Tees List</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.CourseTeeDetailsResponse#getTeesList()
	 * @see #getCourseTeeDetailsResponse()
	 * @generated
	 */
	EReference getCourseTeeDetailsResponse_TeesList();

	/**
	 * Returns the meta object for class '{@link com.playertour.backend.igolf.model.igolf.TeeDetails <em>Tee Details</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Tee Details</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.TeeDetails
	 * @generated
	 */
	EClass getTeeDetails();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.TeeDetails#getGender <em>Gender</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Gender</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.TeeDetails#getGender()
	 * @see #getTeeDetails()
	 * @generated
	 */
	EAttribute getTeeDetails_Gender();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.TeeDetails#getRatingMen <em>Rating Men</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Rating Men</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.TeeDetails#getRatingMen()
	 * @see #getTeeDetails()
	 * @generated
	 */
	EAttribute getTeeDetails_RatingMen();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.TeeDetails#getRatingWomen <em>Rating Women</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Rating Women</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.TeeDetails#getRatingWomen()
	 * @see #getTeeDetails()
	 * @generated
	 */
	EAttribute getTeeDetails_RatingWomen();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.TeeDetails#getSlopeMen <em>Slope Men</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Slope Men</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.TeeDetails#getSlopeMen()
	 * @see #getTeeDetails()
	 * @generated
	 */
	EAttribute getTeeDetails_SlopeMen();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.TeeDetails#getSlopeWomen <em>Slope Women</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Slope Women</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.TeeDetails#getSlopeWomen()
	 * @see #getTeeDetails()
	 * @generated
	 */
	EAttribute getTeeDetails_SlopeWomen();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.TeeDetails#getTeeName <em>Tee Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Tee Name</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.TeeDetails#getTeeName()
	 * @see #getTeeDetails()
	 * @generated
	 */
	EAttribute getTeeDetails_TeeName();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.TeeDetails#getTeeColorName <em>Tee Color Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Tee Color Name</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.TeeDetails#getTeeColorName()
	 * @see #getTeeDetails()
	 * @generated
	 */
	EAttribute getTeeDetails_TeeColorName();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.TeeDetails#getTeeColorValue <em>Tee Color Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Tee Color Value</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.TeeDetails#getTeeColorValue()
	 * @see #getTeeDetails()
	 * @generated
	 */
	EAttribute getTeeDetails_TeeColorValue();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.TeeDetails#getYdsTotal <em>Yds Total</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Yds Total</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.TeeDetails#getYdsTotal()
	 * @see #getTeeDetails()
	 * @generated
	 */
	EAttribute getTeeDetails_YdsTotal();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.TeeDetails#getYds1to9 <em>Yds1to9</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Yds1to9</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.TeeDetails#getYds1to9()
	 * @see #getTeeDetails()
	 * @generated
	 */
	EAttribute getTeeDetails_Yds1to9();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.TeeDetails#getYds10to18 <em>Yds10to18</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Yds10to18</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.TeeDetails#getYds10to18()
	 * @see #getTeeDetails()
	 * @generated
	 */
	EAttribute getTeeDetails_Yds10to18();

	/**
	 * Returns the meta object for the attribute '{@link com.playertour.backend.igolf.model.igolf.TeeDetails#getYds1to18 <em>Yds1to18</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Yds1to18</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.TeeDetails#getYds1to18()
	 * @see #getTeeDetails()
	 * @generated
	 */
	EAttribute getTeeDetails_Yds1to18();

	/**
	 * Returns the meta object for the attribute list '{@link com.playertour.backend.igolf.model.igolf.TeeDetails#getYdsHole <em>Yds Hole</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Yds Hole</em>'.
	 * @see com.playertour.backend.igolf.model.igolf.TeeDetails#getYdsHole()
	 * @see #getTeeDetails()
	 * @generated
	 */
	EAttribute getTeeDetails_YdsHole();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	IGolfFactory getIGolfFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each operation of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link com.playertour.backend.igolf.model.igolf.impl.ResponseImpl <em>Response</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.igolf.model.igolf.impl.ResponseImpl
		 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getResponse()
		 * @generated
		 */
		EClass RESPONSE = eINSTANCE.getResponse();

		/**
		 * The meta object literal for the '<em><b>Status</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RESPONSE__STATUS = eINSTANCE.getResponse_Status();

		/**
		 * The meta object literal for the '<em><b>Error Message</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RESPONSE__ERROR_MESSAGE = eINSTANCE.getResponse_ErrorMessage();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.igolf.model.igolf.impl.CourseListResponseImpl <em>Course List Response</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.igolf.model.igolf.impl.CourseListResponseImpl
		 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getCourseListResponse()
		 * @generated
		 */
		EClass COURSE_LIST_RESPONSE = eINSTANCE.getCourseListResponse();

		/**
		 * The meta object literal for the '<em><b>Course List</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COURSE_LIST_RESPONSE__COURSE_LIST = eINSTANCE.getCourseListResponse_CourseList();

		/**
		 * The meta object literal for the '<em><b>Page</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_LIST_RESPONSE__PAGE = eINSTANCE.getCourseListResponse_Page();

		/**
		 * The meta object literal for the '<em><b>Totalpages</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_LIST_RESPONSE__TOTALPAGES = eINSTANCE.getCourseListResponse_Totalpages();

		/**
		 * The meta object literal for the '<em><b>Total Courses</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_LIST_RESPONSE__TOTAL_COURSES = eINSTANCE.getCourseListResponse_TotalCourses();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.igolf.model.igolf.impl.CourseInfoImpl <em>Course Info</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.igolf.model.igolf.impl.CourseInfoImpl
		 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getCourseInfo()
		 * @generated
		 */
		EClass COURSE_INFO = eINSTANCE.getCourseInfo();

		/**
		 * The meta object literal for the '<em><b>Active</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_INFO__ACTIVE = eINSTANCE.getCourseInfo_Active();

		/**
		 * The meta object literal for the '<em><b>Id course</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_INFO__ID_COURSE = eINSTANCE.getCourseInfo_Id_course();

		/**
		 * The meta object literal for the '<em><b>Course Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_INFO__COURSE_NAME = eINSTANCE.getCourseInfo_CourseName();

		/**
		 * The meta object literal for the '<em><b>Email</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_INFO__EMAIL = eINSTANCE.getCourseInfo_Email();

		/**
		 * The meta object literal for the '<em><b>Address1</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_INFO__ADDRESS1 = eINSTANCE.getCourseInfo_Address1();

		/**
		 * The meta object literal for the '<em><b>Address2</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_INFO__ADDRESS2 = eINSTANCE.getCourseInfo_Address2();

		/**
		 * The meta object literal for the '<em><b>City</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_INFO__CITY = eINSTANCE.getCourseInfo_City();

		/**
		 * The meta object literal for the '<em><b>Id country</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_INFO__ID_COUNTRY = eINSTANCE.getCourseInfo_Id_country();

		/**
		 * The meta object literal for the '<em><b>Country Full</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_INFO__COUNTRY_FULL = eINSTANCE.getCourseInfo_CountryFull();

		/**
		 * The meta object literal for the '<em><b>Country Short</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_INFO__COUNTRY_SHORT = eINSTANCE.getCourseInfo_CountryShort();

		/**
		 * The meta object literal for the '<em><b>Distance</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_INFO__DISTANCE = eINSTANCE.getCourseInfo_Distance();

		/**
		 * The meta object literal for the '<em><b>Latitude</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_INFO__LATITUDE = eINSTANCE.getCourseInfo_Latitude();

		/**
		 * The meta object literal for the '<em><b>Longitude</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_INFO__LONGITUDE = eINSTANCE.getCourseInfo_Longitude();

		/**
		 * The meta object literal for the '<em><b>Scorecard Available</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_INFO__SCORECARD_AVAILABLE = eINSTANCE.getCourseInfo_ScorecardAvailable();

		/**
		 * The meta object literal for the '<em><b>Gps Available</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_INFO__GPS_AVAILABLE = eINSTANCE.getCourseInfo_GpsAvailable();

		/**
		 * The meta object literal for the '<em><b>Vector Available</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_INFO__VECTOR_AVAILABLE = eINSTANCE.getCourseInfo_VectorAvailable();

		/**
		 * The meta object literal for the '<em><b>Recommended Rating</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_INFO__RECOMMENDED_RATING = eINSTANCE.getCourseInfo_RecommendedRating();

		/**
		 * The meta object literal for the '<em><b>Condition Rating</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_INFO__CONDITION_RATING = eINSTANCE.getCourseInfo_ConditionRating();

		/**
		 * The meta object literal for the '<em><b>Id state</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_INFO__ID_STATE = eINSTANCE.getCourseInfo_Id_state();

		/**
		 * The meta object literal for the '<em><b>State Full</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_INFO__STATE_FULL = eINSTANCE.getCourseInfo_StateFull();

		/**
		 * The meta object literal for the '<em><b>State Short</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_INFO__STATE_SHORT = eINSTANCE.getCourseInfo_StateShort();

		/**
		 * The meta object literal for the '<em><b>Zip Code</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_INFO__ZIP_CODE = eINSTANCE.getCourseInfo_ZipCode();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.igolf.model.igolf.impl.CourseDetailsResponseImpl <em>Course Details Response</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.igolf.model.igolf.impl.CourseDetailsResponseImpl
		 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getCourseDetailsResponse()
		 * @generated
		 */
		EClass COURSE_DETAILS_RESPONSE = eINSTANCE.getCourseDetailsResponse();

		/**
		 * The meta object literal for the '<em><b>Active</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_DETAILS_RESPONSE__ACTIVE = eINSTANCE.getCourseDetailsResponse_Active();

		/**
		 * The meta object literal for the '<em><b>Course Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_DETAILS_RESPONSE__COURSE_NAME = eINSTANCE.getCourseDetailsResponse_CourseName();

		/**
		 * The meta object literal for the '<em><b>Email</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_DETAILS_RESPONSE__EMAIL = eINSTANCE.getCourseDetailsResponse_Email();

		/**
		 * The meta object literal for the '<em><b>Address1</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_DETAILS_RESPONSE__ADDRESS1 = eINSTANCE.getCourseDetailsResponse_Address1();

		/**
		 * The meta object literal for the '<em><b>Address2</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_DETAILS_RESPONSE__ADDRESS2 = eINSTANCE.getCourseDetailsResponse_Address2();

		/**
		 * The meta object literal for the '<em><b>City</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_DETAILS_RESPONSE__CITY = eINSTANCE.getCourseDetailsResponse_City();

		/**
		 * The meta object literal for the '<em><b>Id country</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_DETAILS_RESPONSE__ID_COUNTRY = eINSTANCE.getCourseDetailsResponse_Id_country();

		/**
		 * The meta object literal for the '<em><b>Country Full</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_DETAILS_RESPONSE__COUNTRY_FULL = eINSTANCE.getCourseDetailsResponse_CountryFull();

		/**
		 * The meta object literal for the '<em><b>Country Short</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_DETAILS_RESPONSE__COUNTRY_SHORT = eINSTANCE.getCourseDetailsResponse_CountryShort();

		/**
		 * The meta object literal for the '<em><b>Scorecard Available</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_DETAILS_RESPONSE__SCORECARD_AVAILABLE = eINSTANCE.getCourseDetailsResponse_ScorecardAvailable();

		/**
		 * The meta object literal for the '<em><b>Gps Available</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_DETAILS_RESPONSE__GPS_AVAILABLE = eINSTANCE.getCourseDetailsResponse_GpsAvailable();

		/**
		 * The meta object literal for the '<em><b>Id state</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_DETAILS_RESPONSE__ID_STATE = eINSTANCE.getCourseDetailsResponse_Id_state();

		/**
		 * The meta object literal for the '<em><b>State Full</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_DETAILS_RESPONSE__STATE_FULL = eINSTANCE.getCourseDetailsResponse_StateFull();

		/**
		 * The meta object literal for the '<em><b>State Short</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_DETAILS_RESPONSE__STATE_SHORT = eINSTANCE.getCourseDetailsResponse_StateShort();

		/**
		 * The meta object literal for the '<em><b>Zip Code</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_DETAILS_RESPONSE__ZIP_CODE = eINSTANCE.getCourseDetailsResponse_ZipCode();

		/**
		 * The meta object literal for the '<em><b>Class</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_DETAILS_RESPONSE__CLASS = eINSTANCE.getCourseDetailsResponse_Class();

		/**
		 * The meta object literal for the '<em><b>Image</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_DETAILS_RESPONSE__IMAGE = eINSTANCE.getCourseDetailsResponse_Image();

		/**
		 * The meta object literal for the '<em><b>Layout Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_DETAILS_RESPONSE__LAYOUT_NAME = eINSTANCE.getCourseDetailsResponse_LayoutName();

		/**
		 * The meta object literal for the '<em><b>Phone</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_DETAILS_RESPONSE__PHONE = eINSTANCE.getCourseDetailsResponse_Phone();

		/**
		 * The meta object literal for the '<em><b>Url</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_DETAILS_RESPONSE__URL = eINSTANCE.getCourseDetailsResponse_Url();

		/**
		 * The meta object literal for the '<em><b>Fax</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_DETAILS_RESPONSE__FAX = eINSTANCE.getCourseDetailsResponse_Fax();

		/**
		 * The meta object literal for the '<em><b>Day Closed</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_DETAILS_RESPONSE__DAY_CLOSED = eINSTANCE.getCourseDetailsResponse_DayClosed();

		/**
		 * The meta object literal for the '<em><b>Dress Code</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_DETAILS_RESPONSE__DRESS_CODE = eINSTANCE.getCourseDetailsResponse_DressCode();

		/**
		 * The meta object literal for the '<em><b>Layout Holes</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_DETAILS_RESPONSE__LAYOUT_HOLES = eINSTANCE.getCourseDetailsResponse_LayoutHoles();

		/**
		 * The meta object literal for the '<em><b>Layout Total Holes</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_DETAILS_RESPONSE__LAYOUT_TOTAL_HOLES = eINSTANCE.getCourseDetailsResponse_LayoutTotalHoles();

		/**
		 * The meta object literal for the '<em><b>Seasonal</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_DETAILS_RESPONSE__SEASONAL = eINSTANCE.getCourseDetailsResponse_Seasonal();

		/**
		 * The meta object literal for the '<em><b>Pricing</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COURSE_DETAILS_RESPONSE__PRICING = eINSTANCE.getCourseDetailsResponse_Pricing();

		/**
		 * The meta object literal for the '<em><b>Latitude</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_DETAILS_RESPONSE__LATITUDE = eINSTANCE.getCourseDetailsResponse_Latitude();

		/**
		 * The meta object literal for the '<em><b>Longitude</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_DETAILS_RESPONSE__LONGITUDE = eINSTANCE.getCourseDetailsResponse_Longitude();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.igolf.model.igolf.impl.PriceImpl <em>Price</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.igolf.model.igolf.impl.PriceImpl
		 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getPrice()
		 * @generated
		 */
		EClass PRICE = eINSTANCE.getPrice();

		/**
		 * The meta object literal for the '<em><b>Weekend9</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PRICE__WEEKEND9 = eINSTANCE.getPrice_Weekend9();

		/**
		 * The meta object literal for the '<em><b>Weekend18</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PRICE__WEEKEND18 = eINSTANCE.getPrice_Weekend18();

		/**
		 * The meta object literal for the '<em><b>Weekday9</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PRICE__WEEKDAY9 = eINSTANCE.getPrice_Weekday9();

		/**
		 * The meta object literal for the '<em><b>Weekday18</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PRICE__WEEKDAY18 = eINSTANCE.getPrice_Weekday18();

		/**
		 * The meta object literal for the '<em><b>Twilight</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PRICE__TWILIGHT = eINSTANCE.getPrice_Twilight();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.igolf.model.igolf.impl.CountryListResponseImpl <em>Country List Response</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.igolf.model.igolf.impl.CountryListResponseImpl
		 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getCountryListResponse()
		 * @generated
		 */
		EClass COUNTRY_LIST_RESPONSE = eINSTANCE.getCountryListResponse();

		/**
		 * The meta object literal for the '<em><b>Country List</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COUNTRY_LIST_RESPONSE__COUNTRY_LIST = eINSTANCE.getCountryListResponse_CountryList();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.igolf.model.igolf.impl.CountryInfoImpl <em>Country Info</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.igolf.model.igolf.impl.CountryInfoImpl
		 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getCountryInfo()
		 * @generated
		 */
		EClass COUNTRY_INFO = eINSTANCE.getCountryInfo();

		/**
		 * The meta object literal for the '<em><b>Country Full</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COUNTRY_INFO__COUNTRY_FULL = eINSTANCE.getCountryInfo_CountryFull();

		/**
		 * The meta object literal for the '<em><b>Country Short</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COUNTRY_INFO__COUNTRY_SHORT = eINSTANCE.getCountryInfo_CountryShort();

		/**
		 * The meta object literal for the '<em><b>Id country</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COUNTRY_INFO__ID_COUNTRY = eINSTANCE.getCountryInfo_Id_country();

		/**
		 * The meta object literal for the '<em><b>Id continent</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COUNTRY_INFO__ID_CONTINENT = eINSTANCE.getCountryInfo_Id_continent();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.igolf.model.igolf.impl.StateListResponseImpl <em>State List Response</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.igolf.model.igolf.impl.StateListResponseImpl
		 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getStateListResponse()
		 * @generated
		 */
		EClass STATE_LIST_RESPONSE = eINSTANCE.getStateListResponse();

		/**
		 * The meta object literal for the '<em><b>State List</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference STATE_LIST_RESPONSE__STATE_LIST = eINSTANCE.getStateListResponse_StateList();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.igolf.model.igolf.impl.StateInfoImpl <em>State Info</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.igolf.model.igolf.impl.StateInfoImpl
		 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getStateInfo()
		 * @generated
		 */
		EClass STATE_INFO = eINSTANCE.getStateInfo();

		/**
		 * The meta object literal for the '<em><b>Id country</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STATE_INFO__ID_COUNTRY = eINSTANCE.getStateInfo_Id_country();

		/**
		 * The meta object literal for the '<em><b>Id state</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STATE_INFO__ID_STATE = eINSTANCE.getStateInfo_Id_state();

		/**
		 * The meta object literal for the '<em><b>State Full</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STATE_INFO__STATE_FULL = eINSTANCE.getStateInfo_StateFull();

		/**
		 * The meta object literal for the '<em><b>State Short</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STATE_INFO__STATE_SHORT = eINSTANCE.getStateInfo_StateShort();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.igolf.model.igolf.impl.CourseGPSVectorResponseImpl <em>Course GPS Vector Response</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.igolf.model.igolf.impl.CourseGPSVectorResponseImpl
		 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getCourseGPSVectorResponse()
		 * @generated
		 */
		EClass COURSE_GPS_VECTOR_RESPONSE = eINSTANCE.getCourseGPSVectorResponse();

		/**
		 * The meta object literal for the '<em><b>Vector GPS Object</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COURSE_GPS_VECTOR_RESPONSE__VECTOR_GPS_OBJECT = eINSTANCE.getCourseGPSVectorResponse_VectorGPSObject();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.igolf.model.igolf.impl.ShapeObjectImpl <em>Shape Object</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.igolf.model.igolf.impl.ShapeObjectImpl
		 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getShapeObject()
		 * @generated
		 */
		EClass SHAPE_OBJECT = eINSTANCE.getShapeObject();

		/**
		 * The meta object literal for the '<em><b>Shape Count</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SHAPE_OBJECT__SHAPE_COUNT = eINSTANCE.getShapeObject_ShapeCount();

		/**
		 * The meta object literal for the '<em><b>Shapes</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SHAPE_OBJECT__SHAPES = eINSTANCE.getShapeObject_Shapes();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.igolf.model.igolf.impl.ShapesImpl <em>Shapes</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.igolf.model.igolf.impl.ShapesImpl
		 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getShapes()
		 * @generated
		 */
		EClass SHAPES = eINSTANCE.getShapes();

		/**
		 * The meta object literal for the '<em><b>Shape</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SHAPES__SHAPE = eINSTANCE.getShapes_Shape();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.igolf.model.igolf.impl.ShapeImpl <em>Shape</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.igolf.model.igolf.impl.ShapeImpl
		 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getShape()
		 * @generated
		 */
		EClass SHAPE = eINSTANCE.getShape();

		/**
		 * The meta object literal for the '<em><b>Attributes</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SHAPE__ATTRIBUTES = eINSTANCE.getShape_Attributes();

		/**
		 * The meta object literal for the '<em><b>Points</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SHAPE__POINTS = eINSTANCE.getShape_Points();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.igolf.model.igolf.impl.AttributesImpl <em>Attributes</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.igolf.model.igolf.impl.AttributesImpl
		 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getAttributes()
		 * @generated
		 */
		EClass ATTRIBUTES = eINSTANCE.getAttributes();

		/**
		 * The meta object literal for the '<em><b>Description</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATTRIBUTES__DESCRIPTION = eINSTANCE.getAttributes_Description();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATTRIBUTES__TYPE = eINSTANCE.getAttributes_Type();

		/**
		 * The meta object literal for the '<em><b>Size</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ATTRIBUTES__SIZE = eINSTANCE.getAttributes_Size();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.igolf.model.igolf.impl.VectorGPSObjectImpl <em>Vector GPS Object</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.igolf.model.igolf.impl.VectorGPSObjectImpl
		 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getVectorGPSObject()
		 * @generated
		 */
		EClass VECTOR_GPS_OBJECT = eINSTANCE.getVectorGPSObject();

		/**
		 * The meta object literal for the '<em><b>Hole Count</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute VECTOR_GPS_OBJECT__HOLE_COUNT = eINSTANCE.getVectorGPSObject_HoleCount();

		/**
		 * The meta object literal for the '<em><b>Ocean</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VECTOR_GPS_OBJECT__OCEAN = eINSTANCE.getVectorGPSObject_Ocean();

		/**
		 * The meta object literal for the '<em><b>Background</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VECTOR_GPS_OBJECT__BACKGROUND = eINSTANCE.getVectorGPSObject_Background();

		/**
		 * The meta object literal for the '<em><b>Bridge</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VECTOR_GPS_OBJECT__BRIDGE = eINSTANCE.getVectorGPSObject_Bridge();

		/**
		 * The meta object literal for the '<em><b>Vegetation</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VECTOR_GPS_OBJECT__VEGETATION = eINSTANCE.getVectorGPSObject_Vegetation();

		/**
		 * The meta object literal for the '<em><b>Lava</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VECTOR_GPS_OBJECT__LAVA = eINSTANCE.getVectorGPSObject_Lava();

		/**
		 * The meta object literal for the '<em><b>Path</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VECTOR_GPS_OBJECT__PATH = eINSTANCE.getVectorGPSObject_Path();

		/**
		 * The meta object literal for the '<em><b>Tree</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VECTOR_GPS_OBJECT__TREE = eINSTANCE.getVectorGPSObject_Tree();

		/**
		 * The meta object literal for the '<em><b>Lake</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VECTOR_GPS_OBJECT__LAKE = eINSTANCE.getVectorGPSObject_Lake();

		/**
		 * The meta object literal for the '<em><b>Water</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VECTOR_GPS_OBJECT__WATER = eINSTANCE.getVectorGPSObject_Water();

		/**
		 * The meta object literal for the '<em><b>Clubhouse</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VECTOR_GPS_OBJECT__CLUBHOUSE = eINSTANCE.getVectorGPSObject_Clubhouse();

		/**
		 * The meta object literal for the '<em><b>Pond</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VECTOR_GPS_OBJECT__POND = eINSTANCE.getVectorGPSObject_Pond();

		/**
		 * The meta object literal for the '<em><b>Creek</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VECTOR_GPS_OBJECT__CREEK = eINSTANCE.getVectorGPSObject_Creek();

		/**
		 * The meta object literal for the '<em><b>Sand</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VECTOR_GPS_OBJECT__SAND = eINSTANCE.getVectorGPSObject_Sand();

		/**
		 * The meta object literal for the '<em><b>Rock</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VECTOR_GPS_OBJECT__ROCK = eINSTANCE.getVectorGPSObject_Rock();

		/**
		 * The meta object literal for the '<em><b>Holes</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference VECTOR_GPS_OBJECT__HOLES = eINSTANCE.getVectorGPSObject_Holes();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.igolf.model.igolf.impl.HolesImpl <em>Holes</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.igolf.model.igolf.impl.HolesImpl
		 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getHoles()
		 * @generated
		 */
		EClass HOLES = eINSTANCE.getHoles();

		/**
		 * The meta object literal for the '<em><b>Hole</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference HOLES__HOLE = eINSTANCE.getHoles_Hole();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.igolf.model.igolf.impl.HoleImpl <em>Hole</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.igolf.model.igolf.impl.HoleImpl
		 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getHole()
		 * @generated
		 */
		EClass HOLE = eINSTANCE.getHole();

		/**
		 * The meta object literal for the '<em><b>Hole Number</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HOLE__HOLE_NUMBER = eINSTANCE.getHole_HoleNumber();

		/**
		 * The meta object literal for the '<em><b>Greencenter</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference HOLE__GREENCENTER = eINSTANCE.getHole_Greencenter();

		/**
		 * The meta object literal for the '<em><b>Bunker</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference HOLE__BUNKER = eINSTANCE.getHole_Bunker();

		/**
		 * The meta object literal for the '<em><b>Centralpath</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference HOLE__CENTRALPATH = eINSTANCE.getHole_Centralpath();

		/**
		 * The meta object literal for the '<em><b>Teeboxcenter</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference HOLE__TEEBOXCENTER = eINSTANCE.getHole_Teeboxcenter();

		/**
		 * The meta object literal for the '<em><b>Perimeter</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference HOLE__PERIMETER = eINSTANCE.getHole_Perimeter();

		/**
		 * The meta object literal for the '<em><b>Green</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference HOLE__GREEN = eINSTANCE.getHole_Green();

		/**
		 * The meta object literal for the '<em><b>Fairway</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference HOLE__FAIRWAY = eINSTANCE.getHole_Fairway();

		/**
		 * The meta object literal for the '<em><b>Teebox</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference HOLE__TEEBOX = eINSTANCE.getHole_Teebox();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.igolf.model.igolf.impl.CourseCompleteResponseImpl <em>Course Complete Response</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.igolf.model.igolf.impl.CourseCompleteResponseImpl
		 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getCourseCompleteResponse()
		 * @generated
		 */
		EClass COURSE_COMPLETE_RESPONSE = eINSTANCE.getCourseCompleteResponse();

		/**
		 * The meta object literal for the '<em><b>Course Details</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COURSE_COMPLETE_RESPONSE__COURSE_DETAILS = eINSTANCE.getCourseCompleteResponse_CourseDetails();

		/**
		 * The meta object literal for the '<em><b>Course GPS Vector</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COURSE_COMPLETE_RESPONSE__COURSE_GPS_VECTOR = eINSTANCE.getCourseCompleteResponse_CourseGPSVector();

		/**
		 * The meta object literal for the '<em><b>Course Info</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COURSE_COMPLETE_RESPONSE__COURSE_INFO = eINSTANCE.getCourseCompleteResponse_CourseInfo();

		/**
		 * The meta object literal for the '<em><b>Scorecard Details</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COURSE_COMPLETE_RESPONSE__SCORECARD_DETAILS = eINSTANCE.getCourseCompleteResponse_ScorecardDetails();

		/**
		 * The meta object literal for the '<em><b>Tee Details</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COURSE_COMPLETE_RESPONSE__TEE_DETAILS = eINSTANCE.getCourseCompleteResponse_TeeDetails();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.igolf.model.igolf.impl.PayloadImpl <em>Payload</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.igolf.model.igolf.impl.PayloadImpl
		 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getPayload()
		 * @generated
		 */
		EClass PAYLOAD = eINSTANCE.getPayload();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.igolf.model.igolf.impl.RequestImpl <em>Request</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.igolf.model.igolf.impl.RequestImpl
		 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getRequest()
		 * @generated
		 */
		EClass REQUEST = eINSTANCE.getRequest();

		/**
		 * The meta object literal for the '<em><b>Payload</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference REQUEST__PAYLOAD = eINSTANCE.getRequest_Payload();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.igolf.model.igolf.impl.CourseDetailsRequestImpl <em>Course Details Request</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.igolf.model.igolf.impl.CourseDetailsRequestImpl
		 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getCourseDetailsRequest()
		 * @generated
		 */
		EClass COURSE_DETAILS_REQUEST = eINSTANCE.getCourseDetailsRequest();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.igolf.model.igolf.impl.CourseListRequestImpl <em>Course List Request</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.igolf.model.igolf.impl.CourseListRequestImpl
		 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getCourseListRequest()
		 * @generated
		 */
		EClass COURSE_LIST_REQUEST = eINSTANCE.getCourseListRequest();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.igolf.model.igolf.impl.CourseGPSVectorRequestImpl <em>Course GPS Vector Request</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.igolf.model.igolf.impl.CourseGPSVectorRequestImpl
		 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getCourseGPSVectorRequest()
		 * @generated
		 */
		EClass COURSE_GPS_VECTOR_REQUEST = eINSTANCE.getCourseGPSVectorRequest();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.igolf.model.igolf.impl.CountryListRequestImpl <em>Country List Request</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.igolf.model.igolf.impl.CountryListRequestImpl
		 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getCountryListRequest()
		 * @generated
		 */
		EClass COUNTRY_LIST_REQUEST = eINSTANCE.getCountryListRequest();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.igolf.model.igolf.impl.StateListRequestImpl <em>State List Request</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.igolf.model.igolf.impl.StateListRequestImpl
		 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getStateListRequest()
		 * @generated
		 */
		EClass STATE_LIST_REQUEST = eINSTANCE.getStateListRequest();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.igolf.model.igolf.impl.ScorecardDetailsRequestImpl <em>Scorecard Details Request</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.igolf.model.igolf.impl.ScorecardDetailsRequestImpl
		 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getScorecardDetailsRequest()
		 * @generated
		 */
		EClass SCORECARD_DETAILS_REQUEST = eINSTANCE.getScorecardDetailsRequest();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.igolf.model.igolf.impl.ScorecardListRequestImpl <em>Scorecard List Request</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.igolf.model.igolf.impl.ScorecardListRequestImpl
		 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getScorecardListRequest()
		 * @generated
		 */
		EClass SCORECARD_LIST_REQUEST = eINSTANCE.getScorecardListRequest();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.igolf.model.igolf.impl.CourseTeeDetailsRequestImpl <em>Course Tee Details Request</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.igolf.model.igolf.impl.CourseTeeDetailsRequestImpl
		 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getCourseTeeDetailsRequest()
		 * @generated
		 */
		EClass COURSE_TEE_DETAILS_REQUEST = eINSTANCE.getCourseTeeDetailsRequest();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.igolf.model.igolf.impl.CourseDetailsPayloadImpl <em>Course Details Payload</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.igolf.model.igolf.impl.CourseDetailsPayloadImpl
		 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getCourseDetailsPayload()
		 * @generated
		 */
		EClass COURSE_DETAILS_PAYLOAD = eINSTANCE.getCourseDetailsPayload();

		/**
		 * The meta object literal for the '<em><b>Id course</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_DETAILS_PAYLOAD__ID_COURSE = eINSTANCE.getCourseDetailsPayload_Id_course();

		/**
		 * The meta object literal for the '<em><b>Detail Level</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_DETAILS_PAYLOAD__DETAIL_LEVEL = eINSTANCE.getCourseDetailsPayload_DetailLevel();

		/**
		 * The meta object literal for the '<em><b>Country Format</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_DETAILS_PAYLOAD__COUNTRY_FORMAT = eINSTANCE.getCourseDetailsPayload_CountryFormat();

		/**
		 * The meta object literal for the '<em><b>State Format</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_DETAILS_PAYLOAD__STATE_FORMAT = eINSTANCE.getCourseDetailsPayload_StateFormat();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.igolf.model.igolf.impl.CourseListPayloadImpl <em>Course List Payload</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.igolf.model.igolf.impl.CourseListPayloadImpl
		 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getCourseListPayload()
		 * @generated
		 */
		EClass COURSE_LIST_PAYLOAD = eINSTANCE.getCourseListPayload();

		/**
		 * The meta object literal for the '<em><b>Active</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_LIST_PAYLOAD__ACTIVE = eINSTANCE.getCourseListPayload_Active();

		/**
		 * The meta object literal for the '<em><b>Id country</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_LIST_PAYLOAD__ID_COUNTRY = eINSTANCE.getCourseListPayload_Id_country();

		/**
		 * The meta object literal for the '<em><b>Country Format</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_LIST_PAYLOAD__COUNTRY_FORMAT = eINSTANCE.getCourseListPayload_CountryFormat();

		/**
		 * The meta object literal for the '<em><b>Id state</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_LIST_PAYLOAD__ID_STATE = eINSTANCE.getCourseListPayload_Id_state();

		/**
		 * The meta object literal for the '<em><b>State Format</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_LIST_PAYLOAD__STATE_FORMAT = eINSTANCE.getCourseListPayload_StateFormat();

		/**
		 * The meta object literal for the '<em><b>City</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_LIST_PAYLOAD__CITY = eINSTANCE.getCourseListPayload_City();

		/**
		 * The meta object literal for the '<em><b>Zipcode</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_LIST_PAYLOAD__ZIPCODE = eINSTANCE.getCourseListPayload_Zipcode();

		/**
		 * The meta object literal for the '<em><b>Course Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_LIST_PAYLOAD__COURSE_NAME = eINSTANCE.getCourseListPayload_CourseName();

		/**
		 * The meta object literal for the '<em><b>Radius</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_LIST_PAYLOAD__RADIUS = eINSTANCE.getCourseListPayload_Radius();

		/**
		 * The meta object literal for the '<em><b>Reference Latitude</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_LIST_PAYLOAD__REFERENCE_LATITUDE = eINSTANCE.getCourseListPayload_ReferenceLatitude();

		/**
		 * The meta object literal for the '<em><b>Reference Longitude</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_LIST_PAYLOAD__REFERENCE_LONGITUDE = eINSTANCE.getCourseListPayload_ReferenceLongitude();

		/**
		 * The meta object literal for the '<em><b>Page</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_LIST_PAYLOAD__PAGE = eINSTANCE.getCourseListPayload_Page();

		/**
		 * The meta object literal for the '<em><b>Results Per Page</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_LIST_PAYLOAD__RESULTS_PER_PAGE = eINSTANCE.getCourseListPayload_ResultsPerPage();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.igolf.model.igolf.impl.CourseGPSVectorPayloadImpl <em>Course GPS Vector Payload</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.igolf.model.igolf.impl.CourseGPSVectorPayloadImpl
		 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getCourseGPSVectorPayload()
		 * @generated
		 */
		EClass COURSE_GPS_VECTOR_PAYLOAD = eINSTANCE.getCourseGPSVectorPayload();

		/**
		 * The meta object literal for the '<em><b>Id course</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_GPS_VECTOR_PAYLOAD__ID_COURSE = eINSTANCE.getCourseGPSVectorPayload_Id_course();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.igolf.model.igolf.impl.CountryListPayloadImpl <em>Country List Payload</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.igolf.model.igolf.impl.CountryListPayloadImpl
		 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getCountryListPayload()
		 * @generated
		 */
		EClass COUNTRY_LIST_PAYLOAD = eINSTANCE.getCountryListPayload();

		/**
		 * The meta object literal for the '<em><b>Id continent</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COUNTRY_LIST_PAYLOAD__ID_CONTINENT = eINSTANCE.getCountryListPayload_Id_continent();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.igolf.model.igolf.impl.StateListPayloadImpl <em>State List Payload</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.igolf.model.igolf.impl.StateListPayloadImpl
		 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getStateListPayload()
		 * @generated
		 */
		EClass STATE_LIST_PAYLOAD = eINSTANCE.getStateListPayload();

		/**
		 * The meta object literal for the '<em><b>Id country</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STATE_LIST_PAYLOAD__ID_COUNTRY = eINSTANCE.getStateListPayload_Id_country();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.igolf.model.igolf.impl.ScorecardDetailsPayloadImpl <em>Scorecard Details Payload</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.igolf.model.igolf.impl.ScorecardDetailsPayloadImpl
		 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getScorecardDetailsPayload()
		 * @generated
		 */
		EClass SCORECARD_DETAILS_PAYLOAD = eINSTANCE.getScorecardDetailsPayload();

		/**
		 * The meta object literal for the '<em><b>Id course</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCORECARD_DETAILS_PAYLOAD__ID_COURSE = eINSTANCE.getScorecardDetailsPayload_Id_course();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.igolf.model.igolf.impl.ScorecardListPayloadImpl <em>Scorecard List Payload</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.igolf.model.igolf.impl.ScorecardListPayloadImpl
		 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getScorecardListPayload()
		 * @generated
		 */
		EClass SCORECARD_LIST_PAYLOAD = eINSTANCE.getScorecardListPayload();

		/**
		 * The meta object literal for the '<em><b>Course Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCORECARD_LIST_PAYLOAD__COURSE_NAME = eINSTANCE.getScorecardListPayload_CourseName();

		/**
		 * The meta object literal for the '<em><b>Id course Array</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCORECARD_LIST_PAYLOAD__ID_COURSE_ARRAY = eINSTANCE.getScorecardListPayload_Id_courseArray();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.igolf.model.igolf.impl.CourseTeeDetailsPayloadImpl <em>Course Tee Details Payload</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.igolf.model.igolf.impl.CourseTeeDetailsPayloadImpl
		 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getCourseTeeDetailsPayload()
		 * @generated
		 */
		EClass COURSE_TEE_DETAILS_PAYLOAD = eINSTANCE.getCourseTeeDetailsPayload();

		/**
		 * The meta object literal for the '<em><b>Id course</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_TEE_DETAILS_PAYLOAD__ID_COURSE = eINSTANCE.getCourseTeeDetailsPayload_Id_course();

		/**
		 * The meta object literal for the '<em><b>Detail Level</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_TEE_DETAILS_PAYLOAD__DETAIL_LEVEL = eINSTANCE.getCourseTeeDetailsPayload_DetailLevel();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.igolf.model.igolf.impl.ScorecardImpl <em>Scorecard</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.igolf.model.igolf.impl.ScorecardImpl
		 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getScorecard()
		 * @generated
		 */
		EClass SCORECARD = eINSTANCE.getScorecard();

		/**
		 * The meta object literal for the '<em><b>Hcp Hole</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCORECARD__HCP_HOLE = eINSTANCE.getScorecard_HcpHole();

		/**
		 * The meta object literal for the '<em><b>Par Hole</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCORECARD__PAR_HOLE = eINSTANCE.getScorecard_ParHole();

		/**
		 * The meta object literal for the '<em><b>Par In</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCORECARD__PAR_IN = eINSTANCE.getScorecard_ParIn();

		/**
		 * The meta object literal for the '<em><b>Par Out</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCORECARD__PAR_OUT = eINSTANCE.getScorecard_ParOut();

		/**
		 * The meta object literal for the '<em><b>Par Total</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCORECARD__PAR_TOTAL = eINSTANCE.getScorecard_ParTotal();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.igolf.model.igolf.impl.ScorecardDetailsResponseImpl <em>Scorecard Details Response</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.igolf.model.igolf.impl.ScorecardDetailsResponseImpl
		 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getScorecardDetailsResponse()
		 * @generated
		 */
		EClass SCORECARD_DETAILS_RESPONSE = eINSTANCE.getScorecardDetailsResponse();

		/**
		 * The meta object literal for the '<em><b>Men Scorecard List</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SCORECARD_DETAILS_RESPONSE__MEN_SCORECARD_LIST = eINSTANCE.getScorecardDetailsResponse_MenScorecardList();

		/**
		 * The meta object literal for the '<em><b>Wmn Scorecard List</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SCORECARD_DETAILS_RESPONSE__WMN_SCORECARD_LIST = eINSTANCE.getScorecardDetailsResponse_WmnScorecardList();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.igolf.model.igolf.impl.ScorecardListResponseImpl <em>Scorecard List Response</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.igolf.model.igolf.impl.ScorecardListResponseImpl
		 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getScorecardListResponse()
		 * @generated
		 */
		EClass SCORECARD_LIST_RESPONSE = eINSTANCE.getScorecardListResponse();

		/**
		 * The meta object literal for the '<em><b>Course List</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SCORECARD_LIST_RESPONSE__COURSE_LIST = eINSTANCE.getScorecardListResponse_CourseList();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.igolf.model.igolf.impl.CourseScorecardListImpl <em>Course Scorecard List</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.igolf.model.igolf.impl.CourseScorecardListImpl
		 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getCourseScorecardList()
		 * @generated
		 */
		EClass COURSE_SCORECARD_LIST = eINSTANCE.getCourseScorecardList();

		/**
		 * The meta object literal for the '<em><b>Id course</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_SCORECARD_LIST__ID_COURSE = eINSTANCE.getCourseScorecardList_Id_course();

		/**
		 * The meta object literal for the '<em><b>Course Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute COURSE_SCORECARD_LIST__COURSE_NAME = eINSTANCE.getCourseScorecardList_CourseName();

		/**
		 * The meta object literal for the '<em><b>Men Scorecard List</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COURSE_SCORECARD_LIST__MEN_SCORECARD_LIST = eINSTANCE.getCourseScorecardList_MenScorecardList();

		/**
		 * The meta object literal for the '<em><b>Wmn Scorecard List</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COURSE_SCORECARD_LIST__WMN_SCORECARD_LIST = eINSTANCE.getCourseScorecardList_WmnScorecardList();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.igolf.model.igolf.impl.CourseTeeDetailsResponseImpl <em>Course Tee Details Response</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.igolf.model.igolf.impl.CourseTeeDetailsResponseImpl
		 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getCourseTeeDetailsResponse()
		 * @generated
		 */
		EClass COURSE_TEE_DETAILS_RESPONSE = eINSTANCE.getCourseTeeDetailsResponse();

		/**
		 * The meta object literal for the '<em><b>Tees List</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference COURSE_TEE_DETAILS_RESPONSE__TEES_LIST = eINSTANCE.getCourseTeeDetailsResponse_TeesList();

		/**
		 * The meta object literal for the '{@link com.playertour.backend.igolf.model.igolf.impl.TeeDetailsImpl <em>Tee Details</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see com.playertour.backend.igolf.model.igolf.impl.TeeDetailsImpl
		 * @see com.playertour.backend.igolf.model.igolf.impl.IGolfPackageImpl#getTeeDetails()
		 * @generated
		 */
		EClass TEE_DETAILS = eINSTANCE.getTeeDetails();

		/**
		 * The meta object literal for the '<em><b>Gender</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TEE_DETAILS__GENDER = eINSTANCE.getTeeDetails_Gender();

		/**
		 * The meta object literal for the '<em><b>Rating Men</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TEE_DETAILS__RATING_MEN = eINSTANCE.getTeeDetails_RatingMen();

		/**
		 * The meta object literal for the '<em><b>Rating Women</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TEE_DETAILS__RATING_WOMEN = eINSTANCE.getTeeDetails_RatingWomen();

		/**
		 * The meta object literal for the '<em><b>Slope Men</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TEE_DETAILS__SLOPE_MEN = eINSTANCE.getTeeDetails_SlopeMen();

		/**
		 * The meta object literal for the '<em><b>Slope Women</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TEE_DETAILS__SLOPE_WOMEN = eINSTANCE.getTeeDetails_SlopeWomen();

		/**
		 * The meta object literal for the '<em><b>Tee Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TEE_DETAILS__TEE_NAME = eINSTANCE.getTeeDetails_TeeName();

		/**
		 * The meta object literal for the '<em><b>Tee Color Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TEE_DETAILS__TEE_COLOR_NAME = eINSTANCE.getTeeDetails_TeeColorName();

		/**
		 * The meta object literal for the '<em><b>Tee Color Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TEE_DETAILS__TEE_COLOR_VALUE = eINSTANCE.getTeeDetails_TeeColorValue();

		/**
		 * The meta object literal for the '<em><b>Yds Total</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TEE_DETAILS__YDS_TOTAL = eINSTANCE.getTeeDetails_YdsTotal();

		/**
		 * The meta object literal for the '<em><b>Yds1to9</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TEE_DETAILS__YDS1TO9 = eINSTANCE.getTeeDetails_Yds1to9();

		/**
		 * The meta object literal for the '<em><b>Yds10to18</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TEE_DETAILS__YDS10TO18 = eINSTANCE.getTeeDetails_Yds10to18();

		/**
		 * The meta object literal for the '<em><b>Yds1to18</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TEE_DETAILS__YDS1TO18 = eINSTANCE.getTeeDetails_Yds1to18();

		/**
		 * The meta object literal for the '<em><b>Yds Hole</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TEE_DETAILS__YDS_HOLE = eINSTANCE.getTeeDetails_YdsHole();

	}

} //IGolfPackage
