/**
 * Copyright (c) 2012 - 2022 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package com.playertour.backend.meritpoints.service.api;

import java.math.BigDecimal;

import org.javatuples.Pair;
import org.osgi.annotation.versioning.ProviderType;

import com.playertour.backend.meritpoints.model.meritpoints.MeritPointsAccount;
import com.playertour.backend.meritpoints.model.meritpoints.MeritPointsBalanceResult;

@ProviderType
public interface MeritPointsService {
	
	/**
	 * Deposits given amount of merit points to receiver's account.
	 * 
	 * @param receiverUserID
	 * @param amount
	 * @param description
	 * @return
	 */
	MeritPointsAccount deposit(String receiverUserID, BigDecimal amount, String description);

	/**
	 * Withdraws given amount of merit points from payee's account.
	 * 
	 * @param payeeUserID
	 * @param amount
	 * @param description
	 * @return
	 */
	MeritPointsAccount withdraw(String payeeUserID, BigDecimal amount, String description) throws MeritPointsAccountInsufficientBalanceException;

	/**
	 * Transfers given amount of merit points from payee's account to receiver's account.
	 * 
	 * @param payeeUserID
	 * @param receiverUserID
	 * @param amount
	 * @param payeeTransactionDescription
	 * @param receiverTransactionDescription
	 * @return
	 */
	Pair<MeritPointsAccount, MeritPointsAccount> transfer(String payeeUserID, String receiverUserID, BigDecimal amount,
			String payeeTransactionDescription, String receiverTransactionDescription);
	
	/**
	 * Transfers given amount of merit points from payee's account to receiver's account, take commission from both.
	 * 
	 * @param payeeUserID
	 * @param receiverUserID
	 * @param amount
	 * @param commission
	 * @param payeeTransactionDescription
	 * @param receiverTransactionDescription
	 * @return
	 */
	Pair<MeritPointsAccount, MeritPointsAccount> transferWithCommission(String payeeUserID, String receiverUserID, BigDecimal amount, double commission,
			String payeeTransactionDescription, String receiverTransactionDescription);

	/**
	 * Retrieves account balance.
	 * 
	 * @param userId
	 * @return
	 */
	BigDecimal getBalance(String userId);
	
	MeritPointsBalanceResult createMeritPointsBalanceResult(BigDecimal balance);

}
