/**
 * Copyright (c) 2012 - 2022 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package com.playertour.backend.meritpoints.service.impl;

import java.util.Collections;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field.Store;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.Term;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.gecko.search.api.IndexActionType;
import org.gecko.search.document.DocumentIndexContextObject;
import org.gecko.search.document.DocumentIndexContextObjectImpl;
import org.gecko.search.util.DeferredCommitCallback;
import org.osgi.util.promise.Deferred;

import com.playertour.backend.apis.common.LuceneIndexHelper;
import com.playertour.backend.meritpoints.model.meritpoints.MeritPointsAccount;
import com.playertour.backend.meritpoints.model.meritpoints.MeritPointsPackage;

class MeritPointsAccountIndexHelper {	
	static final String USER_ID_LOWER = "user_id_lower";

	static DocumentIndexContextObject mapAccountNew(MeritPointsAccount account) {
		return mapAccount(account, IndexActionType.ADD, null);
	}

	static DocumentIndexContextObject mapAccountNew(MeritPointsAccount account, Deferred<Boolean> deferred) {
		return mapAccount(account, IndexActionType.ADD, deferred);
	}

	static DocumentIndexContextObject mapAccountUpdate(MeritPointsAccount account, Deferred<Boolean> deferred) {
		return mapAccount(account, IndexActionType.MODIFY, deferred);
	}

	static DocumentIndexContextObject mapAccount(MeritPointsAccount account, IndexActionType indexAction,
			Deferred<Boolean> deferred) {

		Document doc = new Document();

		doc.add(new StringField(LuceneIndexHelper.FIELD__ECLASS_URI, constructEClassUri(), Store.YES));
		doc.add(new StringField(LuceneIndexHelper.FIELD__ID, account.getId(), Store.YES));

		if (account.getUserID() != null) {
			doc.add(new StringField(USER_ID_LOWER, account.getUserID().toLowerCase(), Store.NO));
		}

		DocumentIndexContextObjectImpl.Builder builder = DocumentIndexContextObjectImpl.builder()
				.withDocuments(Collections.singletonList(doc)).withSourceObject(account)
				.withIndexActionType(indexAction);

		if (IndexActionType.MODIFY.equals(indexAction) || IndexActionType.REMOVE.equals(indexAction)) {
			builder.withIdentifyingTerm(new Term("id", account.getId()));
		}
		if (deferred != null) {
			builder = builder.withCommitCallback(new DeferredCommitCallback(deferred));
		}

		return builder.build();
	}
	
	private static String constructEClassUri() {
		return EcoreUtil.getURI(MeritPointsPackage.Literals.MERIT_POINTS_ACCOUNT).toString();
	}
}
