/**
 * Copyright (c) 2012 - 2022 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package com.playertour.backend.notifications.firebasemessaging.service.api;

import java.util.List;
import java.util.Map;

import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface FirebaseMessagingService {
	
	static final String MESSAGE_DATA_KEY_TRIGGERED_ACTIONS = "actions";
	
	static final String MESSAGE_DATA_KEY_GOLFCOURSE_ID = "golfcourseId";
	
	static final String MESSAGE_DATA_KEY_CHALLENGE_ID = "challengeId";
	
	static final String MESSAGE_DATA_KEY_TIMESTAMP = "timeStamp";
	
	boolean saveToken(String loginId, String token);

	List<String> getTokens(String loginId);

	boolean deleteToken(String loginId, String token);

	boolean sendDataOnlyMessage(String loginId, Map<String, String> data);
	
	boolean sendNotificationOnlyMessage(String loginId, String title, String body);
	
	boolean sendNotificationWithDataMessage(String loginId, String title, String body, Map<String, String> data);
}
