/**
 * Copyright (c) 2012 - 2022 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package com.playertour.backend.notifications.omnichannel.service.api;

import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface OmniChannelNotificationService {

	void sendWelcomeNotification(String notificationId, String loginId, String playerName);

	void sendGolfCourseEnteredNotification(String notificationId, String loginId, String golfcourseId,
			String golfcourseName);

	void sendRoundOpenedNotification(String notificationId, String loginId, String golfcourseName);
	
	void sendRemindRoundOpenedNotification(String notificationId, String loginId, String golfcourseName);

	void sendRoundClosedNotification(String notificationId, String loginId, String golfcourseName, String closureDate);

	void sendRoundAutoClosedNotification(String notificationId, String loginId, String golfcourseName,
			String closureDate);

	void sendRoundAutoForceClosedNotification(String notificationId, String loginId, String golfcourseName,
			String closureDate);

	void sendRoundCancelledNotification(String notificationId, String loginId, String golfcourseName);

	void sendRoundAutoCancelledNotification(String notificationId, String loginId, String golfcourseName);

	void sendSuccessfulPurchaseNotification(String notificationId, String loginId, String meritpointsAmount);

	void sendBonusReceivedNotification(String notificationId, String loginId, String meritpointsAmount);

	void sendChallengeIssuedSelfNotification(String notificationId, String loginId, String playerName,
			String challengeId, String challengeDate);

	void sendChallengeIssuedOtherNotification(String notificationId, String loginId, String playerName,
			String challengeId, String challengeDate);

	void sendChallengeAcceptedSelfNotification(String notificationId, String loginId, String playerName,
			String challengeId, String challengeDate);

	void sendChallengeAcceptedOtherNotification(String notificationId, String loginId, String playerName,
			String challengeId, String challengeDate);

	void sendChallengeDeclinedSelfNotification(String notificationId, String loginId, String playerName,
			String challengeId, String challengeDate);

	void sendChallengeDeclinedOtherNotification(String notificationId, String loginId, String playerName,
			String challengeId, String challengeDate);

	void sendChallengeClosedSelfNotification(String notificationId, String loginId, String playerName,
			String challengeId, String challengeDate);

	void sendChallengeClosedOtherNotification(String notificationId, String loginId, String playerName,
			String challengeId, String challengeDate);

	void sendChallengeInviteSelfNotification(String notificationId, String loginId, String playerName,
			String challengeId, String challengeDate);

	void sendChallengeInviteOtherNotification(String notificationId, String loginId, String playerName,
			String challengeId, String challengeDate);

	void sendChallengeInviteAcceptedSelfNotification(String notificationId, String loginId, String playerName,
			String challengeId, String challengeDate);

	void sendChallengeInviteAcceptedOtherForNotification(String notificationId, String loginId, String playerName,
			String challengeId, String challengeDate);

	void sendChallengeInviteAcceptedOtherAgainstNotification(String notificationId, String loginId, String playerName,
			String challengeId, String challengeDate);

	void sendChallengeInviteDeclinedSelfNotification(String notificationId, String loginId, String playerName,
			String challengeId, String challengeDate);

	void sendChallengeInviteDeclinedOtherNotification(String notificationId, String loginId, String playerName,
			String challengeId, String challengeDate);

	void sendChallengeWonNotification(String notificationId, String loginId, String playerName, String challengeId,
			String challengeDate);

	void sendChallengeLostNotification(String notificationId, String loginId, String playerName, String challengeId,
			String challengeDate);

	void sendTournamentAnnouncementNotification(String notificationId, String loginId, String playerName,
			String tournamentName, String tournamentPlace, String tournamentDate, String tournamentSite);

	void sendScheduledMaintenanceNotification(String notificationId, String loginId, String playerName,
			String maintenanceDate);

	void sendLeaderboardRankUpNotification(String notificationId, String loginId, String rankNumber);

}
