/**
 * Copyright (c) 2012 - 2022 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package com.playertour.backend.notifications.omnichannel.service.impl.handlers;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceScope;
import org.osgi.service.component.annotations.ServiceScope;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.service.event.propertytypes.EventTopics;
import org.osgi.service.log.Logger;
import org.osgi.service.log.LoggerFactory;

import com.playertour.backend.notifications.omnichannel.service.api.OmniChannelNotificationService;
import com.playertour.backend.purchases.service.api.PurchasesEvents;

@Component(name = "SendNotificationOnBonusReceived", scope = ServiceScope.PROTOTYPE)
@EventTopics(value = { PurchasesEvents.TOPIC_BONUS })
public class SendNotificationOnBonusReceived implements EventHandler {

	@Reference(service = LoggerFactory.class)
	private Logger logger;	
	
	@Reference(scope = ReferenceScope.PROTOTYPE_REQUIRED)
	private OmniChannelNotificationService omniChannelNotificationService;	
	
	/* 
	 * (non-Javadoc)
	 * @see org.osgi.service.event.EventHandler#handleEvent(org.osgi.service.event.Event)
	 */
	@Override
	public void handleEvent(Event event) {
		logger.debug("Handling new event for topic: " + PurchasesEvents.TOPIC_BONUS);

		if (event.getProperty(PurchasesEvents.PROPERTY_KEY_EVENT_ID) != null
				&& event.getProperty(PurchasesEvents.PROPERTY_KEY_LOGIN_ID) != null
				&& event.getProperty(PurchasesEvents.PROPERTY_KEY_MERIT_POINTS) != null) {

			omniChannelNotificationService.sendBonusReceivedNotification(
					String.valueOf(event.getProperty(PurchasesEvents.PROPERTY_KEY_EVENT_ID)),
					String.valueOf(event.getProperty(PurchasesEvents.PROPERTY_KEY_LOGIN_ID)),
					String.valueOf(event.getProperty(PurchasesEvents.PROPERTY_KEY_MERIT_POINTS)));

		} else {
			if (event.getProperty(PurchasesEvents.PROPERTY_KEY_EVENT_ID) == null) {
				logger.error("Missing required property: " + PurchasesEvents.PROPERTY_KEY_EVENT_ID);
			}
			if (event.getProperty(PurchasesEvents.PROPERTY_KEY_LOGIN_ID) == null) {
				logger.error("Missing required property: " + PurchasesEvents.PROPERTY_KEY_LOGIN_ID);
			}
			if (event.getProperty(PurchasesEvents.PROPERTY_KEY_MERIT_POINTS) == null) {
				logger.error("Missing required property: " + PurchasesEvents.PROPERTY_KEY_MERIT_POINTS);
			}
		}
	}
}