/**
 * Copyright (c) 2012 - 2022 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package com.playertour.backend.notifications.omnichannel.service.impl.handlers;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceScope;
import org.osgi.service.component.annotations.ServiceScope;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.service.event.propertytypes.EventTopics;
import org.osgi.service.log.Logger;
import org.osgi.service.log.LoggerFactory;

import com.playertour.backend.apis.player.events.PlayerEvents;
import com.playertour.backend.notifications.omnichannel.service.api.OmniChannelNotificationService;

@Component(name = "SendNotificationOnFirstLogin", scope = ServiceScope.PROTOTYPE)
@EventTopics(value = { PlayerEvents.TOPIC_FIRST_LOGIN })
public class SendNotificationOnFirstLogin implements EventHandler {
	
	@Reference(service = LoggerFactory.class)
	private Logger logger;	
	
	@Reference(scope = ReferenceScope.PROTOTYPE_REQUIRED)
	private OmniChannelNotificationService omniChannelNotificationService;	

	/* 
	 * (non-Javadoc)
	 * @see org.osgi.service.event.EventHandler#handleEvent(org.osgi.service.event.Event)
	 */
	@Override
	public void handleEvent(Event event) {
		logger.debug("Handling new event for topic: " + PlayerEvents.TOPIC_FIRST_LOGIN);

		if (event.getProperty(PlayerEvents.PROPERTY_KEY_EVENT_ID) != null
				&& event.getProperty(PlayerEvents.PROPERTY_KEY_LOGIN_ID) != null
				&& event.getProperty(PlayerEvents.PROPERTY_KEY_LOGIN_NAME) != null) {

			omniChannelNotificationService.sendWelcomeNotification(
					String.valueOf(event.getProperty(PlayerEvents.PROPERTY_KEY_EVENT_ID)),
					String.valueOf(event.getProperty(PlayerEvents.PROPERTY_KEY_LOGIN_ID)),
					String.valueOf(event.getProperty(PlayerEvents.PROPERTY_KEY_LOGIN_NAME)));

		} else {
			if (event.getProperty(PlayerEvents.PROPERTY_KEY_EVENT_ID) == null) {
				logger.error("Missing required property: " + PlayerEvents.PROPERTY_KEY_EVENT_ID);
			}
			if (event.getProperty(PlayerEvents.PROPERTY_KEY_LOGIN_ID) == null) {
				logger.error("Missing required property: " + PlayerEvents.PROPERTY_KEY_LOGIN_ID);
			}
			if (event.getProperty(PlayerEvents.PROPERTY_KEY_LOGIN_NAME) == null) {
				logger.error("Missing required property: " + PlayerEvents.PROPERTY_KEY_LOGIN_NAME);
			}
		}
	}
}
