/**
 * Copyright (c) 2012 - 2021 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package com.playertour.backend.player.helper;

import java.util.Collections;

import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.gecko.search.api.IndexActionType;
import org.gecko.search.document.DocumentIndexContextObject;
import org.gecko.search.document.DocumentIndexContextObjectImpl;
import org.osgi.util.promise.Deferred;

import com.playertour.backend.apis.common.DeferredCommitCallback;
import com.playertour.backend.apis.common.DocumentUtil;
import com.playertour.backend.player.model.player.Player;

/**
 * 
 * @author ilenia
 * @since Mar 2, 2021
 */
public class PlayerIndexHelper {
	
	public static DocumentIndexContextObject mapPlayerNew(Player player) {
		return mapPlayer(player, IndexActionType.ADD, null);
	}

	public static DocumentIndexContextObject mapPlayerNew(Player player, Deferred<Boolean> deferred) {
		return mapPlayer(player, IndexActionType.ADD, deferred);
	}

	public static DocumentIndexContextObject mapPlayerUpdate(Player player, Deferred<Boolean> deferred) {
		return mapPlayer(player, IndexActionType.MODIFY, deferred);
	}

	public static DocumentIndexContextObject mapPlayer(Player player, IndexActionType indexAction, Deferred<Boolean> deferred) {
		Document doc = new Document();
		
		DocumentUtil.toDocument(doc, player, true);

		DocumentIndexContextObjectImpl.Builder builder = DocumentIndexContextObjectImpl.builder()
				.withDocuments(Collections.singletonList(doc))
				.withSourceObject(player).withIndexActionType(indexAction);

		if(IndexActionType.MODIFY.equals(indexAction) || IndexActionType.REMOVE.equals(indexAction)) {
			builder.withIdentifyingTerm(new Term("id", player.getId()));
		}
		if(deferred != null) {
			builder = builder.withCommitCallback(new DeferredCommitCallback(deferred));
		}

		return builder.build();
	}

}
