/**
 * Copyright (c) 2012 - 2022 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package com.playertour.backend.possiblecheats.service.api;

import java.util.List;

import org.osgi.annotation.versioning.ProviderType;

import com.playertour.backend.possiblecheats.model.possiblecheats.PossibleCheatReport;
import com.playertour.backend.possiblecheats.model.possiblecheats.PossibleCheatReportStatus;
import com.playertour.backend.possiblecheats.model.possiblecheats.PossibleCheatReportType;

@ProviderType
public interface PossibleCheatsReportingSearchService {

	List<PossibleCheatReport> searchPossibleCheatsByPlayerLoginId(String loginId);

	List<PossibleCheatReport> searchPossibleCheatsByPlayerLoginIdWithStatus(String loginId, PossibleCheatReportStatus status);

	List<PossibleCheatReport> searchPossibleCheatsByPlayerLoginIdWithType(String loginId, PossibleCheatReportType type);

	List<PossibleCheatReport> searchPossibleCheatsByPlayerLoginIdWithStatusAndType(String loginId, PossibleCheatReportStatus status,
			PossibleCheatReportType type);

	List<PossibleCheatReport> searchPossibleCheatsByScorecardId(String scorecardId);

	List<PossibleCheatReport> searchPossibleCheatsByScorecardIdWithStatus(String scorecardId,
			PossibleCheatReportStatus status);

	List<PossibleCheatReport> searchPossibleCheatsByScorecardIdWithType(String scorecardId, PossibleCheatReportType type);

	List<PossibleCheatReport> searchPossibleCheatsByScorecardIdWithStatusAndType(String scorecardId,
			PossibleCheatReportStatus status, PossibleCheatReportType type);
}
