/**
 * Copyright (c) 2012 - 2022 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package com.playertour.backend.possiblecheats.service.impl.events.handlers;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceScope;
import org.osgi.service.component.annotations.ServiceScope;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventConstants;
import org.osgi.service.event.EventHandler;
import org.osgi.service.event.propertytypes.EventDelivery;
import org.osgi.service.event.propertytypes.EventTopics;
import org.osgi.service.log.Logger;
import org.osgi.service.log.LoggerFactory;

import com.playertour.backend.apis.player.events.PlayerScorecardEvents;
import com.playertour.backend.possiblecheats.service.api.PossibleCheatsReportingService;

@Component(name = "CheckForPossibleCheatsOnScorecardClose", scope = ServiceScope.PROTOTYPE)
@EventTopics(value = { 
		PlayerScorecardEvents.TOPIC_ROUND_CLOSED, 
		PlayerScorecardEvents.TOPIC_ROUND_AUTO_CLOSED,
		PlayerScorecardEvents.TOPIC_ROUND_AUTO_FORCE_CLOSED })
@EventDelivery(EventConstants.DELIVERY_ASYNC_ORDERED)
public class CheckForPossibleCheatsOnScorecardClose implements EventHandler {

	@Reference(service = LoggerFactory.class)
	private Logger logger;	
	
	@Reference(scope = ReferenceScope.PROTOTYPE_REQUIRED)
	private PossibleCheatsReportingService possibleCheatsReportingService;
	
	@Reference
	private EventAdmin eventAdmin;
	
	/* 
	 * (non-Javadoc)
	 * @see org.osgi.service.event.EventHandler#handleEvent(org.osgi.service.event.Event)
	 */
	@Override
	public void handleEvent(Event event) {
		logger.debug("Handling new event for topic: " + event.getTopic());

		if (event.getProperty(PlayerScorecardEvents.PROPERTY_KEY_EVENT_ID) != null
				&& event.getProperty(PlayerScorecardEvents.PROPERTY_KEY_LOGIN_ID) != null
				&& event.getProperty(PlayerScorecardEvents.PROPERTY_KEY_SCORECARD_ID) != null) {

			logger.info("Checking scorecard ID " + event.getProperty(PlayerScorecardEvents.PROPERTY_KEY_SCORECARD_ID)
					+ " for possible cheats...");

			possibleCheatsReportingService.detectPossibleCheats(
					String.valueOf(event.getProperty(PlayerScorecardEvents.PROPERTY_KEY_LOGIN_ID)),
					String.valueOf(event.getProperty(PlayerScorecardEvents.PROPERTY_KEY_SCORECARD_ID)));

		} else {
			if (event.getProperty(PlayerScorecardEvents.PROPERTY_KEY_EVENT_ID) == null) {
				logger.error("Missing required property: " + PlayerScorecardEvents.PROPERTY_KEY_EVENT_ID);
			}
			if (event.getProperty(PlayerScorecardEvents.PROPERTY_KEY_LOGIN_ID) == null) {
				logger.error("Missing required property: " + PlayerScorecardEvents.PROPERTY_KEY_LOGIN_ID);
			}
			if (event.getProperty(PlayerScorecardEvents.PROPERTY_KEY_SCORECARD_ID) == null) {
				logger.error("Missing required property: " + PlayerScorecardEvents.PROPERTY_KEY_SCORECARD_ID);
			}
			if (event.getProperty(PlayerScorecardEvents.PROPERTY_KEY_GOLFCOURSE_NAME) == null) {
				logger.error("Missing required property: " + PlayerScorecardEvents.PROPERTY_KEY_GOLFCOURSE_NAME);
			}
		}
	}
}