/**
 * Copyright (c) 2012 - 2022 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package com.playertour.backend.possiblecheats.service.tests.helper;

import static org.assertj.core.api.Assertions.assertThat;

import java.util.List;

import com.playertour.backend.api.HoleScore;
import com.playertour.backend.api.LandingZone;
import com.playertour.backend.api.PlayerApiFactory;
import com.playertour.backend.api.PlayerScorecard;
import com.playertour.backend.api.Stroke;
import com.playertour.backend.apis.player.PlayerScorecardService;
import com.playertour.backend.golfcourse.model.golfcourse.CourseDetails;
import com.playertour.backend.golfcourse.model.golfcourse.CourseScorecardInfo;
import com.playertour.backend.golfcourse.model.golfcourse.CourseScorecards;
import com.playertour.backend.golfcourse.model.golfcourse.GenderType;
import com.playertour.backend.golfcourse.model.golfcourse.GolfCourse;
import com.playertour.backend.golfcourse.model.golfcourse.GolfCourseFactory;
import com.playertour.backend.golfcourse.model.golfcourse.Tee;
import com.playertour.backend.possiblecheats.model.possiblecheats.PossibleCheatReport;
import com.playertour.backend.possiblecheats.model.possiblecheats.PossibleCheatReportStatus;
import com.playertour.backend.possiblecheats.model.possiblecheats.PossibleCheatReportType;
import com.playertour.backend.possiblecheats.model.possiblecheats.PossibleCheatsFactory;

public class PossibleCheatsReportingTestHelper {

	public static PossibleCheatReport constructPossibleCheatReport(String userID, String scorecardID,
			PossibleCheatReportStatus status, PossibleCheatReportType type, String details, long timeStamp) {
		PossibleCheatReport possibleCheatReport = PossibleCheatsFactory.eINSTANCE.createPossibleCheatReport();
		possibleCheatReport.setUserID(userID);
		possibleCheatReport.setScorecardID(scorecardID);
		possibleCheatReport.setStatus(status);
		possibleCheatReport.setType(type);
		possibleCheatReport.setDetails(details);
		possibleCheatReport.setTimeStamp(timeStamp);
		return possibleCheatReport;
	}

	public static GolfCourse constructGolfCourse(String courseId, GenderType gender) {
		CourseScorecardInfo scorecardInfo = GolfCourseFactory.eINSTANCE.createCourseScorecardInfo();
		scorecardInfo.setParIn(37);
		scorecardInfo.setParOut(35);
		scorecardInfo.setParTotal(72);
		scorecardInfo.getHcpHole().addAll(List.of(9, 11, 15, 1, 3, 13, 17, 5, 7, 6, 14, 18, 4, 8, 16, 2, 10, 12));
		scorecardInfo.getParHole().addAll(List.of(4, 4, 3, 5, 4, 4, 3, 4, 4, 5, 5, 4, 4, 4, 3, 5, 3, 4));

		CourseScorecards courseScorecards = GolfCourseFactory.eINSTANCE.createCourseScorecards();
		courseScorecards.getMenScorecard().add(scorecardInfo);
		// courseScorecards.getWmnScorecard().add(scorecardInfo); // FIXME: adding
		// 'CourseScorecardInfo' to 'wmnScorecard' list somehow erases
		// 'CourseScorecardInfo' from 'menScorecard' list

		com.playertour.backend.golfcourse.model.golfcourse.GolfCourse golfCourse = GolfCourseFactory.eINSTANCE
				.createGolfCourse();
		golfCourse.setId(courseId);
		golfCourse.setCourseId(courseId);
		golfCourse.setScorecards(courseScorecards);

		int holesTotal = scorecardInfo.getParHole().size();

		Tee tee = GolfCourseFactory.eINSTANCE.createTee();
		tee.setColor("Yellow");
		tee.setGender(gender);
		golfCourse.getTee().add(tee);

		CourseDetails courseDetails = GolfCourseFactory.eINSTANCE.createCourseDetails();
		courseDetails.setCourseName("Golfclub Gera e.V.");
		courseDetails.setHoleNum(holesTotal);

		golfCourse.setCourseDetails(courseDetails);

		return golfCourse;
	}

	public static PlayerScorecard generateStrokes(String loginId, String playerScorecardId,
			PlayerScorecard playerScorecard, PlayerScorecardService playerScorecardService)
			throws InterruptedException {
		int holesTotal = playerScorecard.getHoleStats().size();

		for (int i = 0; i < holesTotal; i++) {
			int holeNumber = (i + 1);

			boolean hasExtraFirstStroke = false;

			if (holeNumber % 9 == 0) {
				Stroke stroke = generateStroke(holeNumber, LandingZone.ROUGH);

				playerScorecard = playerScorecardService.submitStroke(loginId, playerScorecardId, stroke);
				assertThat(playerScorecard).isNotNull();
				assertThat(playerScorecard.getHoleStats()).isNotEmpty();

				hasExtraFirstStroke = true;

				Thread.sleep(250);
			}

			LandingZone landingZone;
			if (holeNumber % 2 == 0) {
				landingZone = LandingZone.FAIRWAY;
			} else {
				landingZone = LandingZone.GREEN;
			}

			Stroke stroke = generateStroke(holeNumber, landingZone);

			playerScorecard = playerScorecardService.submitStroke(loginId, playerScorecardId, stroke);
			assertThat(playerScorecard).isNotNull();
			assertThat(playerScorecard.getHoleStats()).isNotEmpty();

			HoleScore holeScore = playerScorecard.getHoleStats().get(i);
			assertThat(holeScore.getStrokes()).isNotEmpty();
			assertThat(holeScore.getStrokes().get(0).getHoleNumber()).isEqualTo(holeNumber);
			if (hasExtraFirstStroke) {
				assertThat(holeScore.getStrokes()).hasSize(2);
				assertThat(holeScore.getStrokes().get(0).getZone()).isEqualTo(LandingZone.ROUGH);
				assertThat(holeScore.getStrokes().get(1).getZone()).isEqualTo(landingZone);

				assertThat(holeScore.getScore()).isEqualTo(2);
				assertThat(holeScore.getPTScore()).isEqualTo(2);
			} else {
				assertThat(holeScore.getStrokes()).hasSize(1);
				assertThat(holeScore.getStrokes().get(0).getZone()).isEqualTo(landingZone);

				assertThat(holeScore.getScore()).isEqualTo(1);
				assertThat(holeScore.getPTScore()).isEqualTo(1);
			}

			Thread.sleep(250);
		}

		return playerScorecard;
	}

	private static Stroke generateStroke(int holeNumber, LandingZone landingZone) {
		Stroke stroke = PlayerApiFactory.eINSTANCE.createStroke();
		stroke.setHoleNumber(holeNumber);
		stroke.setZone(landingZone);
		return stroke;
	}
}
