/**
 */
package com.playertour.backend.purchases.model.purchases.impl;

import com.playertour.backend.purchases.model.purchases.InAppProductSource;
import com.playertour.backend.purchases.model.purchases.NonSubscriptionStatus;
import com.playertour.backend.purchases.model.purchases.Purchase;
import com.playertour.backend.purchases.model.purchases.PurchasePromotion;
import com.playertour.backend.purchases.model.purchases.PurchaseReceipt;
import com.playertour.backend.purchases.model.purchases.PurchaseType;
import com.playertour.backend.purchases.model.purchases.PurchasesPackage;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Purchase</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link com.playertour.backend.purchases.model.purchases.impl.PurchaseImpl#getId <em>Id</em>}</li>
 *   <li>{@link com.playertour.backend.purchases.model.purchases.impl.PurchaseImpl#getSource <em>Source</em>}</li>
 *   <li>{@link com.playertour.backend.purchases.model.purchases.impl.PurchaseImpl#getOrderID <em>Order ID</em>}</li>
 *   <li>{@link com.playertour.backend.purchases.model.purchases.impl.PurchaseImpl#getType <em>Type</em>}</li>
 *   <li>{@link com.playertour.backend.purchases.model.purchases.impl.PurchaseImpl#getProductID <em>Product ID</em>}</li>
 *   <li>{@link com.playertour.backend.purchases.model.purchases.impl.PurchaseImpl#getUserID <em>User ID</em>}</li>
 *   <li>{@link com.playertour.backend.purchases.model.purchases.impl.PurchaseImpl#getReceipt <em>Receipt</em>}</li>
 *   <li>{@link com.playertour.backend.purchases.model.purchases.impl.PurchaseImpl#getStatus <em>Status</em>}</li>
 *   <li>{@link com.playertour.backend.purchases.model.purchases.impl.PurchaseImpl#getPromotion <em>Promotion</em>}</li>
 *   <li>{@link com.playertour.backend.purchases.model.purchases.impl.PurchaseImpl#getPurchaseDateTime <em>Purchase Date Time</em>}</li>
 * </ul>
 *
 * @generated
 */
public class PurchaseImpl extends MinimalEObjectImpl.Container implements Purchase {
	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected String id = ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getSource() <em>Source</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSource()
	 * @generated
	 * @ordered
	 */
	protected static final InAppProductSource SOURCE_EDEFAULT = InAppProductSource.UNKNOWN;

	/**
	 * The cached value of the '{@link #getSource() <em>Source</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSource()
	 * @generated
	 * @ordered
	 */
	protected InAppProductSource source = SOURCE_EDEFAULT;

	/**
	 * The default value of the '{@link #getOrderID() <em>Order ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOrderID()
	 * @generated
	 * @ordered
	 */
	protected static final String ORDER_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getOrderID() <em>Order ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOrderID()
	 * @generated
	 * @ordered
	 */
	protected String orderID = ORDER_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected static final PurchaseType TYPE_EDEFAULT = PurchaseType.NON_SUBSCRIPTION;

	/**
	 * The cached value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected PurchaseType type = TYPE_EDEFAULT;

	/**
	 * The default value of the '{@link #getProductID() <em>Product ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProductID()
	 * @generated
	 * @ordered
	 */
	protected static final String PRODUCT_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getProductID() <em>Product ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProductID()
	 * @generated
	 * @ordered
	 */
	protected String productID = PRODUCT_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getUserID() <em>User ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUserID()
	 * @generated
	 * @ordered
	 */
	protected static final String USER_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getUserID() <em>User ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUserID()
	 * @generated
	 * @ordered
	 */
	protected String userID = USER_ID_EDEFAULT;

	/**
	 * The cached value of the '{@link #getReceipt() <em>Receipt</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReceipt()
	 * @generated
	 * @ordered
	 */
	protected PurchaseReceipt receipt;

	/**
	 * The default value of the '{@link #getStatus() <em>Status</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStatus()
	 * @generated
	 * @ordered
	 */
	protected static final NonSubscriptionStatus STATUS_EDEFAULT = NonSubscriptionStatus.PENDING;

	/**
	 * The cached value of the '{@link #getStatus() <em>Status</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStatus()
	 * @generated
	 * @ordered
	 */
	protected NonSubscriptionStatus status = STATUS_EDEFAULT;

	/**
	 * The cached value of the '{@link #getPromotion() <em>Promotion</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPromotion()
	 * @generated
	 * @ordered
	 */
	protected PurchasePromotion promotion;

	/**
	 * The default value of the '{@link #getPurchaseDateTime() <em>Purchase Date Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPurchaseDateTime()
	 * @generated
	 * @ordered
	 */
	protected static final long PURCHASE_DATE_TIME_EDEFAULT = 0L;

	/**
	 * The cached value of the '{@link #getPurchaseDateTime() <em>Purchase Date Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPurchaseDateTime()
	 * @generated
	 * @ordered
	 */
	protected long purchaseDateTime = PURCHASE_DATE_TIME_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PurchaseImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return PurchasesPackage.Literals.PURCHASE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getId() {
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setId(String newId) {
		String oldId = id;
		id = newId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, PurchasesPackage.PURCHASE__ID, oldId, id));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public InAppProductSource getSource() {
		return source;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSource(InAppProductSource newSource) {
		InAppProductSource oldSource = source;
		source = newSource == null ? SOURCE_EDEFAULT : newSource;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, PurchasesPackage.PURCHASE__SOURCE, oldSource, source));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getOrderID() {
		return orderID;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setOrderID(String newOrderID) {
		String oldOrderID = orderID;
		orderID = newOrderID;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, PurchasesPackage.PURCHASE__ORDER_ID, oldOrderID, orderID));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public PurchaseType getType() {
		return type;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setType(PurchaseType newType) {
		PurchaseType oldType = type;
		type = newType == null ? TYPE_EDEFAULT : newType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, PurchasesPackage.PURCHASE__TYPE, oldType, type));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getProductID() {
		return productID;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setProductID(String newProductID) {
		String oldProductID = productID;
		productID = newProductID;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, PurchasesPackage.PURCHASE__PRODUCT_ID, oldProductID, productID));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getUserID() {
		return userID;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setUserID(String newUserID) {
		String oldUserID = userID;
		userID = newUserID;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, PurchasesPackage.PURCHASE__USER_ID, oldUserID, userID));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public PurchaseReceipt getReceipt() {
		return receipt;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetReceipt(PurchaseReceipt newReceipt, NotificationChain msgs) {
		PurchaseReceipt oldReceipt = receipt;
		receipt = newReceipt;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, PurchasesPackage.PURCHASE__RECEIPT, oldReceipt, newReceipt);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setReceipt(PurchaseReceipt newReceipt) {
		if (newReceipt != receipt) {
			NotificationChain msgs = null;
			if (receipt != null)
				msgs = ((InternalEObject)receipt).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - PurchasesPackage.PURCHASE__RECEIPT, null, msgs);
			if (newReceipt != null)
				msgs = ((InternalEObject)newReceipt).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - PurchasesPackage.PURCHASE__RECEIPT, null, msgs);
			msgs = basicSetReceipt(newReceipt, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, PurchasesPackage.PURCHASE__RECEIPT, newReceipt, newReceipt));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NonSubscriptionStatus getStatus() {
		return status;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setStatus(NonSubscriptionStatus newStatus) {
		NonSubscriptionStatus oldStatus = status;
		status = newStatus == null ? STATUS_EDEFAULT : newStatus;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, PurchasesPackage.PURCHASE__STATUS, oldStatus, status));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public PurchasePromotion getPromotion() {
		return promotion;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetPromotion(PurchasePromotion newPromotion, NotificationChain msgs) {
		PurchasePromotion oldPromotion = promotion;
		promotion = newPromotion;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, PurchasesPackage.PURCHASE__PROMOTION, oldPromotion, newPromotion);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setPromotion(PurchasePromotion newPromotion) {
		if (newPromotion != promotion) {
			NotificationChain msgs = null;
			if (promotion != null)
				msgs = ((InternalEObject)promotion).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - PurchasesPackage.PURCHASE__PROMOTION, null, msgs);
			if (newPromotion != null)
				msgs = ((InternalEObject)newPromotion).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - PurchasesPackage.PURCHASE__PROMOTION, null, msgs);
			msgs = basicSetPromotion(newPromotion, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, PurchasesPackage.PURCHASE__PROMOTION, newPromotion, newPromotion));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public long getPurchaseDateTime() {
		return purchaseDateTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setPurchaseDateTime(long newPurchaseDateTime) {
		long oldPurchaseDateTime = purchaseDateTime;
		purchaseDateTime = newPurchaseDateTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, PurchasesPackage.PURCHASE__PURCHASE_DATE_TIME, oldPurchaseDateTime, purchaseDateTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case PurchasesPackage.PURCHASE__RECEIPT:
				return basicSetReceipt(null, msgs);
			case PurchasesPackage.PURCHASE__PROMOTION:
				return basicSetPromotion(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case PurchasesPackage.PURCHASE__ID:
				return getId();
			case PurchasesPackage.PURCHASE__SOURCE:
				return getSource();
			case PurchasesPackage.PURCHASE__ORDER_ID:
				return getOrderID();
			case PurchasesPackage.PURCHASE__TYPE:
				return getType();
			case PurchasesPackage.PURCHASE__PRODUCT_ID:
				return getProductID();
			case PurchasesPackage.PURCHASE__USER_ID:
				return getUserID();
			case PurchasesPackage.PURCHASE__RECEIPT:
				return getReceipt();
			case PurchasesPackage.PURCHASE__STATUS:
				return getStatus();
			case PurchasesPackage.PURCHASE__PROMOTION:
				return getPromotion();
			case PurchasesPackage.PURCHASE__PURCHASE_DATE_TIME:
				return getPurchaseDateTime();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case PurchasesPackage.PURCHASE__ID:
				setId((String)newValue);
				return;
			case PurchasesPackage.PURCHASE__SOURCE:
				setSource((InAppProductSource)newValue);
				return;
			case PurchasesPackage.PURCHASE__ORDER_ID:
				setOrderID((String)newValue);
				return;
			case PurchasesPackage.PURCHASE__TYPE:
				setType((PurchaseType)newValue);
				return;
			case PurchasesPackage.PURCHASE__PRODUCT_ID:
				setProductID((String)newValue);
				return;
			case PurchasesPackage.PURCHASE__USER_ID:
				setUserID((String)newValue);
				return;
			case PurchasesPackage.PURCHASE__RECEIPT:
				setReceipt((PurchaseReceipt)newValue);
				return;
			case PurchasesPackage.PURCHASE__STATUS:
				setStatus((NonSubscriptionStatus)newValue);
				return;
			case PurchasesPackage.PURCHASE__PROMOTION:
				setPromotion((PurchasePromotion)newValue);
				return;
			case PurchasesPackage.PURCHASE__PURCHASE_DATE_TIME:
				setPurchaseDateTime((Long)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case PurchasesPackage.PURCHASE__ID:
				setId(ID_EDEFAULT);
				return;
			case PurchasesPackage.PURCHASE__SOURCE:
				setSource(SOURCE_EDEFAULT);
				return;
			case PurchasesPackage.PURCHASE__ORDER_ID:
				setOrderID(ORDER_ID_EDEFAULT);
				return;
			case PurchasesPackage.PURCHASE__TYPE:
				setType(TYPE_EDEFAULT);
				return;
			case PurchasesPackage.PURCHASE__PRODUCT_ID:
				setProductID(PRODUCT_ID_EDEFAULT);
				return;
			case PurchasesPackage.PURCHASE__USER_ID:
				setUserID(USER_ID_EDEFAULT);
				return;
			case PurchasesPackage.PURCHASE__RECEIPT:
				setReceipt((PurchaseReceipt)null);
				return;
			case PurchasesPackage.PURCHASE__STATUS:
				setStatus(STATUS_EDEFAULT);
				return;
			case PurchasesPackage.PURCHASE__PROMOTION:
				setPromotion((PurchasePromotion)null);
				return;
			case PurchasesPackage.PURCHASE__PURCHASE_DATE_TIME:
				setPurchaseDateTime(PURCHASE_DATE_TIME_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case PurchasesPackage.PURCHASE__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case PurchasesPackage.PURCHASE__SOURCE:
				return source != SOURCE_EDEFAULT;
			case PurchasesPackage.PURCHASE__ORDER_ID:
				return ORDER_ID_EDEFAULT == null ? orderID != null : !ORDER_ID_EDEFAULT.equals(orderID);
			case PurchasesPackage.PURCHASE__TYPE:
				return type != TYPE_EDEFAULT;
			case PurchasesPackage.PURCHASE__PRODUCT_ID:
				return PRODUCT_ID_EDEFAULT == null ? productID != null : !PRODUCT_ID_EDEFAULT.equals(productID);
			case PurchasesPackage.PURCHASE__USER_ID:
				return USER_ID_EDEFAULT == null ? userID != null : !USER_ID_EDEFAULT.equals(userID);
			case PurchasesPackage.PURCHASE__RECEIPT:
				return receipt != null;
			case PurchasesPackage.PURCHASE__STATUS:
				return status != STATUS_EDEFAULT;
			case PurchasesPackage.PURCHASE__PROMOTION:
				return promotion != null;
			case PurchasesPackage.PURCHASE__PURCHASE_DATE_TIME:
				return purchaseDateTime != PURCHASE_DATE_TIME_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (id: ");
		result.append(id);
		result.append(", source: ");
		result.append(source);
		result.append(", orderID: ");
		result.append(orderID);
		result.append(", type: ");
		result.append(type);
		result.append(", productID: ");
		result.append(productID);
		result.append(", userID: ");
		result.append(userID);
		result.append(", status: ");
		result.append(status);
		result.append(", purchaseDateTime: ");
		result.append(purchaseDateTime);
		result.append(')');
		return result.toString();
	}

} //PurchaseImpl
