/**
 * Copyright (c) 2012 - 2022 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package com.playertour.backend.purchases.service.api;

import java.util.List;
import java.util.Optional;

import org.osgi.annotation.versioning.ProviderType;

import com.playertour.backend.purchases.model.purchases.Purchase;

@ProviderType
public interface PurchasesPurchaseService {

	Purchase saveOrUpdatePurchase(Purchase iap);

	List<Purchase> getPurchases(String userId, Optional<Integer> maxResultsOptional);

	boolean purchaseExists(String orderID);

	Purchase getPurchase(String orderID);

}

