/**
 * Copyright (c) 2012 - 2018 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package com.playertour.backend.purchases.service.api;

import java.util.Optional;

import org.osgi.annotation.versioning.ProviderType;

import com.playertour.backend.purchases.model.purchases.InAppProductsIDs;
import com.playertour.backend.purchases.model.purchases.Purchase;
import com.playertour.backend.purchases.model.purchases.PurchaseHistory;
import com.playertour.backend.purchases.model.purchases.PurchaseReceiptVerificationStatus;

@ProviderType
public interface PurchasesService {

	InAppProductsIDs getInAppProductIDs();

	boolean inAppProductExists(String productID);
	
	PurchaseReceiptVerificationStatus verifyPurchaseReceipt(String userId, Purchase purchase);
	
	Purchase savePurchase(String userId, Purchase purchase);

	PurchaseHistory getPurchaseHistory(String userId, Optional<Integer> maxResultsOptional);
}
