/**
 * Copyright (c) 2012 - 2022 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package com.playertour.backend.purchases.service.api;

import com.playertour.backend.apis.events.PlayerTourEvents;

public interface PurchasesEvents {
	
	static final String TOPIC_BASE = PlayerTourEvents.TOPIC_BASE + "PurchaseEvent/";
	
	static final String TOPIC_COMPLETED = PurchasesEvents.TOPIC_BASE + "COMPLETED";
	
	static final String TOPIC_VERIFIED = PurchasesEvents.TOPIC_BASE + "VERIFIED";
	
	static final String TOPIC_BONUS = PurchasesEvents.TOPIC_BASE + "BONUS";
	
	static final String TOPIC_ALL = PurchasesEvents.TOPIC_BASE + "*";
	
	static final String PROPERTY_KEY_EVENT_ID = PlayerTourEvents.PROPERTY_KEY_EVENT_ID;
	
	static final String PROPERTY_KEY_LOGIN_ID = PlayerTourEvents.PROPERTY_KEY_LOGIN_ID;
	
	static final String PROPERTY_KEY_MERIT_POINTS = "meritPoints";
	
	static final String PROPERTY_KEY_PRODUCT_ID = "productID";
	
	static final String PROPERTY_KEY_ORDER_ID = "orderID";
	
}
