/**
 * Copyright (c) 2012 - 2022 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package com.playertour.backend.purchases.service.api;

import org.osgi.annotation.versioning.ProviderType;

import com.playertour.backend.purchases.model.purchases.PurchaseReceiptVerificationStatus;
import com.playertour.backend.purchases.model.purchases.PurchaseType;

@ProviderType
public interface PurchasesPurchaseVerificationService {

	default PurchaseReceiptVerificationStatus verifyPurchaseReceipt(PurchaseType purchaseType, String productID, String token) {

		switch (purchaseType) {
		case NON_SUBSCRIPTION:
			return verifyNonSubscriptionPurchaseReceipt(productID, token);
		case SUBSCRIPTION:
			return verifySubscriptionPurchaseReceipt(productID, token);
		default:
			throw new IllegalArgumentException("Either non-subscription or subscription IAP type is required!");
		}
	}

	PurchaseReceiptVerificationStatus verifyNonSubscriptionPurchaseReceipt(String productID, String token);

	PurchaseReceiptVerificationStatus verifySubscriptionPurchaseReceipt(String productID, String token);

}
