/**
 * Copyright (c) 2012 - 2022 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package com.playertour.backend.purchases.service.impl.events.publishers;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventProperties;
import org.osgi.util.promise.PromiseFactory;

import com.playertour.backend.purchases.service.api.PurchasesEvents;

public class PurchaseEventPublisher {
	
	private static final long DELAY = 4000;
	private static final TimeUnit DELAY_UNIT = TimeUnit.MILLISECONDS;
	
	public static void publishPurchaseVerifiedEvent(EventAdmin eventAdmin, String loginId, String productID, String orderID) {
		Map<String, Object> properties = new HashMap<String, Object>();
		properties.put(PurchasesEvents.PROPERTY_KEY_EVENT_ID, UUID.randomUUID().toString());
		properties.put(PurchasesEvents.PROPERTY_KEY_LOGIN_ID, loginId);
		properties.put(PurchasesEvents.PROPERTY_KEY_PRODUCT_ID, productID);
		properties.put(PurchasesEvents.PROPERTY_KEY_ORDER_ID, orderID);
		
		EventProperties eventProperties = new EventProperties(properties);
		
		eventAdmin.postEvent(new Event(PurchasesEvents.TOPIC_VERIFIED, eventProperties));			
	}	
	
	public static void publishPurchaseCompletedEvent(EventAdmin eventAdmin, String loginId, String productID, String orderID, int meritPoints) {
		Map<String, Object> properties = new HashMap<String, Object>();
		properties.put(PurchasesEvents.PROPERTY_KEY_EVENT_ID, UUID.randomUUID().toString());
		properties.put(PurchasesEvents.PROPERTY_KEY_LOGIN_ID, loginId);
		properties.put(PurchasesEvents.PROPERTY_KEY_PRODUCT_ID, productID);
		properties.put(PurchasesEvents.PROPERTY_KEY_ORDER_ID, orderID);
		properties.put(PurchasesEvents.PROPERTY_KEY_MERIT_POINTS, meritPoints);
		
		EventProperties eventProperties = new EventProperties(properties);
		
		eventAdmin.postEvent(new Event(PurchasesEvents.TOPIC_COMPLETED, eventProperties));		
	}
	
	public static void publishBonusReceivedEvent(EventAdmin eventAdmin, String loginId, String productID, String orderID, int meritPoints) {
		Map<String, Object> properties = new HashMap<String, Object>();
		properties.put(PurchasesEvents.PROPERTY_KEY_EVENT_ID, UUID.randomUUID().toString());
		properties.put(PurchasesEvents.PROPERTY_KEY_LOGIN_ID, loginId);
		properties.put(PurchasesEvents.PROPERTY_KEY_PRODUCT_ID, productID);
		properties.put(PurchasesEvents.PROPERTY_KEY_ORDER_ID, orderID);
		properties.put(PurchasesEvents.PROPERTY_KEY_MERIT_POINTS, meritPoints);
		
		EventProperties eventProperties = new EventProperties(properties);
		
		// this event must be published with delay so its processing (e.g. notifications sent out) is visibly AFTER processing of purchase completed event
		PromiseFactory factory = new PromiseFactory(Executors.newSingleThreadExecutor(), 
				Executors.newSingleThreadScheduledExecutor());
		
		factory.scheduledExecutor().schedule(
                () -> factory.executor()
                .execute(() -> eventAdmin.postEvent(new Event(PurchasesEvents.TOPIC_BONUS, eventProperties))),
                DELAY, DELAY_UNIT);		
	}	
	
}
