/**
 * Copyright (c) 2012 - 2021 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package com.playertour.backend.rest.api;

import javax.ws.rs.core.Application;

import org.gecko.emf.osgi.json.annotation.RequireEMFJson;
import org.gecko.emf.osgi.rest.jaxrs.annotation.RequireEMFMessageBodyReaderWriter;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsApplicationBase;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsName;

import com.playertour.backend.rest.api.constants.ApiConstants;

import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.info.Info;

/**
 * 
 * @author Juergen Albert
 * @since 26 Jan 2021
 */
@JaxrsApplicationBase(ApiConstants.VERSION)
@JaxrsName("PlayerRestApplication")
@Component(service = Application.class, property = "emf=true")
@RequireEMFJson
@RequireEMFMessageBodyReaderWriter
@OpenAPIDefinition(info = @Info(title = "Playertour API", version = ApiConstants.VERSION))
public class PlayerApplication extends Application {

}
