/**
import org.osgi.service.jaxrs.whiteboard.annotations.RequireJaxrsWhiteboard; * Copyright (c) 2012 - 2018 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package com.playertour.backend.rest.api.user;

import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.gecko.emf.osgi.rest.jaxrs.annotation.json.RootElement;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;
import org.osgi.service.http.whiteboard.annotations.RequireHttpWhiteboard;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsName;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;

import com.playertour.backend.api.GolfCourseSearchResult;
import com.playertour.backend.api.GolfCourseSearchResults;
import com.playertour.backend.api.PlayerApiFactory;
import com.playertour.backend.api.PlayerProfile;
import com.playertour.backend.apis.player.PlayerService;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;


@RequireHttpWhiteboard
@JaxrsResource
@JaxrsName("Playerprofile Resource")
@Component(service = UserResource.class, enabled = true, scope = ServiceScope.PROTOTYPE)
@Path("/playerprofile")
public class UserResource {
	
	@Reference
	private PlayerService playerService;
	
	private static final String PLAYER_PROFILE_URI = "http://theplayertour.com/backend/api/1.0#//PlayerProfile";

	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Operation(description = "Provides the profile of the currently logged in user. "
			+ "If the User does not exist, a new Profile is created on the fly.",
    	responses = {  
                 @ApiResponse(
                		 responseCode = "200",
             	         description = "Returns a PlayerProfile of the logged in user.",
                		 content = {
                		 @Content(mediaType = MediaType.APPLICATION_JSON,
                				 schema = @Schema(
                						 implementation = PlayerProfile.class))
                 }),
                 @ApiResponse(
                		 responseCode = "401",
                		 description = "If no or Invalid token is provided."
                 ),
				}
			)
	public Response get() {
		String userId = "abcdef";
		PlayerProfile p = playerService.getPlayerProfile(userId);
		return Response.ok(p).build();
	}

	@POST
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Operation(description = "Saves the User Profle. " + 
	"If the User does not exist, a new Player is created on the fly.",
            responses = {  
                         @ApiResponse(
                        		 responseCode = "200",
                        		 description = "Returns the saved profile",
                        		 content = {
                        		 @Content(mediaType = MediaType.APPLICATION_JSON,
                        				 schema = @Schema(
                        						 implementation = PlayerProfile.class))
                         })
						}
	)
	public Response post(@RootElement(rootClassUri = PLAYER_PROFILE_URI) PlayerProfile profile) {
		String userId = "abcdef";
		PlayerProfile returnProfile = playerService.saveProfile(profile, userId);
		return Response.ok(returnProfile).build();
	}
	
	@GET
	@Path("visited")
	@Produces(MediaType.APPLICATION_JSON)
	@Operation(description = "Returns the Golf courses a Use has already visited.",
	responses = {  
			@ApiResponse(
					responseCode = "200",
	                description = "Returns a GolfCourseSearchResults with the list of GolfCourse matching the search criteria.",
					content = {
							@Content(mediaType = MediaType.APPLICATION_JSON,
									schema = @Schema(
											implementation = GolfCourseSearchResults.class))
					}),
			@ApiResponse(
					responseCode = "204",
					description = "If no GolfCourses have been visited."
				),
			@ApiResponse(
					responseCode = "401",
					description = "If no or Invalid token is provided."
					)
	}
			)
	public Response visitedCourses() {
		String userId = "abcdef";
		List<GolfCourseSearchResult> courses = playerService.visitedGolfCourses(userId);
		if(courses.isEmpty()) {
			return Response.noContent().build();
		}
		GolfCourseSearchResults result = PlayerApiFactory.eINSTANCE.createGolfCourseSearchResults();
		result.getResults().addAll(courses);
		return Response.ok(result).build();
	}
	

}
