/**
 * Copyright (c) 2012 - 2022 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package com.playertour.backend.security.keycloakadmin.service.tests;

import static org.assertj.core.api.Assertions.assertThat;

import org.apache.commons.lang3.RandomStringUtils;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.platform.commons.annotation.Testable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.test.common.annotation.InjectBundleContext;
import org.osgi.test.common.annotation.InjectService;
import org.osgi.test.common.service.ServiceAware;
import org.osgi.test.junit5.context.BundleContextExtension;
import org.osgi.test.junit5.service.ServiceExtension;

import com.playertour.backend.security.keycloakadmin.service.api.KeycloakAdminService;

@Testable
@ExtendWith(BundleContextExtension.class)
@ExtendWith(ServiceExtension.class)
@TestMethodOrder(MethodOrderer.OrderAnnotation.class)
public class KeycloakAdminServiceIntegrationTest {

	@InjectBundleContext
	BundleContext bundleContext;

	@Order(value = -1)
	@Test
	public void testServices(
			@InjectService(cardinality = 1, timeout = 5000) ServiceAware<KeycloakAdminService> keycloakAdminServiceAware) {

		assertThat(keycloakAdminServiceAware.getServices()).hasSize(1);
		ServiceReference<KeycloakAdminService> possibleCheatsReportingServiceReference = keycloakAdminServiceAware
				.getServiceReference();
		assertThat(possibleCheatsReportingServiceReference).isNotNull();
	}

	@Test
	public void testDeletePlayerFromKeycloak(
			@InjectService(cardinality = 1, timeout = 5000) ServiceAware<KeycloakAdminService> keycloakAdminServiceAware)
			throws InterruptedException {

		assertThat(keycloakAdminServiceAware.getServices()).hasSize(1);
		KeycloakAdminService keycloakAdminService = keycloakAdminServiceAware.getService();
		assertThat(keycloakAdminService).isNotNull();

		int keycloakUsersCountBeforeCreation = keycloakAdminService.getUsersCount();
		assertThat(keycloakUsersCountBeforeCreation).isGreaterThanOrEqualTo(0);

		String userid = keycloakAdminService.createUser(RandomStringUtils.randomAlphanumeric(10));
		assertThat(userid).isNotNull();

		int keycloakUsersCountAfterCreation = keycloakAdminService.getUsersCount();
		assertThat(keycloakUsersCountAfterCreation).isEqualTo(keycloakUsersCountBeforeCreation + 1);

		boolean userDeleted = keycloakAdminService.deleteUser(userid);
		assertThat(userDeleted).isTrue();

		int keycloakUsersCountAfterDeletion = keycloakAdminService.getUsersCount();
		assertThat(keycloakUsersCountAfterDeletion).isEqualTo(keycloakUsersCountBeforeCreation);
	}
}
