/**
 * Copyright (c) 2012 - 2021 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package com.playertour.backend.security;

/**
 * 
 * @author mhs
 * @since Apr 28, 2021
 */
public class KeycloakConfiguration {
	private String oidBaseUrl;
	private String oidRealm;
	private String oidClientId;
	
	public KeycloakConfiguration(String oidBaseUrl, String oidRealm, String oidClientId) {
		this.oidBaseUrl = oidBaseUrl;
		this.oidRealm = oidRealm;
		this.oidClientId = oidClientId;
	}
	
	public String getOidBaseUrl() {
		return oidBaseUrl;
	}
	
	public String getOidRealm() {
		return oidRealm;
	}
	
	public String getOidClientId() {
		return oidClientId;
	}
	
	@Override
	public String toString() {
		return "KeycloakConfiguration [oidBaseUrl=" + oidBaseUrl + ", oidRealm=" + oidRealm + ", oidClientId="
				+ oidClientId + "]";
	}
}
