/**
 * Copyright (c) 2012 - 2018 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package com.playertour.backend.security;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ComponentPropertyType;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.pac4j.core.authorization.authorizer.Authorizer;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.CommonProfile;

@Component(name="PlayerAuthorizer", configurationPolicy = ConfigurationPolicy.REQUIRE )
@Designate(ocd = PlayerAuthorizer.Config.class)
public class PlayerAuthorizer implements Authorizer<CommonProfile> {
	
	private List<String> rolesAllowed;

	@ComponentPropertyType
	@ObjectClassDefinition
	@interface Config {
		public String[] roles_allowed(); 
	}

	@Activate
	public void activate(Config config) {
		if(config.roles_allowed() != null) {
			rolesAllowed = Arrays.asList(config.roles_allowed());
		} else {
			rolesAllowed = Collections.emptyList();
		}
	}

	/* 
	 * (non-Javadoc)
	 * @see org.pac4j.core.authorization.authorizer.Authorizer#isAuthorized(org.pac4j.core.context.WebContext, java.util.List)
	 */
	@Override
	public boolean isAuthorized(WebContext context, List<CommonProfile> profiles) {
		for(CommonProfile profile : profiles) {
			@SuppressWarnings("unchecked")
			List<String> groups = (List<String>) profile.getAttribute("roles");
			if(groups != null) {
				if(rolesAllowed.stream().filter(groups::contains).findFirst().isPresent()) {
					return true;
				}
			}
		}
		
		return false;
	}	
	
}
