/**
 * Copyright (c) 2012 - 2021 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package com.playertour.backend.test.setup;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

import com.playertour.backend.golfcourse.model.golfcourse.Geometry;
import com.playertour.backend.golfcourse.model.golfcourse.GeometryType;
import com.playertour.backend.golfcourse.model.golfcourse.GolfCourseFactory;
import com.playertour.backend.golfcourse.model.golfcourse.Shape;
import com.playertour.backend.golfcourse.model.golfcourse.ShapeObject;

/**
 * 
 * @author ilenia
 * @since Mar 9, 2021
 */
public class XMLReader {

	public static Map<String, ShapeObject> extractShapeObjects(String xmlFile) {


		Map<String, ShapeObject> shapeObjs = new HashMap<String, ShapeObject> ();	
		try   {  
			NodeList nodeList = extractRootElement(xmlFile);
			Map<String, Shape> objectsMap = doExtractObjects(nodeList);
			objectsMap.forEach((k,v) -> {
				ShapeObject shapeObj = GolfCourseFactory.eINSTANCE.createShapeObject();
				shapeObj.setShapeCount(1);		
				shapeObj.getShapes().add(v);
				shapeObjs.put(k, shapeObj);
			});
		} catch (Exception e) {  
			e.printStackTrace();  
		} 
		return shapeObjs;
	}  

	private static NodeList extractRootElement(String xmlFile) throws IOException, ParserConfigurationException, SAXException  {
		File file = new File(xmlFile);  
		//an instance of factory that gives a document builder  
		DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();  
		//an instance of builder to parse the specified xml file  
		DocumentBuilder db = dbf.newDocumentBuilder();  
		Document doc = db.parse(file);  
		doc.getDocumentElement().normalize();  
		NodeList nodeList = doc.getElementsByTagName("Document");  
		return nodeList;
	}

	private static Map<String, Shape> doExtractObjects(NodeList nodeList) {
		Map<String, Shape> objects = new HashMap<String, Shape>();

		for (int itr = 0; itr < nodeList.getLength(); itr++)   
		{  
			Node node = nodeList.item(itr);  				
			for(int i = 0; i < node.getChildNodes().getLength(); i++) {
				Node child = node.getChildNodes().item(i);
				if("Placemark".equals(child.getNodeName())) {
					if(child.getNodeType() == Node.ELEMENT_NODE) {
						Shape shape = GolfCourseFactory.eINSTANCE.createShape();
						Geometry geometry = GolfCourseFactory.eINSTANCE.createGeometry();
						Element eElement = (Element) child;
						if(eElement.getElementsByTagName("Polygon") != null) {
							geometry.setType(GeometryType.POLYGON);
						} 
						else if(eElement.getElementsByTagName("LineString") != null) {
							geometry.setType(GeometryType.LINE_STRING);
						}
						else if(eElement.getElementsByTagName("Point") != null) {
							geometry.setType(GeometryType.POINT);
						}
						Node coordinates = eElement.getElementsByTagName("coordinates").item(0);
						Text txt = (Text) coordinates.getFirstChild();
						Double[][] coord = extractCoordinates(txt);
						geometry.getCoordinates().add(coord);
						shape.setGeometry(geometry);
						objects.put(eElement.getElementsByTagName("name").item(0).getTextContent().strip(), shape);
					}
				}
			}
		}  		
		return objects;
	}

	private static Double[][] extractCoordinates(Text coordNode) {
		String[] data = coordNode.getData().split("\n");
		List<Double[]> coord = new LinkedList<Double[]>();
		for(String s : data) {
			if(!s.isBlank()) {
				String[] segments = s.split(",");
				coord.add(createPositionArray(Double.parseDouble(segments[0]), Double.parseDouble(segments[1])));				
			}
		}
		Double[][] coordArray = new Double[coord.size()][];
		for(int i = 0; i < coord.size(); i++) {
			coordArray[i] = coord.get(i);
		}
		return coordArray;
	}

	private static Double[] createPositionArray(double lon, double lat) {
		return new Double[] {lat, lon};
	}
}
