/**
 * Copyright (c) 2012 - 2022 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package com.playertour.backend.vaadin.helper;

import java.util.concurrent.Callable;
import java.util.concurrent.Executors;

import org.osgi.util.promise.PromiseFactory;

import com.playertour.backend.apis.progress.monitor.ProgressMonitor;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.html.Label;
import com.vaadin.flow.component.progressbar.ProgressBar;
import com.vaadin.flow.server.Command;


/**
 * 
 * @author ilenia
 * @since Mar 29, 2022
 */
public class UiUpdateThread extends Thread {

	private PromiseFactory promiseFactory = new PromiseFactory(Executors.newFixedThreadPool(4));
	
	volatile double current = 0.0;
	UI currentUI;
	ProgressBar progressBar;
	ProgressMonitor progressMonitor;
	Button btn;
	Label label;
	Callable<Void> callable;
	Callable<Void> endCall;

	/**
	 * Creates a new instance.
	 */
	public UiUpdateThread(Callable<Void> callable, UI currentUI, ProgressBar progressBar, 
			ProgressMonitor progressMonitor, Button btn, Label label) {
		this.callable = callable;
		this.currentUI = currentUI;
		this.progressBar = progressBar;
		this.progressMonitor = progressMonitor;
		this.btn = btn;
		this.label = label;
	}
	
	public void setEndCall(Callable<Void> endCall) {
		this.endCall = endCall;
	}

	@Override
	public void run() {
		
		currentUI.access(new Command() {
			/** serialVersionUID */
			private static final long serialVersionUID = 7262570483927202816L;
			@Override
			public void execute() {
				progressBar.setVisible(true);
				btn.setEnabled(false);
				label.setVisible(true);
			}
		});

		promiseFactory.submit(callable)
		.onFailure(t->t.getMessage())
		.onSuccess(s -> {
			executeUICommands();
			executeEndCall();
		});
	}
	
	private void executeEndCall() {
		if(endCall != null) {
			try {
				endCall.call();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}
	
	private void executeUICommands() {
		currentUI.access(new Command() {

			/** serialVersionUID */
			private static final long serialVersionUID = 1L;

			@Override
			public void execute() {				
				label.setText("Done!");
			}
		});
		
//		Let the "Done!" for a while
		try {
			Thread.sleep(2000);			
		} catch(InterruptedException e) {
			e.printStackTrace();
		}
		
		
		currentUI.access(new Command() {

			/** serialVersionUID */
			private static final long serialVersionUID = -5517280718579203402L;

			@Override
			public void execute() {				
				progressBar.setValue(0.);
				progressBar.setVisible(false);
				progressMonitor.reset();
				
				// Stop polling
				currentUI.setPollInterval(-1);
				label.setText("");
				label.setVisible(false);
				btn.setEnabled(true);					
			}			
		});
	}
}
