/**
 * Copyright (c) 2012 - 2021 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package com.playertour.backend.vaadin.security;

import static com.playertour.backend.vaadin.security.KeycloakSecuredVaadinConstants.keycloakInitFailedMessage;

import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.log.Logger;

import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.applayout.AppLayout;
import com.vaadin.flow.component.notification.Notification;

/**
 * 
 * @author mhs, ilenia
 * @since Apr 28, 2021
 */
public abstract class AbstractKeycloakSecuredVaadinMainView extends AppLayout implements KeycloakSecuredVaadinView {

	
	/** serialVersionUID */
	private static final long serialVersionUID = -4772088641510341984L;

	protected Logger logger;

	protected ConfigurationAdmin configurationAdmin;

	protected String keycloakUsername;

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.playertour.backend.vaadin.security.KeycloakSecuredVaadinView#
	 * keycloakInitFailed()
	 */
	@Override
	@ClientCallable
	public void keycloakInitFailed() {
		logger.error(keycloakInitFailedMessage);
		Notification.show(keycloakInitFailedMessage);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.playertour.backend.vaadin.security.KeycloakSecuredVaadinView#
	 * keycloakAuthSuccessful()
	 */
	@Override
	@ClientCallable
	public void keycloakAuthSuccessful() {
		renderView();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.playertour.backend.vaadin.security.KeycloakSecuredVaadinView#
	 * setKeycloakUsername(java.lang.String)
	 */
	@Override
	@ClientCallable
	public void setKeycloakUsername(String keycloakUsername) {
		logger.debug("keycloakUsername: " + keycloakUsername);
		this.keycloakUsername = keycloakUsername;
	}
	
	@Activate
	public void activate() {
		try {
			KeycloakSecuredVaadinHelper.INSTANCE.enableKeycloakAuthentication(this.configurationAdmin, UI.getCurrent(),
					this);
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
	}

	abstract public void renderView();

}
