/**
 * Copyright (c) 2012 - 2021 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package com.playertour.backend.vaadin.views.map;

import com.playertour.backend.vaadin.views.map.MapView.DisplayedCourse;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.page.PendingJavaScriptResult;

/**
 * 
 * @author ilenia
 * @since Jun 28, 2021
 */
@CssImport("leaflet/dist/leaflet.css")
@JsModule("./components/leafletmap/leaflet-golf-map.ts")
@Tag("leaflet-golf-map")
public class LeafletGolfMap extends Component implements HasSize {

	private static final long serialVersionUID = 1L;

	public void setView(double latitude, double longitude, int zoomLevel) {		
		getElement().callJsFunction("setView", latitude, longitude, zoomLevel);
	}

	public PendingJavaScriptResult getCurrentLatitude() {
		PendingJavaScriptResult jsRes = getElement().callJsFunction("getCurrentLatitude");
		return jsRes;
	}

	public PendingJavaScriptResult getCurrentLongitude() {
		PendingJavaScriptResult jsRes = getElement().callJsFunction("getCurrentLongitude");
		return jsRes;
	}

	public void setUpdateRadius(double radius) {
		getElement().callJsFunction("setUpdateRadius", radius);
	}

	public void showUpdateArea() {
		getElement().callJsFunction("showUpdateArea");
	}
	
	public void removeUpdateArea() {
		getElement().callJsFunction("removeUpdateArea");
	}
	
	public void showCourse(DisplayedCourse course) {
		getElement().callJsFunction("showCourse", course.getLatitude(), course.getLongitude(), 
				course.getName(), course.isInvalid(), course.isTotallyInvalid());
	}

	public void removeCourses() {
		getElement().callJsFunction("removeCourses");
	}



}


