class MapUtil {

  createGeoObjs(result: any) {
  
	let geoObjs = [];
	
//	Create Water
	if(result.water !== undefined && result.water !== null) {
		let featureColl = result.water.featureCollection;
		this.extractFeatures(featureColl, "Water", geoObjs);
	}

	
//	Create Bridges
	if(result.bridge !== undefined && result.bridge !== null) {
		let featureColl = result.bridge.featureCollection;
		this.extractFeatures(featureColl, "Bridge", geoObjs);
	}
	
//	Create Paths
	if(result.path !== undefined && result.path !== null) {
		let featureColl = result.path.featureCollection;
		this.extractFeatures(featureColl, "Path", geoObjs);
	}	
	
//	Create Background
	if(result.background !== undefined && result.background !== null) {
		let featureColl = result.background.featureCollection;
		this.extractFeatures(featureColl, "Background", geoObjs);
	}
	
//	Create Club House
	if(result.clubhouse !== undefined && result.clubhouse !== null) {
		let featureColl = result.clubhouse.featureCollection;
		this.extractFeatures(featureColl, "Clubhouse", geoObjs);
	}	
	
//	Create Creek
	if(result.creek !== undefined && result.creek !== null) {
		let featureColl = result.creek.featureCollection;
		this.extractFeatures(featureColl, "Creek", geoObjs);
	}	
	
//	Create Lava
	if(result.lava !== undefined && result.lava !== null) {
		let featureColl = result.lava.featureCollection;
		this.extractFeatures(featureColl, "Lava", geoObjs);
	}
	
//	Create Sand
	if(result.sand !== undefined && result.sand !== null) {
		let featureColl = result.sand.featureCollection;
		this.extractFeatures(featureColl, "Sand", geoObjs);
	}
	
//	Create Pond
	if(result.pond !== undefined && result.pond !== null) {
		let featureColl = result.pond.featureCollection;
		this.extractFeatures(featureColl, "Pond", geoObjs);
	}
	
//	Create Ocean
	if(result.ocean !== undefined && result.ocean !== null) {
		let featureColl = result.ocean.featureCollection;
		this.extractFeatures(featureColl, "Ocean", geoObjs);
	}
	
//	Create Vegetation
	if(result.vegetation !== undefined && result.vegetation !== null) {
		let featureColl = result.vegetation.featureCollection;
		this.extractFeatures(featureColl, "Vegetation", geoObjs);
	}
	
//	Create Rock
	if(result.rock !== undefined && result.rock !== null) {
		let featureColl = result.rock.featureCollection;
		this.extractFeatures(featureColl, "Rock", geoObjs);
	}
	
//	Create Lake
	if(result.lake !== undefined && result.lake !== null) {
		let featureColl = result.lake.featureCollection;
		this.extractFeatures(featureColl, "Lake", geoObjs);
	}
	
	
//	Create the Holes
	let holeList = result.holes;
	for(let j = 0; j < holeList.length; j++) {
		let hole = holeList[j];
		let holeNum = hole.holeNumber;
		
		//GreenCenter
		if(hole.greenCenter !== undefined && hole.greenCenter !== null) {
			let featureColl = hole.greenCenter.featureCollection;
			this.extractFeatures(featureColl, "Greencenter", geoObjs, holeNum);
		}
		
		//Perimeter
		if(hole.perimeter !== undefined && hole.perimeter !== null) {
			let featureColl = hole.perimeter.featureCollection;
			this.extractFeatures(featureColl, "Perimeter", geoObjs);
		}
		
		//TeeBox
		if(hole.teebox !== undefined && hole.teebox !== null) {
			let featureColl = hole.teebox.featureCollection;
			this.extractFeatures(featureColl, "Teebox", geoObjs);
		}
		
		//TeeBoxCenter
		if(hole.teeboxCenter !== undefined && hole.teeboxCenter !== null) {
			let featureColl = hole.teeboxCenter.featureCollection;
			this.extractFeatures(featureColl, "Teeboxcenter", geoObjs);
		}
		
		//Fairway
		if(hole.fairway !== undefined && hole.fairway !== null) {
			let featureColl = hole.fairway.featureCollection;
			this.extractFeatures(featureColl, "Fairway", geoObjs);
		}
		
		//Green
		if(hole.green !== undefined && hole.green !== null) {
			let featureColl = hole.green.featureCollection;
			this.extractFeatures(featureColl, "Green", geoObjs);
		}
		
		//CentralPath
		if(hole.centralPath !== undefined && hole.centralPath !== null) {
			let featureColl = hole.centralPath.featureCollection;
			this.extractFeatures(featureColl, "Centralpath", geoObjs);
		}		
		
		//Bunker
		if(hole.bunker !== undefined && hole.bunker !== null) {
			let featureColl = hole.bunker.featureCollection;
			this.extractFeatures(featureColl, "Bunker", geoObjs);
		}		
	}	
	return geoObjs;
  }
  
  extractFeatures(featureColl: any, labelPrefix: string, geoObjs: any, holeNum = undefined) {
	let features = featureColl.features;
	for(let i = 0; i < features.length; i++) {
		let feature = features[i];
		if(feature === null || feature === undefined) {
			console.log("Feature is null for " + labelPrefix + i);
			continue;
		}
		if(feature.geometry === null || feature.geometry === undefined) {
			console.log("Geometry is null for " + labelPrefix + i);
			continue;
		}
		if(feature.geometry.coordinates === null || feature.geometry.coordinates === undefined) {
			console.log("Coordinate is null for " + labelPrefix + i);
			continue;
		}
		feature.properties.label = labelPrefix+i;
		if(holeNum !== undefined) {
			feature.properties.holeNum = holeNum;
		}
		geoObjs.push(feature);
	}
  }
}
export { MapUtil };
