import * as L from 'leaflet';
import { customElement, html, LitElement, PropertyValues } from 'lit-element';
import { nothing } from 'lit-html';
import 'leaflet/dist/leaflet.css';

const openStreetMapLayer = 'https://server.arcgisonline.com/ArcGIS/rest/services/World_Imagery/MapServer/tile/{z}/{y}/{x}.png';
const openStreetMapAttribution = `&copy; <a href="https://www.esri.com/">Esri</a> contributors`;

@customElement('leaflet-golf-map')
export class LeafletMap extends LitElement {
  private map!: L.Map;
  private circle!: L.Circle | undefined = undefined;
  private coursesLayer! : L.FeatureGroup;
  private geoJSONLayer!: any | undefined = undefined;
  private updateRadius!: number = 500000; //500 km default (500 miles max radius for request within dist to iGolf API)
  
  createRenderRoot() {
    // Do not use a shadow root
    return this;
  }

  render() {
    return html`${nothing}`;
  }

  firstUpdated(_changedProperties: PropertyValues) {
    super.firstUpdated(_changedProperties);

    this.map = L.map(this);
    let tileLayer = L.tileLayer(openStreetMapLayer, { attribution: openStreetMapAttribution, maxZoom: 22 });
    tileLayer.addTo(this.map);  
    
    this.coursesLayer = L.featureGroup();
    
    this.coursesLayer.addTo(this.map);
    /*this.map.on('click', function(ev){
   	console.log("I am in the click " + ev.latlng.lat);
   	console.log("I am in the click " + ev.latlng.lng);
    	this.setView(ev.latlng.lat, ev.latlng.lng, 5);
     });*/ 
  }

  async setView(latitude: number, longitude: number, zoomLevel: number) {
    await this.updateComplete; // Make sure map has been initialized
    this.map.setView([latitude, longitude], zoomLevel);
  }
  
  async addClickListener() {
   await this.updateComplete; // Make sure map has been initialized
   
  }
  
  async getCurrentLatitude() {
    await this.updateComplete; // Make sure map has been initialized
    return this.map.getCenter().lat;
  }
  
  async getCurrentLongitude() {
    await this.updateComplete; // Make sure map has been initialized
    return this.map.getCenter().lng;
  }
  
  async setUpdateRadius(radius: number) {
   await this.updateComplete; // Make sure map has been initialized
   this.updateRadius = radius;
  }
  
  async showUpdateArea() {

    await this.updateComplete; // Make sure map has been initialized

    if(this.circle !== undefined){
        console.log("Removing update area within function");
        this.circle.removeFrom(this.map); 
      }

    this.circle = L.circle(this.map.getCenter(), {
          color: "grey",
          fillColor: "#7B7B7B",
          fillOpacity: 0.5,
          radius: this.updateRadius
      }).addTo(this.map);    
  }
  
  async removeUpdateArea() {
    await this.updateComplete; // Make sure map has been initialized

    if(this.circle !== undefined){
        console.log("Removing update area");
        this.circle.removeFrom(this.map); 
      }
  }
  
  async showCourse(latitude: number, longitude: number, name: String, isInvalid: Boolean, isTotallyInvalid: Boolean) {  	
      await this.updateComplete; // Make sure map has been initialized
      let color = "green";
      let fillColor = "#2AAD27";
      if(isTotallyInvalid == true) {
      	color = "red";
      	fillColor = "#f03"
      }
      else if(isInvalid == true) {
       color = "yellow";
       fillColor = "#CAC428";
      }
      let courseCircle = L.circle([latitude, longitude], {
          color: color,
          fillColor: fillColor,
          fillOpacity: 0.5,
          radius: 500
      }).bindPopup(name);
      
      courseCircle.on("click", function(evt) {
      	  courseCircle.openPopup(evt.latlng);
      });

      this.coursesLayer.addLayer(courseCircle);    
  }
  
  async removeCourses() {
      await this.updateComplete; // Make sure map has been initialized
      if(this.coursesLayer !== undefined) {
      	this.coursesLayer.clearLayers();
      }
  }
  
  
}
