package com.playertour.backend.vaadin.views.index;
/**
 * Copyright (c) 2012 - 2021 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */

import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import java.util.concurrent.Executors;

import org.gecko.search.util.CommonIndexService;
//import org.gecko.search.util.CommonIndexService;
import org.gecko.vaadin.whiteboard.annotations.VaadinComponent;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;
import org.osgi.service.log.Logger;
import org.osgi.service.log.LoggerFactory;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;

import com.playertour.backend.vaadin.views.main.MainView;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.CheckboxGroup;
import com.vaadin.flow.component.checkbox.CheckboxGroupVariant;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;

/**
 * Admin View to trigger the index of GolfCourses, Countries and Players
 * 
 * @author ilenia
 * @since Apr 7, 2021
 */
@Route(value = "index", layout = MainView.class)
@PageTitle("Trigger Index")
@Component(name = "IndexView", service = IndexView.class, scope = ServiceScope.PROTOTYPE)
@VaadinComponent()
public class IndexView extends VerticalLayout {

	/** serialVersionUID */
	private static final long serialVersionUID = -148719797274231521L;
	private Logger logger;
	
	private static final String OPTION_INDEX_COURSES = "Index Golf Courses";
	private static final String OPTION_INDEX_PLAYERS = "Index Players";
	
	private CheckboxGroup<String> optionsCheckboxGroup;
	private Set<String> selection;
	private Button indexBtn;

	@Reference(target = "(component.name=CourseIndexService)")
	CommonIndexService courseIndex;

	@Reference(target = "(component.name=PlayerIndexService)")
	CommonIndexService playerIndex;
	
	@Reference(service = LoggerFactory.class)
	void setLogger(Logger logger) {
		this.logger = logger;
	}

	private PromiseFactory factory = new PromiseFactory(Executors.newFixedThreadPool(4));

	@Activate
	public void renderView() {
		addClassName("index-view"); //this should be the same as the css file name for that view
		
		optionsCheckboxGroup = new CheckboxGroup<String>();
		optionsCheckboxGroup.setLabel("Select the items to be indexed:");
		optionsCheckboxGroup.setItems(OPTION_INDEX_COURSES, OPTION_INDEX_PLAYERS);
		optionsCheckboxGroup.addThemeVariants(CheckboxGroupVariant.LUMO_VERTICAL);
		optionsCheckboxGroup.setWidthFull();
		optionsCheckboxGroup.addValueChangeListener(event -> {
			
			if(event.getValue() == null || event.getValue().isEmpty()) {
				if(indexBtn != null) {
					indexBtn.setVisible(false);
				}
			}
			else {
				selection = event.getValue();
				if(indexBtn == null) {
					indexBtn = new Button("Index!");
					indexBtn.addClickListener(evt -> {
						doIndex(selection);
					});
					
					add(indexBtn);					
				}
				indexBtn.setVisible(true);				
			}
			
		});
		
		add(optionsCheckboxGroup);	
	}

	
	private void doIndex(Set<String> selection) {
		if(selection.contains(OPTION_INDEX_COURSES)) {
			Promise<Boolean> result = factory.submit(() -> {
				courseIndex.initializeIndex();
				return true;
			}).onSuccess(t -> logger.info("Finished Index Courses!")).onFailure(t -> t.printStackTrace());
			try {
				result.getValue();
				Notification.show("Courses indexed succesfully!");
			} catch (InvocationTargetException | InterruptedException e) {
				Notification.show("Error occurred during Courses index!");
			}
		}
		else if(selection.contains(OPTION_INDEX_PLAYERS)) {
			Promise<Boolean> result = factory.submit(() -> {
				playerIndex.initializeIndex();
				return true;
			}).onSuccess(t -> logger.info("Finished Index Players!")).onFailure(t -> t.printStackTrace());
			try {
				result.getValue();
				Notification.show("Players indexed succesfully!");
			} catch (InvocationTargetException | InterruptedException e) {
				Notification.show("Error occurred during Players index!");
			}
		}		
	}
}
