/**
 * Copyright (c) 2012 - 2022 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package com.playertour.backend.vaadin.views.update;

import java.util.Map;

import com.playertour.backend.apis.igolf.IGolfUpdateConstants;

/**
 * 
 * @author ilenia
 * @since Apr 6, 2022
 */
public interface UpdateViewConstants {
	
	public static final Map<String, String> IGOLF_UI_CONTINENT_NAME_MAP = Map.of(IGolfUpdateConstants.UPDATE_COUNTRIES_AFIRCA, UpdateViewConstants.UPDATE_OPTION_AFRICA,
			IGolfUpdateConstants.UPDATE_COUNTRIES_ASIA, UpdateViewConstants.UPDATE_OPTION_ASIA,
			IGolfUpdateConstants.UPDATE_COUNTRIES_EUROPE, UpdateViewConstants.UPDATE_OPTION_EUROPE, 
			IGolfUpdateConstants.UPDATE_COUNTRIES_NORTH_AMERICA, UpdateViewConstants.UPDATE_OPTION_NORTH_AMERICA, 
			IGolfUpdateConstants.UPDATE_COUNTRIES_OCEANIA, UpdateViewConstants.UPDATE_OPTION_OCEANIA, 
			IGolfUpdateConstants.UPDATE_COUNTRIES_SOUTH_AMERICA, UpdateViewConstants.UPDATE_OPTION_SOUTH_AMERICA);
	public static final Map<String, String> UI_IGOLF_CONTINENT_NAME_MAP = Map.of(UpdateViewConstants.UPDATE_OPTION_AFRICA, IGolfUpdateConstants.UPDATE_COUNTRIES_AFIRCA,
			UpdateViewConstants.UPDATE_OPTION_ASIA, IGolfUpdateConstants.UPDATE_COUNTRIES_ASIA, 
			UpdateViewConstants.UPDATE_OPTION_EUROPE,  IGolfUpdateConstants.UPDATE_COUNTRIES_EUROPE, 
			UpdateViewConstants.UPDATE_OPTION_NORTH_AMERICA, IGolfUpdateConstants.UPDATE_COUNTRIES_NORTH_AMERICA,  
			UpdateViewConstants.UPDATE_OPTION_OCEANIA, IGolfUpdateConstants.UPDATE_COUNTRIES_OCEANIA, 
			UpdateViewConstants.UPDATE_OPTION_SOUTH_AMERICA, IGolfUpdateConstants.UPDATE_COUNTRIES_SOUTH_AMERICA);
	
	public static final String UPDATE_OPTION_NORTH_AMERICA = "North America";
	public static final String UPDATE_OPTION_SOUTH_AMERICA = "South America";
	public static final String UPDATE_OPTION_EUROPE = "Europe";
	public static final String UPDATE_OPTION_ASIA = "Asia";
	public static final String UPDATE_OPTION_AFRICA = "Africa";
	public static final String UPDATE_OPTION_OCEANIA = "Oceania";
	public static final String UPDATE_OPTION_ALL = "All";
	
	public static final String UPDATE_OPTION_IGOLF_DB = "Update IGolf DB";
	public static final String UPDATE_OPTION_PLAYERTOUR_DB = "Update Playertour DB";
	public static final String UPDATE_OPTION_SHOW_SUMMARY = "Show Summary";
	
	public static final String UPDATE_OPTION_BY_CONTINENT = "By Continent";
	public static final String UPDATE_OPTION_BY_COUNTRY = "By Country";
	public static final String UPDATE_OPTION_BY_STATE = "By State";
	
	
	public static final String UPDATE_VIEW_SELECT_CONTINENT_LABEL = "Select continent:";
	public static final String UPDATE_VIEW_SELECT_COUNTRY_LABEL = "Select country:";
	public static final String UPDATE_VIEW_SELECT_STATE_LABEL = "Select state:";
	
	public static final String UPDATE_VIEW_GRID_COUNTRY_COL_KEY = "grid-country-column";
	public static final String UPDATE_VIEW_GRID_STATE_COL_KEY = "grid-state-column";
	
	public static final String UPDATE_VIEW_BTN_LABEL = "Update!";
	public static final String UPDATE_VIEW_FORCE_CONVERSION_LABEL = "Force Conversion";



}
