/**
 * Copyright (c) 2012 - 2022 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made available under the terms of the 
 * Eclipse Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package com.playertour.backend.vaadin.views.users;

import java.math.BigDecimal;

/**
 * 
 * @author ilenia
 * @since Sep 27, 2022
 */
class DisplayedUser {
	
	String loginId;
	String username;
	String country;
	Integer meritPoints;
	Integer meritPointsBeforeEdit;
	
	DisplayedUser(String loginId, String username, String country, BigDecimal meritPoints) {
		this.loginId = loginId;
		this.username = username;
		this.country = country;
		this.meritPoints = meritPoints.intValue();
		this.meritPointsBeforeEdit = meritPoints.intValue();
	}
	
	String getLoginId() {
		return loginId;
	}

	String getUsername() {
		return username;
	}

	String getCountry() {
		return country;
	}

	Integer getMeritPoints() {
		return meritPoints;
	}
	
	Integer getMeritPointsBeforeEdit() {
		return meritPointsBeforeEdit;
	}
	
	void setMeritPoints(Integer meritPoints) {
		this.meritPointsBeforeEdit = this.meritPoints;
		this.meritPoints = meritPoints;
	}

}
